/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.artifacts;

import com.intellij.facet.impl.DefaultFacetsProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.ui.configuration.DefaultModulesProvider;
import com.intellij.openapi.roots.ui.configuration.FacetsProvider;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactModel;
import com.intellij.packaging.elements.ManifestFileProvider;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.DefaultManifestFileProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultPackagingElementResolvingContext
implements PackagingElementResolvingContext {
    private final Project myProject;
    private final DefaultModulesProvider myModulesProvider;

    public DefaultPackagingElementResolvingContext(Project project2) {
        this.myProject = project2;
        this.myModulesProvider = new DefaultModulesProvider(this.myProject);
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public ArtifactModel getArtifactModel() {
        return ArtifactManager.getInstance((Project)this.myProject);
    }

    @NotNull
    public ModulesProvider getModulesProvider() {
        return this.myModulesProvider;
    }

    @NotNull
    public FacetsProvider getFacetsProvider() {
        return DefaultFacetsProvider.INSTANCE;
    }

    public Library findLibrary(@NotNull String level, @NotNull String libraryName) {
        return DefaultPackagingElementResolvingContext.findLibrary(this.myProject, level, libraryName);
    }

    @NotNull
    public ManifestFileProvider getManifestFileProvider() {
        return new DefaultManifestFileProvider(this);
    }

    @Nullable
    public static Library findLibrary(Project project2, String level, String libraryName) {
        LibraryTable table = LibraryTablesRegistrar.getInstance().getLibraryTableByLevel(level, project2);
        return table != null ? table.getLibraryByName(libraryName) : null;
    }
}

