/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies.ui;

import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfoToUsageConverter;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.Alarm;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class UsagesPanel
extends JPanel
implements Disposable,
DataProvider {
    protected static final Logger LOG = Logger.getInstance((String)"#com.intellij.packageDependencies.ui.UsagesPanel");
    private final Project myProject;
    protected ProgressIndicator myCurrentProgress;
    private JComponent myCurrentComponent;
    private UsageView myCurrentUsageView;
    protected final Alarm myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);

    public UsagesPanel(Project project2) {
        super(new BorderLayout());
        this.myProject = project2;
    }

    public void setToInitialPosition() {
        this.cancelCurrentFindRequest();
        this.setToComponent(UsagesPanel.createLabel(this.getInitialPositionText()));
    }

    public abstract String getInitialPositionText();

    public abstract String getCodeUsagesString();

    protected void cancelCurrentFindRequest() {
        if (this.myCurrentProgress != null) {
            this.myCurrentProgress.cancel();
        }
    }

    protected void showUsages(@NotNull PsiElement[] primaryElements, @NotNull UsageInfo[] usageInfos) {
        if (this.myCurrentUsageView != null) {
            Disposer.dispose((Disposable)this.myCurrentUsageView);
        }
        try {
            Usage[] usages = UsageInfoToUsageConverter.convert((PsiElement[])primaryElements, (UsageInfo[])usageInfos);
            UsageViewPresentation presentation = new UsageViewPresentation();
            presentation.setCodeUsagesString(this.getCodeUsagesString());
            this.myCurrentUsageView = UsageViewManager.getInstance((Project)this.myProject).createUsageView(UsageTarget.EMPTY_ARRAY, usages, presentation, null);
            this.setToComponent(this.myCurrentUsageView.getComponent());
        }
        catch (ProcessCanceledException e) {
            this.setToCanceled();
        }
    }

    private void setToCanceled() {
        this.setToComponent(UsagesPanel.createLabel(AnalysisScopeBundle.message((String)"usage.view.canceled", (Object[])new Object[0])));
    }

    protected void setToComponent(final JComponent cmp) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (UsagesPanel.this.myCurrentComponent != null) {
                    if (UsagesPanel.this.myCurrentUsageView != null && UsagesPanel.this.myCurrentComponent == UsagesPanel.this.myCurrentUsageView.getComponent()) {
                        Disposer.dispose((Disposable)UsagesPanel.this.myCurrentUsageView);
                    }
                    UsagesPanel.this.remove(UsagesPanel.this.myCurrentComponent);
                }
                UsagesPanel.this.myCurrentComponent = cmp;
                UsagesPanel.this.add((Component)cmp, "Center");
                UsagesPanel.this.revalidate();
            }
        });
    }

    public void dispose() {
        if (this.myCurrentUsageView != null) {
            Disposer.dispose((Disposable)this.myCurrentUsageView);
        }
    }

    private static JComponent createLabel(String text) {
        JLabel label = new JLabel(text);
        label.setHorizontalAlignment(0);
        return label;
    }

    @Nullable
    @NonNls
    public Object getData(@NonNls String dataId) {
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return "ideaInterface.find";
        }
        return null;
    }
}

