/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.packageDependencies.DependenciesBuilder;
import com.intellij.packageDependencies.FindDependencyUtil;
import com.intellij.packageDependencies.ui.PanelProgressIndicator;
import com.intellij.packageDependencies.ui.UsagesPanel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Consumer;
import java.awt.Component;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;

public class DependenciesUsagesPanel
extends UsagesPanel {
    private final List<DependenciesBuilder> myBuilders;

    public DependenciesUsagesPanel(Project project2, List<DependenciesBuilder> builders) {
        super(project2);
        this.myBuilders = builders;
        this.setToInitialPosition();
    }

    @Override
    public String getInitialPositionText() {
        return this.myBuilders.get(0).getInitialUsagesPosition();
    }

    @Override
    public String getCodeUsagesString() {
        return this.myBuilders.get(0).getRootNodeNameInUsageView();
    }

    public void findUsages(final Set<PsiFile> searchIn, final Set<PsiFile> searchFor) {
        this.cancelCurrentFindRequest();
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                    @Override
                    public void run() {
                        final PanelProgressIndicator progress = new PanelProgressIndicator(new Consumer<JComponent>(){

                            public void consume(JComponent component) {
                                DependenciesUsagesPanel.this.setToComponent(component);
                            }
                        });
                        DependenciesUsagesPanel.this.myCurrentProgress = progress;
                        ProgressManager.getInstance().runProcess(new Runnable(){

                            @Override
                            public void run() {
                                ApplicationManager.getApplication().runReadAction(new Runnable(){

                                    @Override
                                    public void run() {
                                        UsageInfo[] usages = new UsageInfo[]{};
                                        Set elementsToSearch = null;
                                        try {
                                            if (((DependenciesBuilder)DependenciesUsagesPanel.this.myBuilders.get(0)).isBackward()) {
                                                elementsToSearch = searchIn;
                                                usages = FindDependencyUtil.findBackwardDependencies(DependenciesUsagesPanel.this.myBuilders, (Set<PsiFile>)searchFor, (Set<PsiFile>)searchIn);
                                            } else {
                                                elementsToSearch = searchFor;
                                                usages = FindDependencyUtil.findDependencies(DependenciesUsagesPanel.this.myBuilders, (Set<PsiFile>)searchIn, (Set<PsiFile>)searchFor);
                                            }
                                            assert (!new HashSet(elementsToSearch).contains(null));
                                        }
                                        catch (ProcessCanceledException processCanceledException) {
                                        }
                                        catch (Exception e) {
                                            UsagesPanel.LOG.error((Throwable)e);
                                        }
                                        if (!progress.isCanceled()) {
                                            final UsageInfo[] finalUsages = usages;
                                            final PsiElement[] _elementsToSearch = elementsToSearch != null ? PsiUtilCore.toPsiElementArray(elementsToSearch) : PsiElement.EMPTY_ARRAY;
                                            ApplicationManager.getApplication().invokeLater(new Runnable(){

                                                @Override
                                                public void run() {
                                                    DependenciesUsagesPanel.this.showUsages(_elementsToSearch, finalUsages);
                                                }
                                            }, ModalityState.stateForComponent((Component)DependenciesUsagesPanel.this));
                                        }
                                    }
                                });
                                DependenciesUsagesPanel.this.myCurrentProgress = null;
                            }
                        }, (ProgressIndicator)progress);
                    }
                });
            }
        }, 300);
    }

    public void addBuilder(DependenciesBuilder builder) {
        this.myBuilders.add(builder);
    }
}

