/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.welcomeScreen;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerAdapter;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.IdeRootPaneNorthExtension;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WelcomeFrameProvider;
import com.intellij.openapi.wm.WelcomeScreen;
import com.intellij.openapi.wm.WelcomeScreenProvider;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.IdeGlassPaneImpl;
import com.intellij.openapi.wm.impl.IdeMenuBar;
import com.intellij.openapi.wm.impl.WindowManagerImpl;
import com.intellij.openapi.wm.impl.status.IdeStatusBarImpl;
import com.intellij.openapi.wm.impl.welcomeScreen.NewWelcomeScreen;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.BalloonLayout;
import com.intellij.ui.BalloonLayoutImpl;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextAccessor;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import org.jetbrains.annotations.Nullable;

public class WelcomeFrame
extends JFrame
implements IdeFrame,
AccessibleContextAccessor {
    public static final ExtensionPointName<WelcomeFrameProvider> EP = ExtensionPointName.create((String)"com.intellij.welcomeFrameProvider");
    static final String DIMENSION_KEY = "WELCOME_SCREEN";
    private static IdeFrame ourInstance;
    private final WelcomeScreen myScreen;
    private final BalloonLayout myBalloonLayout;

    public WelcomeFrame() {
        JRootPane rootPane = this.getRootPane();
        WelcomeScreen screen = WelcomeFrame.createScreen(rootPane);
        IdeGlassPaneImpl glassPane = new IdeGlassPaneImpl(rootPane);
        this.setGlassPane(glassPane);
        glassPane.setVisible(false);
        this.setContentPane(screen.getWelcomePanel());
        this.setTitle(ApplicationNamesInfo.getInstance().getFullProductName());
        AppUIUtil.updateWindowIcon(this);
        ProjectManager.getInstance().addProjectManagerListener((ProjectManagerListener)new ProjectManagerAdapter(){

            public void projectOpened(Project project2) {
                WelcomeFrame.this.dispose();
            }
        });
        this.myBalloonLayout = new BalloonLayoutImpl(rootPane, new Insets(8, 8, 8, 8));
        this.myScreen = screen;
        WelcomeFrame.setupCloseAction(this);
        MnemonicHelper.init((Component)this);
        this.myScreen.setupFrame((JFrame)this);
        Disposer.register((Disposable)ApplicationManager.getApplication(), (Disposable)new Disposable(){

            public void dispose() {
                WelcomeFrame.this.dispose();
            }
        });
    }

    public static IdeFrame getInstance() {
        return ourInstance;
    }

    @Override
    public void dispose() {
        WelcomeFrame.saveLocation(this.getBounds());
        super.dispose();
        Disposer.dispose((Disposable)this.myScreen);
        WelcomeFrame.resetInstance();
    }

    private static void saveLocation(Rectangle location) {
        location.y = location.height / 2;
        Point middle = new Point(location.x + location.width / 2, location.y);
        DimensionService.getInstance().setLocation(DIMENSION_KEY, middle, null);
    }

    static void setupCloseAction(final JFrame frame) {
        frame.setDefaultCloseOperation(0);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                frame.dispose();
                final Application app = ApplicationManager.getApplication();
                app.invokeLater((Runnable)new DumbAwareRunnable(){

                    public void run() {
                        if (app.isDisposed()) {
                            ApplicationManagerEx.getApplicationEx().exit();
                            return;
                        }
                        Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
                        if (openProjects.length == 0) {
                            ApplicationManagerEx.getApplicationEx().exit();
                        }
                    }
                }, ModalityState.NON_MODAL);
            }
        });
    }

    public static void clearRecents() {
        if (ourInstance != null && ourInstance instanceof WelcomeFrame) {
            WelcomeScreen welcomeScreen = ((WelcomeFrame)WelcomeFrame.ourInstance).myScreen;
        }
    }

    private static WelcomeScreen createScreen(JRootPane rootPane) {
        WelcomeScreenProvider provider;
        NewWelcomeScreen screen = null;
        WelcomeScreenProvider[] welcomeScreenProviderArray = (WelcomeScreenProvider[])WelcomeScreenProvider.EP_NAME.getExtensions();
        int n = welcomeScreenProviderArray.length;
        for (int i = 0; !(i >= n || (provider = welcomeScreenProviderArray[i]).isAvailable() && (screen = provider.createWelcomeScreen(rootPane)) != null); ++i) {
        }
        if (screen == null) {
            screen = new NewWelcomeScreen();
        }
        return screen;
    }

    public static void resetInstance() {
        ourInstance = null;
    }

    public static void showNow() {
        if (ourInstance == null) {
            WelcomeFrameProvider provider;
            WelcomeFrame frame = null;
            WelcomeFrameProvider[] welcomeFrameProviderArray = (WelcomeFrameProvider[])EP.getExtensions();
            int n = welcomeFrameProviderArray.length;
            for (int i = 0; i < n && (frame = (provider = welcomeFrameProviderArray[i]).createFrame()) == null; ++i) {
            }
            if (frame == null) {
                frame = new WelcomeFrame();
            }
            IdeMenuBar.installAppMenuIfNeeded(frame);
            ((JFrame)frame).setVisible(true);
            ourInstance = frame;
        }
    }

    public static void showIfNoProjectOpened() {
        ApplicationManager.getApplication().invokeLater((Runnable)new DumbAwareRunnable(){

            public void run() {
                WindowManagerImpl windowManager = (WindowManagerImpl)WindowManager.getInstance();
                windowManager.disposeRootFrame();
                IdeFrameImpl[] frames = windowManager.getAllProjectFrames();
                if (frames.length == 0) {
                    WelcomeFrame.showNow();
                }
            }
        }, ModalityState.NON_MODAL);
    }

    public StatusBar getStatusBar() {
        Container pane = this.getContentPane();
        return pane instanceof JComponent ? (StatusBar)UIUtil.findComponentOfType((JComponent)((JComponent)pane), IdeStatusBarImpl.class) : null;
    }

    public BalloonLayout getBalloonLayout() {
        return this.myBalloonLayout;
    }

    public Rectangle suggestChildFrameBounds() {
        return this.getBounds();
    }

    @Nullable
    public Project getProject() {
        return ProjectManager.getInstance().getDefaultProject();
    }

    public void setFrameTitle(String title) {
        this.setTitle(title);
    }

    public void setFileTitle(String fileTitle, File ioFile) {
        this.setTitle(fileTitle);
    }

    public IdeRootPaneNorthExtension getNorthExtension(String key) {
        return null;
    }

    public JComponent getComponent() {
        return this.getRootPane();
    }

    public AccessibleContext getCurrentAccessibleContext() {
        return this.accessibleContext;
    }
}

