/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.ide.util.GotoLineNumberDialog;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.EditorBasedWidget;
import com.intellij.ui.UIBundle;
import com.intellij.util.Consumer;
import java.awt.event.MouseEvent;
import org.jetbrains.annotations.NotNull;

public class PositionPanel
extends EditorBasedWidget
implements StatusBarWidget.Multiframe,
StatusBarWidget.TextPresentation,
CaretListener,
SelectionListener {
    private String myText;

    public PositionPanel(@NotNull Project project2) {
        super(project2);
    }

    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        this.updatePosition(this.getEditor());
    }

    @NotNull
    public String ID() {
        return "Position";
    }

    public StatusBarWidget copy() {
        return new PositionPanel(this.getProject());
    }

    public StatusBarWidget.WidgetPresentation getPresentation(@NotNull StatusBarWidget.PlatformType type) {
        return this;
    }

    @NotNull
    public String getText() {
        return this.myText == null ? "" : this.myText;
    }

    @NotNull
    public String getMaxPossibleText() {
        return "0000000000000";
    }

    public float getAlignment() {
        return 0.5f;
    }

    public String getTooltipText() {
        return UIBundle.message((String)"go.to.line.command.double.click", (Object[])new Object[0]);
    }

    public Consumer<MouseEvent> getClickConsumer() {
        return new Consumer<MouseEvent>(){

            public void consume(MouseEvent mouseEvent) {
                final Project project2 = PositionPanel.this.getProject();
                if (project2 == null) {
                    return;
                }
                final Editor editor = PositionPanel.this.getEditor();
                if (editor == null) {
                    return;
                }
                CommandProcessor processor2 = CommandProcessor.getInstance();
                processor2.executeCommand(project2, new Runnable(){

                    @Override
                    public void run() {
                        GotoLineNumberDialog dialog = new GotoLineNumberDialog(project2, editor);
                        dialog.show();
                        IdeDocumentHistory.getInstance(project2).includeCurrentCommandAsNavigation();
                    }
                }, UIBundle.message((String)"go.to.line.command.name", (Object[])new Object[0]), null);
            }
        };
    }

    @Override
    public void install(@NotNull StatusBar statusBar) {
        super.install(statusBar);
        EditorEventMulticaster multicaster = EditorFactory.getInstance().getEventMulticaster();
        multicaster.addCaretListener((CaretListener)this, (Disposable)this);
        multicaster.addSelectionListener((SelectionListener)this, (Disposable)this);
    }

    public void selectionChanged(SelectionEvent e) {
        this.updatePosition(e.getEditor());
    }

    public void caretPositionChanged(CaretEvent e) {
        this.updatePosition(e.getEditor());
    }

    public void caretAdded(CaretEvent e) {
        this.updatePosition(e.getEditor());
    }

    public void caretRemoved(CaretEvent e) {
        this.updatePosition(e.getEditor());
    }

    private void updatePosition(Editor editor) {
        if (editor == null) {
            this.myText = "";
        } else {
            if (!this.isOurEditor(editor)) {
                return;
            }
            this.myText = this.getPositionText(editor);
        }
        if (this.myStatusBar != null) {
            this.myStatusBar.updateWidget(this.ID());
        }
    }

    private String getPositionText(@NotNull Editor editor) {
        if (!editor.isDisposed() && this.myStatusBar != null) {
            StringBuilder message = new StringBuilder();
            SelectionModel selectionModel = editor.getSelectionModel();
            int caretCount = editor.getCaretModel().getCaretCount();
            if (caretCount > 1) {
                message.append(UIBundle.message((String)"position.panel.caret.count", (Object[])new Object[]{caretCount}));
            } else {
                if (selectionModel.hasSelection()) {
                    int selectionStart = selectionModel.getSelectionStart();
                    int selectionEnd = selectionModel.getSelectionEnd();
                    if (selectionEnd > selectionStart) {
                        message.append(UIBundle.message((String)"position.panel.selected.chars.count", (Object[])new Object[]{selectionEnd - selectionStart}));
                        int selectionStartLine = editor.getDocument().getLineNumber(selectionStart);
                        int selectionEndLine = editor.getDocument().getLineNumber(selectionEnd);
                        if (selectionEndLine > selectionStartLine) {
                            message.append(", ");
                            message.append(UIBundle.message((String)"position.panel.selected.lines.count", (Object[])new Object[]{selectionEndLine - selectionStartLine + 1}));
                        }
                        message.append("     ");
                    }
                }
                LogicalPosition caret = editor.getCaretModel().getLogicalPosition();
                message.append(caret.line + 1).append(":").append(caret.column + 1);
            }
            return message.toString();
        }
        return "";
    }
}

