/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.content;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.wm.impl.content.ComboIcon;
import com.intellij.openapi.wm.impl.content.ContentTabLabel;
import com.intellij.openapi.wm.impl.content.TabContentLayout;
import com.intellij.ui.ClickListener;
import com.intellij.ui.components.JBList;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.TabbedContent;
import com.intellij.util.NotNullFunction;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;

public class TabbedContentTabLabel
extends ContentTabLabel
implements Disposable {
    private final ComboIcon myComboIcon = new ComboIcon(){

        @Override
        public Rectangle getIconRec() {
            return new Rectangle(TabbedContentTabLabel.this.getWidth() - this.getIconWidth() - 3, 0, this.getIconWidth(), TabbedContentTabLabel.this.getHeight());
        }

        @Override
        public boolean isActive() {
            return true;
        }
    };
    private final TabbedContent myContent;
    private boolean myDisposed;

    public TabbedContentTabLabel(TabbedContent content, TabContentLayout layout) {
        super((Content)content, layout);
        this.myContent = content;
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                if (!TabbedContentTabLabel.this.myDisposed) {
                    TabbedContentTabLabel.this.showPopup();
                }
                return true;
            }
        }.installOn((Component)this);
    }

    private void showPopup() {
        IdeEventQueue.getInstance().getPopupManager().closeAllPopups();
        ArrayList<Object> names = new ArrayList<Object>();
        for (Pair tab : this.myContent.getTabs()) {
            names.add(tab.first);
        }
        final JBList list = new JBList(names);
        list.installCellRenderer((NotNullFunction)new NotNullFunction<Object, JComponent>(){
            private final JLabel label = new JLabel();
            {
                this.label.setBorder(new EmptyBorder(UIUtil.getListCellPadding()));
            }

            @NotNull
            public JComponent fun(Object dom) {
                this.label.setText(dom.toString());
                return this.label;
            }
        });
        JBPopup popup = JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setItemChoosenCallback(new Runnable(){

            @Override
            public void run() {
                int index = list.getSelectedIndex();
                if (index != -1) {
                    TabbedContentTabLabel.this.myContent.selectContent(index);
                }
            }
        }).createPopup();
        Disposer.register((Disposable)this, (Disposable)popup);
        popup.showUnderneathOf((Component)this);
    }

    @Override
    public void update() {
        super.update();
        if (this.myContent != null) {
            this.setText(this.myContent.getTabName());
        }
        this.setHorizontalAlignment(2);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        return new Dimension(size.width + 12, size.height);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.myComboIcon.paintIcon(this, g);
    }

    public void dispose() {
        this.myDisposed = true;
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        Disposer.dispose((Disposable)this);
    }
}

