/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.content;

import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.impl.content.BaseLabel;
import com.intellij.openapi.wm.impl.content.ComboContentLayout;
import com.intellij.openapi.wm.impl.content.ComboIcon;
import com.intellij.ui.Gray;
import com.intellij.ui.content.Content;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class ContentComboLabel
extends BaseLabel {
    private final ComboIcon myComboIcon = new ComboIcon(){

        @Override
        public Rectangle getIconRec() {
            return new Rectangle(ContentComboLabel.this.getWidth() - this.getIconWidth() - 3, 0, this.getIconWidth(), ContentComboLabel.this.getHeight());
        }

        @Override
        public boolean isActive() {
            return ContentComboLabel.this.myUi.myWindow.isActive();
        }
    };
    private final ComboContentLayout myLayout;

    public ContentComboLabel(ComboContentLayout layout) {
        super(layout.myUi, true);
        this.myLayout = layout;
        this.addMouseListener(new MouseAdapter(){});
        if (ScreenReader.isActive()) {
            this.setFocusable(true);
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getModifiers() == 0 && e.getKeyCode() == 32) {
                        ContentComboLabel.this.myUi.toggleContentPopup();
                    }
                    super.keyPressed(e);
                }
            });
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
        if (UIUtil.isActionClick((MouseEvent)e)) {
            this.myUi.toggleContentPopup();
        }
    }

    void update() {
        if (this.isToDrawCombo()) {
            this.setBorder(new EmptyBorder(0, 8, 0, 8));
        } else {
            this.setBorder(null);
        }
        this.updateTextAndIcon(this.myUi.myManager.getSelectedContent(), true);
    }

    @Override
    protected boolean allowEngravement() {
        return this.myUi == null || this.myUi.myWindow.isActive();
    }

    @Override
    public Dimension getPreferredSize() {
        if (!this.isToDrawCombo()) {
            return super.getPreferredSize();
        }
        int width = 0;
        for (int i = 0; i < this.myUi.myManager.getContentCount(); ++i) {
            Content content = this.myUi.myManager.getContent(i);
            assert (content != null);
            String text = content.getDisplayName();
            Icon icon = content.getUserData(ToolWindow.SHOW_CONTENT_ICON) == Boolean.TRUE ? content.getIcon() : null;
            FontMetrics metrics = this.getFontMetrics(this.getFont());
            int eachTextWidth = metrics.stringWidth(text != null ? text : "");
            int iconWidth = icon != null ? icon.getIconWidth() : 0;
            width = Math.max(eachTextWidth + iconWidth, width);
        }
        Border border = this.getBorder();
        if (border != null) {
            Insets insets = border.getBorderInsets(this);
            width += insets.left + insets.right;
        }
        return new Dimension(width += this.myComboIcon.getIconWidth(), super.getPreferredSize().height);
    }

    private boolean isToDrawCombo() {
        return this.myLayout.isToDrawCombo();
    }

    @Override
    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
        if (this.isToDrawCombo()) {
            this.myComboIcon.paintIcon(this, g);
            g.setColor(Gray._255.withAlpha(100));
        }
    }

    @Override
    public Content getContent() {
        return this.myUi.myManager.getSelectedContent();
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleContentComboLabel();
        }
        return this.accessibleContext;
    }

    protected class AccessibleContentComboLabel
    extends BaseLabel.AccessibleBaseLabel
    implements AccessibleAction {
        protected AccessibleContentComboLabel() {
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PUSH_BUTTON;
        }

        @Override
        public AccessibleAction getAccessibleAction() {
            return this;
        }

        @Override
        public int getAccessibleActionCount() {
            return 1;
        }

        @Override
        public String getAccessibleActionDescription(int index) {
            return index == 0 ? UIManager.getString("ComboBox.togglePopupText") : null;
        }

        @Override
        public boolean doAccessibleAction(int index) {
            if (index == 0) {
                ContentComboLabel.this.myUi.toggleContentPopup();
                return true;
            }
            return false;
        }
    }
}

