/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowContentUiType;
import com.intellij.openapi.wm.ToolWindowEP;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.openapi.wm.impl.DesktopLayout;
import com.intellij.openapi.wm.impl.IdeFocusManagerHeadless;
import com.intellij.openapi.wm.impl.InternalDecorator;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToolWindowHeadlessManagerImpl
extends ToolWindowManagerEx {
    private final Map<String, ToolWindow> myToolWindows = new HashMap<String, ToolWindow>();
    private final Project myProject;

    public ToolWindowHeadlessManagerImpl(Project project2) {
        this.myProject = project2;
    }

    public boolean canShowNotification(@NotNull String toolWindowId) {
        return false;
    }

    public void notifyByBalloon(@NotNull String toolWindowId, @NotNull MessageType type, @NotNull String htmlBody) {
    }

    private ToolWindow doRegisterToolWindow(final String id, @Nullable Disposable parentDisposable) {
        MockToolWindow tw = new MockToolWindow(this.myProject);
        this.myToolWindows.put(id, tw);
        if (parentDisposable != null) {
            Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

                public void dispose() {
                    ToolWindowHeadlessManagerImpl.this.unregisterToolWindow(id);
                }
            });
        }
        return tw;
    }

    @NotNull
    public ToolWindow registerToolWindow(@NotNull String id, @NotNull JComponent component, @NotNull ToolWindowAnchor anchor, Disposable parentDisposable, boolean canWorkInDumbMode) {
        return this.doRegisterToolWindow(id, parentDisposable);
    }

    @NotNull
    public ToolWindow registerToolWindow(@NotNull String id, @NotNull JComponent component, @NotNull ToolWindowAnchor anchor) {
        return this.doRegisterToolWindow(id, null);
    }

    @NotNull
    public ToolWindow registerToolWindow(@NotNull String id, @NotNull JComponent component, @NotNull ToolWindowAnchor anchor, Disposable parentDisposable, boolean canWorkInDumbMode, boolean canCloseContents) {
        return this.doRegisterToolWindow(id, parentDisposable);
    }

    @NotNull
    public ToolWindow registerToolWindow(@NotNull String id, @NotNull JComponent component, @NotNull ToolWindowAnchor anchor, @NotNull Disposable parentDisposable) {
        return this.doRegisterToolWindow(id, parentDisposable);
    }

    @NotNull
    public ToolWindow registerToolWindow(@NotNull String id, boolean canCloseContent, @NotNull ToolWindowAnchor anchor) {
        return this.doRegisterToolWindow(id, null);
    }

    @NotNull
    public ToolWindow registerToolWindow(@NotNull String id, boolean canCloseContent, @NotNull ToolWindowAnchor anchor, boolean secondary) {
        return this.doRegisterToolWindow(id, null);
    }

    @NotNull
    public ToolWindow registerToolWindow(@NotNull String id, boolean canCloseContent, @NotNull ToolWindowAnchor anchor, Disposable parentDisposable, boolean dumbAware) {
        return this.doRegisterToolWindow(id, parentDisposable);
    }

    @NotNull
    public ToolWindow registerToolWindow(@NotNull String id, boolean canCloseContent, @NotNull ToolWindowAnchor anchor, Disposable parentDisposable, boolean canWorkInDumbMode, boolean secondary) {
        return this.doRegisterToolWindow(id, parentDisposable);
    }

    public void unregisterToolWindow(@NotNull String id) {
        this.myToolWindows.remove(id);
    }

    public void activateEditorComponent() {
    }

    public boolean isEditorComponentActive() {
        return false;
    }

    @NotNull
    public String[] getToolWindowIds() {
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public String getActiveToolWindowId() {
        return null;
    }

    public ToolWindow getToolWindow(String id) {
        return this.myToolWindows.get(id);
    }

    public void invokeLater(@NotNull Runnable runnable2) {
    }

    @NotNull
    public IdeFocusManager getFocusManager() {
        return IdeFocusManagerHeadless.INSTANCE;
    }

    public void notifyByBalloon(@NotNull String toolWindowId, @NotNull MessageType type, @NotNull String text, @Nullable Icon icon, @Nullable HyperlinkListener listener2) {
    }

    public Balloon getToolWindowBalloon(String id) {
        return null;
    }

    public boolean isMaximized(@NotNull ToolWindow wnd) {
        return false;
    }

    public void setMaximized(@NotNull ToolWindow wnd, boolean maximized) {
    }

    @Override
    public void initToolWindow(@NotNull ToolWindowEP bean) {
    }

    @Override
    public void addToolWindowManagerListener(@NotNull ToolWindowManagerListener l) {
    }

    @Override
    public void addToolWindowManagerListener(@NotNull ToolWindowManagerListener l, @NotNull Disposable parentDisposable) {
    }

    @Override
    public void removeToolWindowManagerListener(@NotNull ToolWindowManagerListener l) {
    }

    @Override
    public String getLastActiveToolWindowId() {
        return null;
    }

    @Override
    public String getLastActiveToolWindowId(Condition<JComponent> condition) {
        return null;
    }

    @Override
    public DesktopLayout getLayout() {
        return new DesktopLayout();
    }

    @Override
    public void setLayoutToRestoreLater(DesktopLayout layout) {
    }

    @Override
    public DesktopLayout getLayoutToRestoreLater() {
        return new DesktopLayout();
    }

    @Override
    public void setLayout(@NotNull DesktopLayout layout) {
    }

    @Override
    public void clearSideStack() {
    }

    @Override
    public void hideToolWindow(@NotNull String id, boolean hideSide) {
    }

    @Override
    public List<String> getIdsOn(@NotNull ToolWindowAnchor anchor) {
        return new ArrayList<String>();
    }

    private static class MockContentManager
    implements ContentManager {
        private final EventDispatcher<ContentManagerListener> myDispatcher = EventDispatcher.create(ContentManagerListener.class);
        private final List<Content> myContents = new ArrayList<Content>();
        private Content mySelected;

        private MockContentManager() {
        }

        @NotNull
        public ActionCallback getReady(@NotNull Object requestor) {
            return ActionCallback.DONE;
        }

        public void addContent(@NotNull Content content) {
            this.myContents.add(content);
            ContentManagerEvent e = new ContentManagerEvent((Object)this, content, this.myContents.indexOf(content), ContentManagerEvent.ContentOperation.add);
            ((ContentManagerListener)this.myDispatcher.getMulticaster()).contentAdded(e);
            if (this.mySelected == null) {
                this.setSelectedContent(content);
            }
        }

        public void addContent(@NotNull Content content, int order) {
            this.myContents.add(order, content);
            ContentManagerEvent e = new ContentManagerEvent((Object)this, content, this.myContents.indexOf(content), ContentManagerEvent.ContentOperation.add);
            ((ContentManagerListener)this.myDispatcher.getMulticaster()).contentAdded(e);
            if (this.mySelected == null) {
                this.setSelectedContent(content);
            }
        }

        public void addContent(@NotNull Content content, Object constraints) {
            this.addContent(content);
        }

        public void addSelectedContent(@NotNull Content content) {
            this.addContent(content);
            this.setSelectedContent(content);
        }

        public void addContentManagerListener(@NotNull ContentManagerListener l) {
            this.myDispatcher.getListeners().add(0, l);
        }

        public void addDataProvider(@NotNull DataProvider provider) {
        }

        public boolean canCloseAllContents() {
            return false;
        }

        public boolean canCloseContents() {
            return false;
        }

        public Content findContent(String displayName) {
            for (Content each : this.myContents) {
                if (!each.getDisplayName().equals(displayName)) continue;
                return each;
            }
            return null;
        }

        public List<AnAction> getAdditionalPopupActions(@NotNull Content content) {
            return Collections.emptyList();
        }

        @NotNull
        public String getCloseActionName() {
            return "close";
        }

        @NotNull
        public String getCloseAllButThisActionName() {
            return "closeallbutthis";
        }

        @NotNull
        public String getPreviousContentActionName() {
            return "previous";
        }

        @NotNull
        public String getNextContentActionName() {
            return "next";
        }

        @NotNull
        public JComponent getComponent() {
            return new JLabel();
        }

        public Content getContent(JComponent component) {
            Content[] contents;
            for (Content content : contents = this.getContents()) {
                if (!Comparing.equal((Object)component, (Object)content.getComponent())) continue;
                return content;
            }
            return null;
        }

        @Nullable
        public Content getContent(int index) {
            return this.myContents.get(index);
        }

        public int getContentCount() {
            return this.myContents.size();
        }

        @NotNull
        public Content[] getContents() {
            return this.myContents.toArray(new Content[this.myContents.size()]);
        }

        public int getIndexOfContent(Content content) {
            return this.myContents.indexOf(content);
        }

        @Nullable
        public Content getSelectedContent() {
            return this.mySelected;
        }

        @NotNull
        public Content[] getSelectedContents() {
            Content[] contentArray;
            if (this.mySelected != null) {
                Content[] contentArray2 = new Content[1];
                contentArray = contentArray2;
                contentArray2[0] = this.mySelected;
            } else {
                contentArray = new Content[]{};
            }
            return contentArray;
        }

        public boolean isSelected(@NotNull Content content) {
            return content == this.mySelected;
        }

        public void removeAllContents(boolean dispose) {
            for (Content content : this.getContents()) {
                this.removeContent(content, dispose);
            }
        }

        public boolean removeContent(@NotNull Content content, boolean dispose) {
            boolean wasSelected = this.mySelected == content;
            int oldIndex = this.myContents.indexOf(content);
            if (wasSelected) {
                this.removeFromSelection(content);
            }
            boolean result = this.myContents.remove(content);
            if (dispose) {
                Disposer.dispose((Disposable)content);
            }
            ContentManagerEvent e = new ContentManagerEvent((Object)this, content, oldIndex, ContentManagerEvent.ContentOperation.remove);
            ((ContentManagerListener)this.myDispatcher.getMulticaster()).contentRemoved(e);
            Content item = (Content)ContainerUtil.getFirstItem(this.myContents);
            if (item != null) {
                this.setSelectedContent(item);
            }
            return result;
        }

        @NotNull
        public ActionCallback removeContent(@NotNull Content content, boolean dispose, boolean trackFocus, boolean implicitFocus) {
            this.removeContent(content, dispose);
            return ActionCallback.DONE;
        }

        public void removeContentManagerListener(@NotNull ContentManagerListener l) {
            this.myDispatcher.removeListener((EventListener)l);
        }

        public void removeFromSelection(@NotNull Content content) {
            ContentManagerEvent e = new ContentManagerEvent((Object)this, content, this.myContents.indexOf(this.mySelected), ContentManagerEvent.ContentOperation.remove);
            ((ContentManagerListener)this.myDispatcher.getMulticaster()).selectionChanged(e);
        }

        public ActionCallback selectNextContent() {
            return ActionCallback.DONE;
        }

        public ActionCallback selectPreviousContent() {
            return ActionCallback.DONE;
        }

        public void setSelectedContent(@NotNull Content content) {
            if (this.mySelected != null) {
                this.removeFromSelection(this.mySelected);
            }
            this.mySelected = content;
            ContentManagerEvent e = new ContentManagerEvent((Object)this, content, this.myContents.indexOf(content), ContentManagerEvent.ContentOperation.add);
            ((ContentManagerListener)this.myDispatcher.getMulticaster()).selectionChanged(e);
        }

        @NotNull
        public ActionCallback setSelectedContentCB(@NotNull Content content) {
            this.setSelectedContent(content);
            return ActionCallback.DONE;
        }

        public void setSelectedContent(@NotNull Content content, boolean requestFocus) {
            this.setSelectedContent(content);
        }

        @NotNull
        public ActionCallback setSelectedContentCB(@NotNull Content content, boolean requestFocus) {
            return this.setSelectedContentCB(content);
        }

        public void setSelectedContent(@NotNull Content content, boolean requestFocus, boolean forcedFocus) {
            this.setSelectedContent(content);
        }

        @NotNull
        public ActionCallback setSelectedContentCB(@NotNull Content content, boolean requestFocus, boolean forcedFocus) {
            return this.setSelectedContentCB(content);
        }

        @NotNull
        public ActionCallback setSelectedContent(@NotNull Content content, boolean requestFocus, boolean forcedFocus, boolean implicit) {
            return this.setSelectedContentCB(content);
        }

        @NotNull
        public ActionCallback requestFocus(@Nullable Content content, boolean forced) {
            return ActionCallback.DONE;
        }

        public void dispose() {
            this.myContents.clear();
            this.mySelected = null;
            this.myDispatcher.getListeners().clear();
        }

        public boolean isDisposed() {
            return false;
        }

        public boolean isSingleSelection() {
            return true;
        }

        @NotNull
        public ContentFactory getFactory() {
            return (ContentFactory)ServiceManager.getService(ContentFactory.class);
        }
    }

    public static class MockToolWindow
    implements ToolWindowEx {
        ContentManager myContentManager = new MockContentManager();

        public MockToolWindow(@NotNull Project project2) {
            Disposer.register((Disposable)project2, (Disposable)this.myContentManager);
        }

        public boolean isActive() {
            return false;
        }

        public void activate(@Nullable Runnable runnable2) {
        }

        public boolean isDisposed() {
            return false;
        }

        public boolean isVisible() {
            return false;
        }

        public void setShowStripeButton(boolean show) {
        }

        public boolean isShowStripeButton() {
            return false;
        }

        @NotNull
        public ActionCallback getReady(@NotNull Object requestor) {
            return ActionCallback.DONE;
        }

        public void show(@Nullable Runnable runnable2) {
        }

        public void hide(@Nullable Runnable runnable2) {
        }

        public ToolWindowAnchor getAnchor() {
            return ToolWindowAnchor.BOTTOM;
        }

        public void setAnchor(ToolWindowAnchor anchor, @Nullable Runnable runnable2) {
        }

        public boolean isSplitMode() {
            return false;
        }

        public void setSplitMode(boolean isSideTool, @Nullable Runnable runnable2) {
        }

        public boolean isAutoHide() {
            return false;
        }

        public void setAutoHide(boolean state) {
        }

        public void setToHideOnEmptyContent(boolean hideOnEmpty) {
        }

        public boolean isToHideOnEmptyContent() {
            return false;
        }

        public ToolWindowType getType() {
            return ToolWindowType.SLIDING;
        }

        public void setType(ToolWindowType type, @Nullable Runnable runnable2) {
        }

        public Icon getIcon() {
            return null;
        }

        public void setIcon(Icon icon) {
        }

        public String getTitle() {
            return "";
        }

        public void setTitle(String title) {
        }

        @NotNull
        public String getStripeTitle() {
            return "";
        }

        public void setStripeTitle(@NotNull String title) {
        }

        public boolean isAvailable() {
            return false;
        }

        public void setContentUiType(@NotNull ToolWindowContentUiType type, @Nullable Runnable runnable2) {
        }

        public void setDefaultContentUiType(@NotNull ToolWindowContentUiType type) {
        }

        @NotNull
        public ToolWindowContentUiType getContentUiType() {
            return ToolWindowContentUiType.TABBED;
        }

        public void setAvailable(boolean available, @Nullable Runnable runnable2) {
        }

        public void installWatcher(ContentManager contentManager) {
        }

        public JComponent getComponent() {
            return null;
        }

        public ContentManager getContentManager() {
            return this.myContentManager;
        }

        public void setDefaultState(@Nullable ToolWindowAnchor anchor, @Nullable ToolWindowType type, @Nullable Rectangle floatingBounds) {
        }

        public void activate(@Nullable Runnable runnable2, boolean autoFocusContents) {
        }

        public void activate(@Nullable Runnable runnable2, boolean autoFocusContents, boolean forced) {
        }

        public void showContentPopup(InputEvent inputEvent) {
        }

        public ActionCallback getActivation() {
            return ActionCallback.DONE;
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener l) {
        }

        @Override
        public ToolWindowType getInternalType() {
            return ToolWindowType.DOCKED;
        }

        @Override
        public void stretchWidth(int value) {
        }

        @Override
        public void stretchHeight(int value) {
        }

        @Override
        public InternalDecorator getDecorator() {
            return null;
        }

        @Override
        public void setAdditionalGearActions(ActionGroup additionalGearActions) {
        }

        @Override
        public void setTitleActions(AnAction ... actions) {
        }

        @Override
        public void setUseLastFocusedOnActivation(boolean focus) {
        }

        @Override
        public boolean isUseLastFocusedOnActivation() {
            return false;
        }
    }
}

