/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.impl.ActionMenuItem;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.util.BitUtil;
import javax.swing.JFrame;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectWindowAction
extends ToggleAction
implements DumbAware {
    private ProjectWindowAction myPrevious;
    private ProjectWindowAction myNext;
    @NotNull
    private final String myProjectName;
    @NotNull
    private final String myProjectLocation;

    public ProjectWindowAction(@NotNull String projectName, @NotNull String projectLocation, ProjectWindowAction previous) {
        this.myProjectName = projectName;
        this.myProjectLocation = projectLocation;
        if (previous != null) {
            this.myPrevious = previous;
            this.myNext = previous.myNext;
            this.myNext.myPrevious = this;
            this.myPrevious.myNext = this;
        } else {
            this.myPrevious = this;
            this.myNext = this;
        }
        this.getTemplatePresentation().setText(projectName, false);
    }

    public void dispose() {
        if (this.myPrevious == this) {
            assert (this.myNext == this);
            return;
        }
        if (this.myNext == this) {
            assert (false);
            return;
        }
        this.myPrevious.myNext = this.myNext;
        this.myNext.myPrevious = this.myPrevious;
    }

    public ProjectWindowAction getPrevious() {
        return this.myPrevious;
    }

    public ProjectWindowAction getNext() {
        return this.myNext;
    }

    @NotNull
    public String getProjectLocation() {
        return this.myProjectLocation;
    }

    @NotNull
    public String getProjectName() {
        return this.myProjectName;
    }

    @Nullable
    private Project findProject() {
        Project[] projects;
        for (Project project2 : projects = ProjectManager.getInstance().getOpenProjects()) {
            if (!this.myProjectLocation.equals(project2.getPresentableUrl())) continue;
            return project2;
        }
        return null;
    }

    public boolean isSelected(AnActionEvent e) {
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project2 == null) {
            return false;
        }
        return this.myProjectLocation.equals(project2.getPresentableUrl());
    }

    public void setSelected(@Nullable AnActionEvent e, boolean selected) {
        boolean macMainMenu;
        if (e == null) {
            return;
        }
        boolean bl = macMainMenu = SystemInfo.isMac && ActionPlaces.isMainMenuOrActionSearch((String)e.getPlace());
        if (!selected && !macMainMenu) {
            return;
        }
        Project project2 = this.findProject();
        if (project2 == null) {
            return;
        }
        JFrame projectFrame = WindowManager.getInstance().getFrame(project2);
        int frameState = projectFrame.getExtendedState();
        if (macMainMenu && !(e.getInputEvent().getSource() instanceof ActionMenuItem) && (projectFrame.getExtendedState() & 1) != 0) {
            return;
        }
        if (BitUtil.isSet((int)frameState, (int)1)) {
            projectFrame.setExtendedState(frameState ^ 1);
        }
        projectFrame.toFront();
        projectFrame.requestFocus();
    }

    public String toString() {
        return this.getTemplatePresentation().getText() + " previous: " + this.myPrevious.getTemplatePresentation().getText() + " next: " + this.myNext.getTemplatePresentation().getText();
    }
}

