/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileTooBigException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsBundle;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingRegistry;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.FileNameCache;
import com.intellij.openapi.vfs.newvfs.impl.VfsData;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSImpl;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.StringFactory;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VirtualFileSystemEntry
extends NewVirtualFile {
    public static final VirtualFileSystemEntry[] EMPTY_ARRAY = new VirtualFileSystemEntry[0];
    protected static final PersistentFS ourPersistence = PersistentFS.getInstance();
    private static final Key<String> SYMLINK_TARGET = Key.create((String)"local.vfs.symlink.target");
    static final int IS_WRITABLE_FLAG = 0x1000000;
    static final int IS_HIDDEN_FLAG = 0x2000000;
    private static final int INDEXED_FLAG = 0x4000000;
    static final int CHILDREN_CACHED = 0x8000000;
    private static final int DIRTY_FLAG = 0x10000000;
    static final int IS_SYMLINK_FLAG = 0x20000000;
    private static final int HAS_SYMLINK_FLAG = 0x40000000;
    static final int IS_SPECIAL_FLAG = Integer.MIN_VALUE;
    static final int SYSTEM_LINE_SEPARATOR_DETECTED = 0x8000000;
    static final int ALL_FLAGS_MASK = -16777216;
    protected final VfsData.Segment mySegment;
    private final VirtualDirectoryImpl myParent;
    protected final int myId;

    public VirtualFileSystemEntry(int id, VfsData.Segment segment, VirtualDirectoryImpl parent) {
        this.mySegment = segment;
        this.myId = id;
        this.myParent = parent;
    }

    void updateLinkStatus() {
        boolean isSymLink = this.is(VFileProperty.SYMLINK);
        if (isSymLink) {
            String target = this.getParent().getFileSystem().resolveSymLink((VirtualFile)this);
            this.setLinkTarget(target != null ? FileUtil.toSystemIndependentName((String)target) : null);
        }
        this.setFlagInt(0x40000000, isSymLink || this.getParent().getFlagInt(0x40000000));
    }

    @NotNull
    public String getName() {
        return this.getNameSequence().toString();
    }

    @NotNull
    public CharSequence getNameSequence() {
        return FileNameCache.getVFileName(this.mySegment.getNameId(this.myId));
    }

    public VirtualDirectoryImpl getParent() {
        VirtualDirectoryImpl changedParent = VfsData.getChangedParent(this.myId);
        return changedParent != null ? changedParent : this.myParent;
    }

    public boolean isDirty() {
        return this.getFlagInt(0x10000000);
    }

    public long getModificationStamp() {
        return this.mySegment.getModificationStamp(this.myId);
    }

    public void setModificationStamp(long modificationStamp) {
        this.mySegment.setModificationStamp(this.myId, modificationStamp);
    }

    boolean getFlagInt(int mask) {
        return this.mySegment.getFlag(this.myId, mask);
    }

    void setFlagInt(int mask, boolean value) {
        this.mySegment.setFlag(this.myId, mask, value);
    }

    public boolean isFileIndexed() {
        return this.getFlagInt(0x4000000);
    }

    public void setFileIndexed(boolean indexed) {
        this.setFlagInt(0x4000000, indexed);
    }

    public void markClean() {
        this.setFlagInt(0x10000000, false);
    }

    public void markDirty() {
        if (!this.isDirty()) {
            this.markDirtyInternal();
            VirtualDirectoryImpl parent = this.getParent();
            if (parent != null) {
                parent.markDirty();
            }
        }
    }

    protected void markDirtyInternal() {
        this.setFlagInt(0x10000000, true);
    }

    public void markDirtyRecursively() {
        this.markDirty();
        for (VirtualFile file2 : this.getCachedChildren()) {
            ((NewVirtualFile)file2).markDirtyRecursively();
        }
    }

    protected char[] appendPathOnFileSystem(int accumulatedPathLength, int[] positionRef) {
        CharSequence name = FileNameCache.getVFileName(this.mySegment.getNameId(this.myId));
        char[] chars = this.getParent().appendPathOnFileSystem(accumulatedPathLength + 1 + name.length(), positionRef);
        int i = positionRef[0];
        chars[i] = 47;
        positionRef[0] = VirtualFileSystemEntry.copyString(chars, i + 1, name);
        return chars;
    }

    protected static int copyString(@NotNull char[] chars, int pos, @NotNull CharSequence s) {
        int length = s.length();
        CharArrayUtil.getChars((CharSequence)s, (char[])chars, (int)0, (int)pos, (int)length);
        return pos + length;
    }

    @NotNull
    public String getUrl() {
        String protocol = this.getFileSystem().getProtocol();
        int prefixLen = protocol.length() + "://".length();
        char[] chars = this.appendPathOnFileSystem(prefixLen, new int[]{prefixLen});
        VirtualFileSystemEntry.copyString(chars, VirtualFileSystemEntry.copyString(chars, 0, protocol), "://");
        return StringFactory.createShared((char[])chars);
    }

    @NotNull
    public String getPath() {
        return StringFactory.createShared((char[])this.appendPathOnFileSystem(0, new int[]{0}));
    }

    public void delete(Object requestor) throws IOException {
        ourPersistence.deleteFile(requestor, (VirtualFile)this);
    }

    public void rename(Object requestor, @NotNull @NonNls String newName) throws IOException {
        if (this.getName().equals(newName)) {
            return;
        }
        this.validateName(newName);
        ourPersistence.renameFile(requestor, (VirtualFile)this, newName);
    }

    @NotNull
    public VirtualFile createChildData(Object requestor, @NotNull String name) throws IOException {
        this.validateName(name);
        return ourPersistence.createChildFile(requestor, (VirtualFile)this, name);
    }

    public boolean isWritable() {
        return this.getFlagInt(0x1000000);
    }

    public void setWritable(boolean writable) throws IOException {
        ourPersistence.setWritable((VirtualFile)this, writable);
    }

    public long getTimeStamp() {
        return ourPersistence.getTimeStamp((VirtualFile)this);
    }

    public void setTimeStamp(long time) throws IOException {
        ourPersistence.setTimeStamp((VirtualFile)this, time);
    }

    public long getLength() {
        return ourPersistence.getLength((VirtualFile)this);
    }

    public VirtualFile copy(final Object requestor, final @NotNull VirtualFile newParent, final @NotNull String copyName) throws IOException {
        if (this.getFileSystem() != newParent.getFileSystem()) {
            throw new IOException(VfsBundle.message((String)"file.copy.error", (Object[])new Object[]{newParent.getPresentableUrl()}));
        }
        if (!newParent.isDirectory()) {
            throw new IOException(VfsBundle.message((String)"file.copy.target.must.be.directory", (Object[])new Object[0]));
        }
        return EncodingRegistry.doActionAndRestoreEncoding((VirtualFile)this, (ThrowableComputable)new ThrowableComputable<VirtualFile, IOException>(){

            public VirtualFile compute() throws IOException {
                return ourPersistence.copyFile(requestor, (VirtualFile)VirtualFileSystemEntry.this, newParent, copyName);
            }
        });
    }

    public void move(final Object requestor, final @NotNull VirtualFile newParent) throws IOException {
        if (this.getFileSystem() != newParent.getFileSystem()) {
            throw new IOException(VfsBundle.message((String)"file.move.error", (Object[])new Object[]{newParent.getPresentableUrl()}));
        }
        EncodingRegistry.doActionAndRestoreEncoding((VirtualFile)this, (ThrowableComputable)new ThrowableComputable<VirtualFile, IOException>(){

            public VirtualFile compute() throws IOException {
                ourPersistence.moveFile(requestor, (VirtualFile)VirtualFileSystemEntry.this, newParent);
                return VirtualFileSystemEntry.this;
            }
        });
    }

    public int getId() {
        return VfsData.isFileValid(this.myId) ? this.myId : -this.myId;
    }

    public boolean equals(Object o) {
        return this == o || o instanceof VirtualFileSystemEntry && this.myId == ((VirtualFileSystemEntry)((Object)o)).myId;
    }

    public int hashCode() {
        return this.myId;
    }

    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull String name) throws IOException {
        this.validateName(name);
        return ourPersistence.createChildDirectory(requestor, (VirtualFile)this, name);
    }

    private void validateName(@NotNull String name) throws IOException {
        if (!this.getFileSystem().isValidName(name)) {
            throw new IOException(VfsBundle.message((String)"file.invalid.name.error", (Object[])new Object[]{name}));
        }
    }

    public boolean exists() {
        return VfsData.isFileValid(this.myId);
    }

    public boolean isValid() {
        return this.exists();
    }

    public String toString() {
        return this.getUrl();
    }

    public void setNewName(@NotNull String newName) {
        if (!this.getFileSystem().isValidName(newName)) {
            throw new IllegalArgumentException(VfsBundle.message((String)"file.invalid.name.error", (Object[])new Object[]{newName}));
        }
        VirtualDirectoryImpl parent = this.getParent();
        parent.removeChild((VirtualFile)this);
        this.mySegment.setNameId(this.myId, FileNameCache.storeName(newName));
        ((PersistentFSImpl)PersistentFS.getInstance()).incStructuralModificationCount();
        parent.addChild(this);
    }

    public void setParent(@NotNull VirtualFile newParent) {
        VirtualDirectoryImpl parent = this.getParent();
        parent.removeChild((VirtualFile)this);
        VirtualDirectoryImpl directory = (VirtualDirectoryImpl)newParent;
        VfsData.changeParent(this.myId, directory);
        directory.addChild(this);
        this.updateLinkStatus();
    }

    public boolean isInLocalFileSystem() {
        return this.getFileSystem() instanceof LocalFileSystem;
    }

    public void invalidate() {
        VfsData.invalidateFile(this.myId);
    }

    @NotNull
    public Charset getCharset() {
        return this.isCharsetSet() ? super.getCharset() : this.computeCharset();
    }

    @NotNull
    private Charset computeCharset() {
        Charset charset;
        if (this.isDirectory()) {
            Charset configured = EncodingManager.getInstance().getEncoding((VirtualFile)this, true);
            charset = configured == null ? Charset.defaultCharset() : configured;
            this.setCharset(charset);
        } else if (SingleRootFileViewProvider.isTooLargeForContentLoading((VirtualFile)this)) {
            charset = super.getCharset();
        } else {
            try {
                byte[] content;
                try {
                    content = this.contentsToByteArray();
                }
                catch (FileNotFoundException e) {
                    return super.getCharset();
                }
                charset = LoadTextUtil.detectCharsetAndSetBOM((VirtualFile)this, content);
            }
            catch (FileTooBigException e) {
                return super.getCharset();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return charset;
    }

    public String getPresentableName() {
        if (UISettings.getInstance().HIDE_KNOWN_EXTENSION_IN_TABS && !this.isDirectory()) {
            String nameWithoutExtension = this.getNameWithoutExtension();
            return nameWithoutExtension.isEmpty() ? this.getName() : nameWithoutExtension;
        }
        return this.getName();
    }

    public boolean is(@NotNull VFileProperty property) {
        if (property == VFileProperty.SPECIAL) {
            return this.getFlagInt(Integer.MIN_VALUE);
        }
        if (property == VFileProperty.HIDDEN) {
            return this.getFlagInt(0x2000000);
        }
        if (property == VFileProperty.SYMLINK) {
            return this.getFlagInt(0x20000000);
        }
        return super.is(property);
    }

    public void updateProperty(String property, boolean value) {
        if (property == "writable") {
            this.setFlagInt(0x1000000, value);
        }
        if (property == PROP_HIDDEN) {
            this.setFlagInt(0x2000000, value);
        }
    }

    public void setLinkTarget(@Nullable String target) {
        this.putUserData(SYMLINK_TARGET, target);
    }

    public String getCanonicalPath() {
        if (this.getFlagInt(0x40000000)) {
            if (this.is(VFileProperty.SYMLINK)) {
                return (String)this.getUserData(SYMLINK_TARGET);
            }
            VirtualDirectoryImpl parent = this.getParent();
            if (parent != null) {
                return parent.getCanonicalPath() + "/" + this.getName();
            }
            return this.getName();
        }
        return this.getPath();
    }

    public NewVirtualFile getCanonicalFile() {
        if (this.getFlagInt(0x40000000)) {
            String path = this.getCanonicalPath();
            return path != null ? (NewVirtualFile)this.getFileSystem().findFileByPath(path) : null;
        }
        return this;
    }
}

