/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.util.PathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class VfsRootAccess {
    private static final boolean SHOULD_PERFORM_ACCESS_CHECK = System.getenv("NO_FS_ROOTS_ACCESS_CHECK") == null;
    private static final Set<String> ourAdditionalRoots = new THashSet(FileUtil.PATH_HASHING_STRATEGY);
    private static boolean insideGettingRoots;

    static void assertAccessInTests(@NotNull VirtualFileSystemEntry child, @NotNull NewVirtualFileSystem delegate) {
        Application application = ApplicationManager.getApplication();
        if (SHOULD_PERFORM_ACCESS_CHECK && application.isUnitTestMode() && application instanceof ApplicationImpl && ((ApplicationImpl)application).isComponentsCreated() && !ApplicationInfoImpl.isInPerformanceTest()) {
            boolean isUnder;
            if (delegate != LocalFileSystem.getInstance() && delegate != JarFileSystem.getInstance()) {
                return;
            }
            if (child.getParent() == null || child.getParent().getParent() == null) {
                return;
            }
            Set allowed = (Set)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Set<String>>(){

                public Set<String> compute() {
                    return VfsRootAccess.allowedRoots();
                }
            });
            boolean bl = isUnder = allowed == null || allowed.isEmpty();
            if (!isUnder) {
                String childPath = child.getPath();
                if (delegate == JarFileSystem.getInstance()) {
                    VirtualFile local = JarFileSystem.getInstance().getVirtualFileForJar((VirtualFile)child);
                    assert (local != null) : child;
                    childPath = local.getPath();
                }
                for (String root : allowed) {
                    String rootLocalPath;
                    if (FileUtil.startsWith((String)childPath, (String)root)) {
                        isUnder = true;
                        break;
                    }
                    if (!root.startsWith("jar://") || !(isUnder = FileUtil.startsWith((String)childPath, (String)(rootLocalPath = FileUtil.toSystemIndependentName((String)PathUtil.toPresentableUrl((String)root)))))) continue;
                    break;
                }
            }
            assert (isUnder) : "File accessed outside allowed roots: " + (Object)((Object)child) + ";\nAllowed roots: " + new ArrayList(allowed);
        }
    }

    private static Set<String> allowedRoots() {
        if (insideGettingRoots) {
            return null;
        }
        Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
        if (openProjects.length == 0) {
            return null;
        }
        THashSet allowed = new THashSet(FileUtil.PATH_HASHING_STRATEGY);
        allowed.add(FileUtil.toSystemIndependentName((String)PathManager.getHomePath()));
        String homePath2 = PathManager.getHomePathFor(Application.class);
        if (homePath2 != null) {
            allowed.add(FileUtil.toSystemIndependentName((String)homePath2));
        }
        try {
            URL outUrl = Application.class.getResource("/");
            if (outUrl != null) {
                String output = new File(outUrl.toURI()).getParentFile().getParentFile().getPath();
                allowed.add(FileUtil.toSystemIndependentName((String)output));
            }
        }
        catch (URISyntaxException outUrl) {
            // empty catch block
        }
        String javaHome = SystemProperties.getJavaHome();
        allowed.add(FileUtil.toSystemIndependentName((String)javaHome));
        if (SystemInfo.isMac && SystemInfo.isAppleJvm) {
            allowed.add(FileUtil.toSystemIndependentName((String)new File(new File(javaHome).getParent(), "Classes").getPath()));
        }
        allowed.add(FileUtil.toSystemIndependentName((String)new File(FileUtil.getTempDirectory()).getParent()));
        allowed.add(FileUtil.toSystemIndependentName((String)System.getProperty("java.io.tmpdir")));
        allowed.add(FileUtil.toSystemIndependentName((String)SystemProperties.getUserHome()));
        for (Project project2 : openProjects) {
            if (!project2.isInitialized()) {
                return null;
            }
            for (VirtualFile root : ProjectRootManager.getInstance((Project)project2).getContentRoots()) {
                allowed.add(root.getPath());
            }
            for (VirtualFile root : VfsRootAccess.getAllRoots(project2)) {
                allowed.add(StringUtil.trimEnd((String)root.getPath(), (String)"!/"));
            }
            String location = project2.getBasePath();
            assert (location != null) : project2;
            allowed.add(FileUtil.toSystemIndependentName((String)location));
        }
        allowed.addAll(ourAdditionalRoots);
        return allowed;
    }

    private static VirtualFile[] getAllRoots(@NotNull Project project2) {
        insideGettingRoots = true;
        THashSet roots = new THashSet();
        OrderEnumerator enumerator = ProjectRootManager.getInstance((Project)project2).orderEntries();
        ContainerUtil.addAll((Collection)roots, (Object[])enumerator.getClassesRoots());
        ContainerUtil.addAll((Collection)roots, (Object[])enumerator.getSourceRoots());
        insideGettingRoots = false;
        return VfsUtilCore.toVirtualFileArray((Collection)roots);
    }

    public static void allowRootAccess(@NotNull Disposable disposable, final String ... roots) {
        if (roots.length == 0) {
            return;
        }
        VfsRootAccess.allowRootAccess(roots);
        Disposer.register((Disposable)disposable, (Disposable)new Disposable(){

            public void dispose() {
                VfsRootAccess.disallowRootAccess(roots);
            }
        });
    }

    public static void allowRootAccess(String ... roots) {
        for (String root : roots) {
            ourAdditionalRoots.add(FileUtil.toSystemIndependentName((String)root));
        }
    }

    public static void disallowRootAccess(String ... roots) {
        for (String root : roots) {
            ourAdditionalRoots.remove(FileUtil.toSystemIndependentName((String)root));
        }
    }
}

