/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.impl;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.StubVirtualFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class FakeVirtualFile
extends StubVirtualFile {
    private final VirtualFile myParent;
    private final String myName;

    public FakeVirtualFile(@NotNull VirtualFile parent, @NotNull String name) {
        this.myName = name;
        this.myParent = parent;
    }

    @NotNull
    public VirtualFile getParent() {
        return this.myParent;
    }

    public boolean isDirectory() {
        return false;
    }

    @NotNull
    public String getPath() {
        String basePath = this.myParent.getPath();
        return StringUtil.endsWithChar((CharSequence)basePath, (char)'/') ? basePath + this.myName : basePath + '/' + this.myName;
    }

    @NotNull
    @NonNls
    public String getName() {
        return this.myName;
    }

    public String toString() {
        return this.getPath();
    }
}

