/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbModePermission;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.DumbServiceImpl;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.ex.VirtualFileManagerEx;
import com.intellij.openapi.vfs.impl.local.FileWatcher;
import com.intellij.openapi.vfs.impl.local.LocalFileSystemImpl;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.RefreshQueueImpl;
import com.intellij.openapi.vfs.newvfs.RefreshSession;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.newvfs.persistent.RefreshWorker;
import com.intellij.util.concurrency.Semaphore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefreshSessionImpl
extends RefreshSession {
    private static final Logger LOG = Logger.getInstance(RefreshSession.class);
    private static final AtomicLong ID_COUNTER = new AtomicLong(0L);
    private final long myId = ID_COUNTER.incrementAndGet();
    private final boolean myIsAsync;
    private final boolean myIsRecursive;
    private final Runnable myFinishRunnable;
    private final ModalityState myModalityState;
    private final Semaphore mySemaphore = new Semaphore();
    private List<VirtualFile> myWorkQueue = new ArrayList<VirtualFile>();
    private List<VFileEvent> myEvents = new ArrayList<VFileEvent>();
    private volatile boolean iHaveEventsToFire;
    private volatile RefreshWorker myWorker = null;
    private volatile boolean myCancelled = false;
    private final DumbModePermission myDumbModePermission;
    private final Throwable myStartTrace;

    public RefreshSessionImpl(boolean async, boolean recursive, @Nullable Runnable finishRunnable) {
        this(async, recursive, finishRunnable, ModalityState.NON_MODAL);
    }

    public RefreshSessionImpl(boolean async, boolean recursive, @Nullable Runnable finishRunnable, @NotNull ModalityState modalityState) {
        this.myIsAsync = async;
        this.myIsRecursive = recursive;
        this.myFinishRunnable = finishRunnable;
        this.myModalityState = modalityState;
        LOG.assertTrue(modalityState == ModalityState.NON_MODAL || modalityState != ModalityState.any(), (Object)"Refresh session should have a specific modality");
        if (modalityState == ModalityState.NON_MODAL) {
            this.myDumbModePermission = null;
            this.myStartTrace = null;
        } else {
            this.myDumbModePermission = DumbServiceImpl.getExplicitPermission();
            this.myStartTrace = new Throwable();
        }
    }

    public RefreshSessionImpl(@NotNull List<VFileEvent> events) {
        this(false, false, null, ModalityState.NON_MODAL);
        this.myEvents.addAll(events);
    }

    public long getId() {
        return this.myId;
    }

    public void addAllFiles(@NotNull Collection<? extends VirtualFile> files) {
        for (VirtualFile virtualFile : files) {
            if (virtualFile == null) {
                LOG.error("null passed among " + files);
                continue;
            }
            this.myWorkQueue.add(virtualFile);
        }
    }

    public void addFile(@NotNull VirtualFile file2) {
        this.myWorkQueue.add(file2);
    }

    public boolean isAsynchronous() {
        return this.myIsAsync;
    }

    public void launch() {
        this.mySemaphore.down();
        ((RefreshQueueImpl)RefreshQueue.getInstance()).execute(this);
    }

    public void scan() {
        boolean haveEventsToFire;
        List<VirtualFile> workQueue = this.myWorkQueue;
        this.myWorkQueue = new ArrayList<VirtualFile>();
        boolean bl = haveEventsToFire = this.myFinishRunnable != null || !this.myEvents.isEmpty();
        if (!workQueue.isEmpty()) {
            FileWatcher watcher;
            LocalFileSystem fileSystem = LocalFileSystem.getInstance();
            if (fileSystem instanceof LocalFileSystemImpl) {
                LocalFileSystemImpl fs = (LocalFileSystemImpl)fileSystem;
                fs.markSuspiciousFilesDirty(workQueue);
                watcher = fs.getFileWatcher();
            } else {
                watcher = null;
            }
            long t = 0L;
            if (LOG.isDebugEnabled()) {
                LOG.debug("scanning " + workQueue);
                t = System.currentTimeMillis();
            }
            for (VirtualFile file2 : workQueue) {
                if (this.myCancelled) break;
                NewVirtualFile nvf = (NewVirtualFile)file2;
                if (!(this.myIsRecursive || this.myIsAsync && (watcher == null || watcher.isWatched((VirtualFile)nvf)))) {
                    nvf.markDirty();
                }
                RefreshWorker worker = this.myWorker = new RefreshWorker(nvf, this.myIsRecursive);
                worker.scan();
                List<VFileEvent> events = worker.getEvents();
                if (!this.myEvents.addAll(events)) continue;
                haveEventsToFire = true;
            }
            if (t != 0L) {
                t = System.currentTimeMillis() - t;
                LOG.debug((this.myCancelled ? "cancelled, " : "done, ") + t + " ms, events " + this.myEvents);
            }
        }
        this.myWorker = null;
        this.iHaveEventsToFire = haveEventsToFire;
    }

    public void cancel() {
        this.myCancelled = true;
        RefreshWorker worker = this.myWorker;
        if (worker != null) {
            worker.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireEvents(final boolean hasWriteAction) {
        AccessToken token = this.myStartTrace == null ? null : DumbServiceImpl.forceDumbModeStartTrace(this.myStartTrace);
        try {
            if (!this.iHaveEventsToFire || ApplicationManager.getApplication().isDisposed()) {
                return;
            }
            Runnable runnable2 = new Runnable(){

                @Override
                public void run() {
                    if (hasWriteAction) {
                        RefreshSessionImpl.this.fireEventsInWriteAction();
                    } else {
                        ApplicationManager.getApplication().runWriteAction(new Runnable(){

                            @Override
                            public void run() {
                                RefreshSessionImpl.this.fireEventsInWriteAction();
                            }
                        });
                    }
                }
            };
            if (this.myDumbModePermission != null) {
                DumbService.allowStartingDumbModeInside((DumbModePermission)this.myDumbModePermission, (Runnable)runnable2);
            } else {
                runnable2.run();
            }
        }
        finally {
            if (token != null) {
                token.finish();
            }
            this.mySemaphore.up();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireEventsInWriteAction() {
        VirtualFileManagerEx manager = (VirtualFileManagerEx)VirtualFileManager.getInstance();
        manager.fireBeforeRefreshStart(this.myIsAsync);
        try {
            while (!this.myWorkQueue.isEmpty() || !this.myEvents.isEmpty()) {
                PersistentFS.getInstance().processEvents(this.mergeEventsAndReset());
                this.scan();
            }
        }
        finally {
            try {
                manager.fireAfterRefreshFinish(this.myIsAsync);
            }
            finally {
                if (this.myFinishRunnable != null) {
                    this.myFinishRunnable.run();
                }
            }
        }
    }

    public void waitFor() {
        this.mySemaphore.waitFor();
    }

    private List<VFileEvent> mergeEventsAndReset() {
        LinkedHashSet<VFileEvent> mergedEvents = new LinkedHashSet<VFileEvent>(this.myEvents);
        ArrayList<VFileEvent> events = new ArrayList<VFileEvent>(mergedEvents);
        this.myEvents = new ArrayList<VFileEvent>();
        return events;
    }

    @NotNull
    public ModalityState getModalityState() {
        return this.myModalityState;
    }

    public String toString() {
        return this.myWorkQueue.size() <= 1 ? "" : this.myWorkQueue.size() + " roots in queue.";
    }
}

