/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.util.ui.UIUtil;
import org.jetbrains.annotations.NotNull;

public class RefreshProgress
extends ProgressIndicatorBase {
    private static final Project[] NULL_ARRAY = new Project[]{null};
    private final String myMessage;

    @NotNull
    public static ProgressIndicator create(@NotNull String message) {
        Application app = ApplicationManager.getApplication();
        return app == null || app.isUnitTestMode() ? new EmptyProgressIndicator() : new RefreshProgress(message);
    }

    private RefreshProgress(@NotNull String message) {
        super(true);
        this.myMessage = message;
    }

    @Override
    public void start() {
        super.start();
        this.updateIndicators(true);
    }

    @Override
    public void stop() {
        super.stop();
        this.updateIndicators(false);
    }

    private void updateIndicators(final boolean start) {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                if (ApplicationManager.getApplication().isDisposed()) {
                    return;
                }
                WindowManager windowManager = WindowManager.getInstance();
                if (windowManager == null) {
                    return;
                }
                Project[] projects = ProjectManager.getInstance().getOpenProjects();
                if (projects.length == 0) {
                    projects = NULL_ARRAY;
                }
                for (Project project2 : projects) {
                    StatusBarEx statusBar = (StatusBarEx)windowManager.getStatusBar(project2);
                    if (statusBar == null) continue;
                    if (start) {
                        statusBar.startRefreshIndication(RefreshProgress.this.myMessage);
                        continue;
                    }
                    statusBar.stopRefreshIndication();
                }
            }
        });
    }
}

