/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.local;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.local.CoreLocalFileSystem;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class CoreLocalVirtualFile
extends VirtualFile {
    private final CoreLocalFileSystem myFileSystem;
    private final File myIoFile;
    private VirtualFile[] myChildren;
    private final boolean isDirectory;

    public CoreLocalVirtualFile(@NotNull CoreLocalFileSystem fileSystem, @NotNull File ioFile) {
        this(fileSystem, ioFile, ioFile.isDirectory());
    }

    public CoreLocalVirtualFile(@NotNull CoreLocalFileSystem fileSystem, @NotNull File ioFile, boolean isDirectory) {
        this.myFileSystem = fileSystem;
        this.myIoFile = ioFile;
        this.isDirectory = isDirectory;
    }

    @NotNull
    public String getName() {
        return this.myIoFile.getName();
    }

    @NotNull
    public VirtualFileSystem getFileSystem() {
        return this.myFileSystem;
    }

    @NotNull
    public String getPath() {
        return FileUtil.toSystemIndependentName((String)this.myIoFile.getAbsolutePath());
    }

    public boolean isWritable() {
        return false;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public boolean isValid() {
        return true;
    }

    public VirtualFile getParent() {
        File parentFile = this.myIoFile.getParentFile();
        return parentFile != null ? new CoreLocalVirtualFile(this.myFileSystem, parentFile) : null;
    }

    public VirtualFile[] getChildren() {
        VirtualFile[] answer = this.myChildren;
        if (answer == null) {
            ArrayList<CoreLocalVirtualFile> result = new ArrayList<CoreLocalVirtualFile>();
            File[] files = this.myIoFile.listFiles();
            if (files == null) {
                answer = EMPTY_ARRAY;
            } else {
                for (File file2 : files) {
                    result.add(new CoreLocalVirtualFile(this.myFileSystem, file2));
                }
                answer = result.toArray(new VirtualFile[result.size()]);
            }
            this.myChildren = answer;
        }
        return answer;
    }

    @NotNull
    public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) throws IOException {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public byte[] contentsToByteArray() throws IOException {
        return FileUtil.loadFileBytes((File)this.myIoFile);
    }

    public long getTimeStamp() {
        return this.myIoFile.lastModified();
    }

    public long getLength() {
        return this.myIoFile.length();
    }

    public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
    }

    public InputStream getInputStream() throws IOException {
        return VfsUtilCore.inputStreamSkippingBOM((InputStream)new BufferedInputStream(new FileInputStream(this.myIoFile)), (VirtualFile)this);
    }

    public long getModificationStamp() {
        return 0L;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        CoreLocalVirtualFile that = (CoreLocalVirtualFile)((Object)o);
        return this.myIoFile.equals(that.myIoFile);
    }

    public int hashCode() {
        return this.myIoFile.hashCode();
    }
}

