/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.win32;

import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.win32.FileInfo;
import com.intellij.openapi.util.io.win32.IdeaWin32;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtil;
import gnu.trove.THashMap;
import java.lang.ref.Reference;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class Win32FsCache {
    private final IdeaWin32 myKernel = IdeaWin32.getInstance();
    private Reference<Map<String, FileAttributes>> myCache;

    Win32FsCache() {
    }

    void clearCache() {
        this.myCache = null;
    }

    @NotNull
    private Map<String, FileAttributes> getMap() {
        Map map = (Map)SoftReference.dereference(this.myCache);
        if (map == null) {
            map = new THashMap(FileUtil.PATH_HASHING_STRATEGY);
            this.myCache = new java.lang.ref.SoftReference<Map>(map);
        }
        return map;
    }

    @NotNull
    String[] list(@NotNull String path) {
        FileInfo[] fileInfo = this.myKernel.listChildren(path);
        if (fileInfo == null || fileInfo.length == 0) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        if (!StringUtil.endsWithChar((CharSequence)path, (char)'/')) {
            path = path + "/";
        }
        String[] names = new String[fileInfo.length];
        Map<String, FileAttributes> map = this.getMap();
        for (FileInfo info : fileInfo) {
            String name = info.getName();
            map.put(path + name, info.toFileAttributes());
            names[i] = name;
        }
        return names;
    }

    @Nullable
    FileAttributes getAttributes(@NotNull VirtualFile file2) {
        String path = file2.getPath();
        Map<String, FileAttributes> map = this.getMap();
        FileAttributes attributes = map.get(path);
        if (attributes == null) {
            FileInfo info = this.myKernel.getInfo(path);
            if (info == null) {
                return null;
            }
            attributes = info.toFileAttributes();
            map.put(path, attributes);
        }
        return attributes;
    }
}

