/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.local;

import com.intellij.ide.GeneralSettings;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileOperationsHandler;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.SafeWriteRequestor;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsBundle;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.ex.VirtualFileManagerEx;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import com.intellij.openapi.vfs.newvfs.impl.FakeVirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.Processor;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.SafeFileOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LocalFileSystemBase
extends LocalFileSystem {
    protected static final Logger LOG = Logger.getInstance(LocalFileSystemBase.class);
    private static final FileAttributes FAKE_ROOT_ATTRIBUTES = new FileAttributes(true, false, false, false, 0L, 0L, false);
    private final List<LocalFileOperationsHandler> myHandlers = new ArrayList<LocalFileOperationsHandler>();

    @Nullable
    public VirtualFile findFileByPath(@NotNull String path) {
        return VfsImplUtil.findFileByPath((NewVirtualFileSystem)this, path);
    }

    public VirtualFile findFileByPathIfCached(@NotNull String path) {
        return VfsImplUtil.findFileByPathIfCached((NewVirtualFileSystem)this, path);
    }

    @Nullable
    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        return VfsImplUtil.refreshAndFindFileByPath((NewVirtualFileSystem)this, path);
    }

    public VirtualFile findFileByIoFile(@NotNull File file2) {
        String path = FileUtil.toSystemIndependentName((String)file2.getAbsolutePath());
        return this.findFileByPath(path);
    }

    @NotNull
    protected static File convertToIOFile(@NotNull VirtualFile file2) {
        String path = file2.getPath();
        if (StringUtil.endsWithChar((CharSequence)path, (char)':') && path.length() == 2 && (SystemInfo.isWindows || SystemInfo.isOS2)) {
            path = path + "/";
        }
        return new File(path);
    }

    @NotNull
    private static File convertToIOFileAndCheck(@NotNull VirtualFile file2) throws FileNotFoundException {
        File ioFile = LocalFileSystemBase.convertToIOFile(file2);
        FileAttributes attributes = FileSystemUtil.getAttributes((File)ioFile);
        if (attributes != null && !attributes.isFile()) {
            LOG.warn("not a file: " + ioFile + ", " + attributes);
            throw new FileNotFoundException("Not a file: " + ioFile);
        }
        return ioFile;
    }

    public boolean exists(@NotNull VirtualFile file2) {
        return this.getAttributes(file2) != null;
    }

    public long getLength(@NotNull VirtualFile file2) {
        FileAttributes attributes = this.getAttributes(file2);
        return attributes != null ? attributes.length : 0L;
    }

    public long getTimeStamp(@NotNull VirtualFile file2) {
        FileAttributes attributes = this.getAttributes(file2);
        return attributes != null ? attributes.lastModified : 0L;
    }

    public boolean isDirectory(@NotNull VirtualFile file2) {
        FileAttributes attributes = this.getAttributes(file2);
        return attributes != null && attributes.isDirectory();
    }

    public boolean isWritable(@NotNull VirtualFile file2) {
        FileAttributes attributes = this.getAttributes(file2);
        return attributes != null && attributes.isWritable();
    }

    public boolean isSymLink(@NotNull VirtualFile file2) {
        FileAttributes attributes = this.getAttributes(file2);
        return attributes != null && attributes.isSymLink();
    }

    public String resolveSymLink(@NotNull VirtualFile file2) {
        return FileSystemUtil.resolveSymLink((String)file2.getPath());
    }

    @NotNull
    public String[] list(@NotNull VirtualFile file2) {
        String[] names;
        if (file2.getParent() == null) {
            File[] roots = File.listRoots();
            if (roots.length == 1 && roots[0].getName().isEmpty()) {
                String[] list = roots[0].list();
                if (list != null) {
                    return list;
                }
                LOG.warn("Root '" + roots[0] + "' has no children - is it readable?");
                return ArrayUtil.EMPTY_STRING_ARRAY;
            }
            if (file2.getName().isEmpty()) {
                String[] names2 = new String[roots.length];
                for (int i = 0; i < names2.length; ++i) {
                    String name = roots[i].getPath();
                    names2[i] = name = StringUtil.trimEnd((String)name, (String)File.separator);
                }
                return names2;
            }
        }
        return (names = LocalFileSystemBase.convertToIOFile(file2).list()) == null ? ArrayUtil.EMPTY_STRING_ARRAY : names;
    }

    @NotNull
    public String getProtocol() {
        return "file";
    }

    public boolean isReadOnly() {
        return false;
    }

    @Nullable
    protected String normalize(@NotNull String path) {
        if (path.isEmpty()) {
            try {
                path = new File("").getCanonicalPath();
            }
            catch (IOException e) {
                return path;
            }
        }
        if (SystemInfo.isWindows) {
            if (path.charAt(0) == '/' && !path.startsWith("//")) {
                path = path.substring(1);
            }
            try {
                path = FileUtil.resolveShortWindowsName((String)path);
            }
            catch (IOException e) {
                return null;
            }
        }
        File file2 = new File(path);
        if (!LocalFileSystemBase.isAbsoluteFileOrDriveLetter(file2)) {
            path = file2.getAbsolutePath();
        }
        return FileUtil.normalize((String)path);
    }

    private static boolean isAbsoluteFileOrDriveLetter(@NotNull File file2) {
        String path = file2.getPath();
        if (SystemInfo.isWindows && path.length() == 2 && path.charAt(1) == ':') {
            return true;
        }
        return file2.isAbsolute();
    }

    public VirtualFile refreshAndFindFileByIoFile(@NotNull File file2) {
        String path = FileUtil.toSystemIndependentName((String)file2.getAbsolutePath());
        return this.refreshAndFindFileByPath(path);
    }

    public void refreshIoFiles(@NotNull Iterable<File> files) {
        this.refreshIoFiles(files, false, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshIoFiles(@NotNull Iterable<File> files, boolean async, boolean recursive, @Nullable Runnable onFinish) {
        boolean fireCommonRefreshSession;
        VirtualFileManagerEx manager = (VirtualFileManagerEx)VirtualFileManager.getInstance();
        Application app = ApplicationManager.getApplication();
        boolean bl = fireCommonRefreshSession = app.isDispatchThread() || app.isWriteAccessAllowed();
        if (fireCommonRefreshSession) {
            manager.fireBeforeRefreshStart(false);
        }
        try {
            ArrayList<VirtualFile> filesToRefresh = new ArrayList<VirtualFile>();
            for (File file2 : files) {
                VirtualFile virtualFile = this.refreshAndFindFileByIoFile(file2);
                if (virtualFile == null) continue;
                filesToRefresh.add(virtualFile);
            }
            RefreshQueue.getInstance().refresh(async, recursive, onFinish, filesToRefresh);
        }
        finally {
            if (fireCommonRefreshSession) {
                manager.fireAfterRefreshFinish(false);
            }
        }
    }

    public void refreshFiles(@NotNull Iterable<VirtualFile> files) {
        this.refreshFiles(files, false, false, null);
    }

    public void refreshFiles(@NotNull Iterable<VirtualFile> files, boolean async, boolean recursive, @Nullable Runnable onFinish) {
        RefreshQueue.getInstance().refresh(async, recursive, onFinish, ContainerUtil.toCollection(files));
    }

    public void registerAuxiliaryFileOperationsHandler(@NotNull LocalFileOperationsHandler handler2) {
        if (this.myHandlers.contains(handler2)) {
            LOG.error("Handler " + handler2 + " already registered.");
        }
        this.myHandlers.add(handler2);
    }

    public void unregisterAuxiliaryFileOperationsHandler(@NotNull LocalFileOperationsHandler handler2) {
        if (!this.myHandlers.remove(handler2)) {
            LOG.error("Handler" + handler2 + " haven't been registered or already unregistered.");
        }
    }

    public boolean processCachedFilesInSubtree(@NotNull VirtualFile file2, @NotNull Processor<VirtualFile> processor2) {
        return file2.getFileSystem() != this || LocalFileSystemBase.processFile((NewVirtualFile)file2, processor2);
    }

    private static boolean processFile(@NotNull NewVirtualFile file2, @NotNull Processor<VirtualFile> processor2) {
        if (!processor2.process((Object)file2)) {
            return false;
        }
        if (file2.isDirectory()) {
            for (VirtualFile child : file2.getCachedChildren()) {
                if (LocalFileSystemBase.processFile((NewVirtualFile)child, processor2)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean auxDelete(@NotNull VirtualFile file2) throws IOException {
        for (LocalFileOperationsHandler handler2 : this.myHandlers) {
            if (!handler2.delete(file2)) continue;
            return true;
        }
        return false;
    }

    private boolean auxMove(@NotNull VirtualFile file2, @NotNull VirtualFile toDir) throws IOException {
        for (LocalFileOperationsHandler handler2 : this.myHandlers) {
            if (!handler2.move(file2, toDir)) continue;
            return true;
        }
        return false;
    }

    private boolean auxCopy(@NotNull VirtualFile file2, @NotNull VirtualFile toDir, @NotNull String copyName) throws IOException {
        for (LocalFileOperationsHandler handler2 : this.myHandlers) {
            File copy = handler2.copy(file2, toDir, copyName);
            if (copy == null) continue;
            return true;
        }
        return false;
    }

    private boolean auxRename(@NotNull VirtualFile file2, @NotNull String newName) throws IOException {
        for (LocalFileOperationsHandler handler2 : this.myHandlers) {
            if (!handler2.rename(file2, newName)) continue;
            return true;
        }
        return false;
    }

    private boolean auxCreateFile(@NotNull VirtualFile dir, @NotNull String name) throws IOException {
        for (LocalFileOperationsHandler handler2 : this.myHandlers) {
            if (!handler2.createFile(dir, name)) continue;
            return true;
        }
        return false;
    }

    private boolean auxCreateDirectory(@NotNull VirtualFile dir, @NotNull String name) throws IOException {
        for (LocalFileOperationsHandler handler2 : this.myHandlers) {
            if (!handler2.createDirectory(dir, name)) continue;
            return true;
        }
        return false;
    }

    private void auxNotifyCompleted(@NotNull ThrowableConsumer<LocalFileOperationsHandler, IOException> consumer) {
        for (LocalFileOperationsHandler handler2 : this.myHandlers) {
            handler2.afterDone(consumer);
        }
    }

    @NotNull
    public VirtualFile createChildDirectory(Object requestor, final @NotNull VirtualFile parent, final @NotNull String dir) throws IOException {
        File ioDir;
        if (!this.isValidName(dir)) {
            throw new IOException(VfsBundle.message((String)"directory.invalid.name.error", (Object[])new Object[]{dir}));
        }
        if (!parent.exists() || !parent.isDirectory()) {
            throw new IOException(VfsBundle.message((String)"vfs.target.not.directory.error", (Object[])new Object[]{parent.getPath()}));
        }
        if (parent.findChild(dir) != null) {
            throw new IOException(VfsBundle.message((String)"vfs.target.already.exists.error", (Object[])new Object[]{parent.getPath() + "/" + dir}));
        }
        File ioParent = LocalFileSystemBase.convertToIOFile(parent);
        if (!ioParent.isDirectory()) {
            throw new IOException(VfsBundle.message((String)"target.not.directory.error", (Object[])new Object[]{ioParent.getPath()}));
        }
        if (!(this.auxCreateDirectory(parent, dir) || (ioDir = new File(ioParent, dir)).mkdirs() || ioDir.isDirectory())) {
            throw new IOException(VfsBundle.message((String)"new.directory.failed.error", (Object[])new Object[]{ioDir.getPath()}));
        }
        this.auxNotifyCompleted(new ThrowableConsumer<LocalFileOperationsHandler, IOException>(){

            public void consume(LocalFileOperationsHandler handler2) throws IOException {
                handler2.createDirectory(parent, dir);
            }
        });
        return new FakeVirtualFile(parent, dir);
    }

    @NotNull
    public VirtualFile createChildFile(Object requestor, final @NotNull VirtualFile parent, final @NotNull String file2) throws IOException {
        File ioFile;
        if (!this.isValidName(file2)) {
            throw new IOException(VfsBundle.message((String)"file.invalid.name.error", (Object[])new Object[]{file2}));
        }
        if (!parent.exists() || !parent.isDirectory()) {
            throw new IOException(VfsBundle.message((String)"vfs.target.not.directory.error", (Object[])new Object[]{parent.getPath()}));
        }
        if (parent.findChild(file2) != null) {
            throw new IOException(VfsBundle.message((String)"vfs.target.already.exists.error", (Object[])new Object[]{parent.getPath() + "/" + file2}));
        }
        File ioParent = LocalFileSystemBase.convertToIOFile(parent);
        if (!ioParent.isDirectory()) {
            throw new IOException(VfsBundle.message((String)"target.not.directory.error", (Object[])new Object[]{ioParent.getPath()}));
        }
        if (!this.auxCreateFile(parent, file2) && !FileUtil.createIfDoesntExist((File)(ioFile = new File(ioParent, file2)))) {
            throw new IOException(VfsBundle.message((String)"new.file.failed.error", (Object[])new Object[]{ioFile.getPath()}));
        }
        this.auxNotifyCompleted(new ThrowableConsumer<LocalFileOperationsHandler, IOException>(){

            public void consume(LocalFileOperationsHandler handler2) throws IOException {
                handler2.createFile(parent, file2);
            }
        });
        return new FakeVirtualFile(parent, file2);
    }

    public void deleteFile(Object requestor, final @NotNull VirtualFile file2) throws IOException {
        File ioFile;
        if (file2.getParent() == null) {
            throw new IOException(VfsBundle.message((String)"cannot.delete.root.directory", (Object[])new Object[]{file2.getPath()}));
        }
        if (!this.auxDelete(file2) && !FileUtil.delete((File)(ioFile = LocalFileSystemBase.convertToIOFile(file2)))) {
            throw new IOException(VfsBundle.message((String)"delete.failed.error", (Object[])new Object[]{ioFile.getPath()}));
        }
        this.auxNotifyCompleted(new ThrowableConsumer<LocalFileOperationsHandler, IOException>(){

            public void consume(LocalFileOperationsHandler handler2) throws IOException {
                handler2.delete(file2);
            }
        });
    }

    public boolean isCaseSensitive() {
        return SystemInfo.isFileSystemCaseSensitive;
    }

    public boolean isValidName(@NotNull String name) {
        return PathUtilRt.isValidFileName((String)name, (boolean)false);
    }

    @NotNull
    public InputStream getInputStream(@NotNull VirtualFile file2) throws IOException {
        return new BufferedInputStream(new FileInputStream(LocalFileSystemBase.convertToIOFileAndCheck(file2)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public byte[] contentsToByteArray(@NotNull VirtualFile file2) throws IOException {
        try (FileInputStream stream = new FileInputStream(LocalFileSystemBase.convertToIOFileAndCheck(file2));){
            long l = file2.getLength();
            if (l > Integer.MAX_VALUE) {
                throw new IOException("File is too large: " + l + ", " + file2);
            }
            int length = (int)l;
            if (length < 0) {
                throw new IOException("Invalid file length: " + length + ", " + file2);
            }
            byte[] byArray = LocalFileSystemBase.loadBytes(length <= 8192 ? stream : new BufferedInputStream(stream), length);
            return byArray;
        }
    }

    @NotNull
    private static byte[] loadBytes(@NotNull InputStream stream, int length) throws IOException {
        int count;
        int n;
        byte[] bytes = new byte[length];
        for (count = 0; count < length && (n = stream.read(bytes, count, length - count)) > 0; count += n) {
        }
        if (count < length) {
            return Arrays.copyOf(bytes, count);
        }
        return bytes;
    }

    @NotNull
    public OutputStream getOutputStream(@NotNull VirtualFile file2, Object requestor, long modStamp, final long timeStamp) throws IOException {
        final File ioFile = LocalFileSystemBase.convertToIOFileAndCheck(file2);
        Object stream = LocalFileSystemBase.shallUseSafeStream(requestor, file2) ? new SafeFileOutputStream(ioFile, SystemInfo.isUnix) : new FileOutputStream(ioFile);
        return new BufferedOutputStream((OutputStream)stream){

            @Override
            public void close() throws IOException {
                super.close();
                if (timeStamp > 0L && ioFile.exists() && !ioFile.setLastModified(timeStamp)) {
                    LOG.warn("Failed: " + ioFile.getPath() + ", new:" + timeStamp + ", old:" + ioFile.lastModified());
                }
            }
        };
    }

    private static boolean shallUseSafeStream(Object requestor, @NotNull VirtualFile file2) {
        return requestor instanceof SafeWriteRequestor && GeneralSettings.getInstance().isUseSafeWrite() && !file2.is(VFileProperty.SYMLINK);
    }

    public void moveFile(Object requestor, final @NotNull VirtualFile file2, final @NotNull VirtualFile newParent) throws IOException {
        String name = file2.getName();
        if (!file2.exists()) {
            throw new IOException(VfsBundle.message((String)"vfs.file.not.exist.error", (Object[])new Object[]{file2.getPath()}));
        }
        if (file2.getParent() == null) {
            throw new IOException(VfsBundle.message((String)"cannot.rename.root.directory", (Object[])new Object[]{file2.getPath()}));
        }
        if (!newParent.exists() || !newParent.isDirectory()) {
            throw new IOException(VfsBundle.message((String)"vfs.target.not.directory.error", (Object[])new Object[]{newParent.getPath()}));
        }
        if (newParent.findChild(name) != null) {
            throw new IOException(VfsBundle.message((String)"vfs.target.already.exists.error", (Object[])new Object[]{newParent.getPath() + "/" + name}));
        }
        File ioFile = LocalFileSystemBase.convertToIOFile(file2);
        if (FileSystemUtil.getAttributes((File)ioFile) == null) {
            throw new FileNotFoundException(VfsBundle.message((String)"file.not.exist.error", (Object[])new Object[]{ioFile.getPath()}));
        }
        File ioParent = LocalFileSystemBase.convertToIOFile(newParent);
        if (!ioParent.isDirectory()) {
            throw new IOException(VfsBundle.message((String)"target.not.directory.error", (Object[])new Object[]{ioParent.getPath()}));
        }
        File ioTarget = new File(ioParent, name);
        if (ioTarget.exists()) {
            throw new IOException(VfsBundle.message((String)"target.already.exists.error", (Object[])new Object[]{ioTarget.getPath()}));
        }
        if (!this.auxMove(file2, newParent) && !ioFile.renameTo(ioTarget)) {
            throw new IOException(VfsBundle.message((String)"move.failed.error", (Object[])new Object[]{ioFile.getPath(), ioParent.getPath()}));
        }
        this.auxNotifyCompleted(new ThrowableConsumer<LocalFileOperationsHandler, IOException>(){

            public void consume(LocalFileOperationsHandler handler2) throws IOException {
                handler2.move(file2, newParent);
            }
        });
    }

    public void renameFile(Object requestor, final @NotNull VirtualFile file2, final @NotNull String newName) throws IOException {
        boolean sameName;
        if (!this.isValidName(newName)) {
            throw new IOException(VfsBundle.message((String)"file.invalid.name.error", (Object[])new Object[]{newName}));
        }
        boolean bl = sameName = !this.isCaseSensitive() && newName.equalsIgnoreCase(file2.getName());
        if (!file2.exists()) {
            throw new IOException(VfsBundle.message((String)"vfs.file.not.exist.error", (Object[])new Object[]{file2.getPath()}));
        }
        VirtualFile parent = file2.getParent();
        if (parent == null) {
            throw new IOException(VfsBundle.message((String)"cannot.rename.root.directory", (Object[])new Object[]{file2.getPath()}));
        }
        if (!sameName && parent.findChild(newName) != null) {
            throw new IOException(VfsBundle.message((String)"vfs.target.already.exists.error", (Object[])new Object[]{parent.getPath() + "/" + newName}));
        }
        File ioFile = LocalFileSystemBase.convertToIOFile(file2);
        if (!ioFile.exists()) {
            throw new FileNotFoundException(VfsBundle.message((String)"file.not.exist.error", (Object[])new Object[]{ioFile.getPath()}));
        }
        File ioTarget = new File(LocalFileSystemBase.convertToIOFile(parent), newName);
        if (!sameName && ioTarget.exists()) {
            throw new IOException(VfsBundle.message((String)"target.already.exists.error", (Object[])new Object[]{ioTarget.getPath()}));
        }
        if (!this.auxRename(file2, newName) && !FileUtil.rename((File)ioFile, (String)newName)) {
            throw new IOException(VfsBundle.message((String)"rename.failed.error", (Object[])new Object[]{ioFile.getPath(), newName}));
        }
        this.auxNotifyCompleted(new ThrowableConsumer<LocalFileOperationsHandler, IOException>(){

            public void consume(LocalFileOperationsHandler handler2) throws IOException {
                handler2.rename(file2, newName);
            }
        });
    }

    @NotNull
    public VirtualFile copyFile(Object requestor, final @NotNull VirtualFile file2, final @NotNull VirtualFile newParent, final @NotNull String copyName) throws IOException {
        if (!this.isValidName(copyName)) {
            throw new IOException(VfsBundle.message((String)"file.invalid.name.error", (Object[])new Object[]{copyName}));
        }
        if (!file2.exists()) {
            throw new IOException(VfsBundle.message((String)"vfs.file.not.exist.error", (Object[])new Object[]{file2.getPath()}));
        }
        if (!newParent.exists() || !newParent.isDirectory()) {
            throw new IOException(VfsBundle.message((String)"vfs.target.not.directory.error", (Object[])new Object[]{newParent.getPath()}));
        }
        if (newParent.findChild(copyName) != null) {
            throw new IOException(VfsBundle.message((String)"vfs.target.already.exists.error", (Object[])new Object[]{newParent.getPath() + "/" + copyName}));
        }
        FileAttributes attributes = this.getAttributes(file2);
        if (attributes == null) {
            throw new FileNotFoundException(VfsBundle.message((String)"file.not.exist.error", (Object[])new Object[]{file2.getPath()}));
        }
        if (attributes.isSpecial()) {
            throw new FileNotFoundException("Not a file: " + file2);
        }
        File ioParent = LocalFileSystemBase.convertToIOFile(newParent);
        if (!ioParent.isDirectory()) {
            throw new IOException(VfsBundle.message((String)"target.not.directory.error", (Object[])new Object[]{ioParent.getPath()}));
        }
        File ioTarget = new File(ioParent, copyName);
        if (ioTarget.exists()) {
            throw new IOException(VfsBundle.message((String)"target.already.exists.error", (Object[])new Object[]{ioTarget.getPath()}));
        }
        if (!this.auxCopy(file2, newParent, copyName)) {
            try {
                File ioFile = LocalFileSystemBase.convertToIOFile(file2);
                FileUtil.copyFileOrDir((File)ioFile, (File)ioTarget, (boolean)attributes.isDirectory());
            }
            catch (IOException e) {
                FileUtil.delete((File)ioTarget);
                throw e;
            }
        }
        this.auxNotifyCompleted(new ThrowableConsumer<LocalFileOperationsHandler, IOException>(){

            public void consume(LocalFileOperationsHandler handler2) throws IOException {
                handler2.copy(file2, newParent, copyName);
            }
        });
        return new FakeVirtualFile(newParent, copyName);
    }

    public void setTimeStamp(@NotNull VirtualFile file2, long timeStamp) {
        File ioFile = LocalFileSystemBase.convertToIOFile(file2);
        if (ioFile.exists() && !ioFile.setLastModified(timeStamp)) {
            LOG.warn("Failed: " + file2.getPath() + ", new:" + timeStamp + ", old:" + ioFile.lastModified());
        }
    }

    public void setWritable(@NotNull VirtualFile file2, boolean writableFlag) throws IOException {
        String path = FileUtil.toSystemDependentName((String)file2.getPath());
        FileUtil.setReadOnlyAttribute((String)path, (!writableFlag ? 1 : 0) != 0);
        if (FileUtil.canWrite((String)path) != writableFlag) {
            throw new IOException("Failed to change read-only flag for " + path);
        }
    }

    @NotNull
    protected String extractRootPath(@NotNull String path) {
        if (path.isEmpty()) {
            try {
                return this.extractRootPath(new File("").getCanonicalPath());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (SystemInfo.isWindows) {
            if (path.length() >= 2 && path.charAt(1) == ':') {
                return path.substring(0, 2).toUpperCase(Locale.US);
            }
            if (path.startsWith("//") || path.startsWith("\\\\")) {
                int idx;
                int slashCount = 0;
                for (idx = 2; idx < path.length() && slashCount < 2; ++idx) {
                    char c = path.charAt(idx);
                    if (c != '\\' && c != '/') continue;
                    ++slashCount;
                    --idx;
                }
                return path.substring(0, idx);
            }
            return "";
        }
        return StringUtil.startsWithChar((CharSequence)path, (char)'/') ? "/" : "";
    }

    public int getRank() {
        return 1;
    }

    public boolean markNewFilesAsDirty() {
        return true;
    }

    @NotNull
    public String getCanonicallyCasedName(@NotNull VirtualFile file2) {
        if (this.isCaseSensitive()) {
            return super.getCanonicallyCasedName(file2);
        }
        String originalFileName = file2.getName();
        try {
            String[] canonicalFileNames;
            File ioFile = LocalFileSystemBase.convertToIOFile(file2);
            File ioCanonicalFile = ioFile.getCanonicalFile();
            String canonicalFileName = ioCanonicalFile.getName();
            if (!SystemInfo.isUnix) {
                return canonicalFileName;
            }
            if (canonicalFileName.compareToIgnoreCase(originalFileName) == 0) {
                return canonicalFileName;
            }
            File parentFile = ioFile.getParentFile();
            if (parentFile != null && (canonicalFileNames = parentFile.list()) != null) {
                for (String name : canonicalFileNames) {
                    if (name.compareToIgnoreCase(originalFileName) != 0) continue;
                    return name;
                }
            }
            return canonicalFileName;
        }
        catch (IOException e) {
            return originalFileName;
        }
    }

    public FileAttributes getAttributes(@NotNull VirtualFile file2) {
        String path = this.normalize(file2.getPath());
        if (path == null) {
            return null;
        }
        if (file2.getParent() == null && path.startsWith("//")) {
            return FAKE_ROOT_ATTRIBUTES;
        }
        return FileSystemUtil.getAttributes((String)FileUtil.toSystemDependentName((String)path));
    }

    public void refresh(boolean asynchronous) {
        RefreshQueue.getInstance().refresh(asynchronous, true, null, ManagingFS.getInstance().getRoots((NewVirtualFileSystem)this));
    }
}

