/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.local;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.local.CanonicalPathMap;
import com.intellij.openapi.vfs.local.FileWatcherNotificationSink;
import com.intellij.openapi.vfs.local.PluggableFileWatcher;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileWatcher {
    private static final Logger LOG = Logger.getInstance(FileWatcher.class);
    public static final NotNullLazyValue<NotificationGroup> NOTIFICATION_GROUP = new NotNullLazyValue<NotificationGroup>(){

        @NotNull
        protected NotificationGroup compute() {
            return new NotificationGroup("File Watcher Messages", NotificationDisplayType.STICKY_BALLOON, true);
        }
    };
    private final MyFileWatcherNotificationSink myNotificationSink;
    private final PluggableFileWatcher[] myWatchers;
    private final AtomicBoolean myFailureShown = new AtomicBoolean(false);
    private volatile CanonicalPathMap myPathMap = new CanonicalPathMap();
    private volatile List<Collection<String>> myManualWatchRoots = Collections.emptyList();
    private volatile Runnable myTestNotifier = null;

    FileWatcher(@NotNull ManagingFS managingFS) {
        this.myNotificationSink = new MyFileWatcherNotificationSink();
        for (PluggableFileWatcher watcher : this.myWatchers = (PluggableFileWatcher[])PluggableFileWatcher.EP_NAME.getExtensions()) {
            watcher.initialize(managingFS, (FileWatcherNotificationSink)this.myNotificationSink);
        }
    }

    public void dispose() {
        for (PluggableFileWatcher watcher : this.myWatchers) {
            watcher.dispose();
        }
    }

    public boolean isOperational() {
        for (PluggableFileWatcher watcher : this.myWatchers) {
            if (watcher.isOperational()) continue;
            return false;
        }
        return true;
    }

    public boolean isSettingRoots() {
        for (PluggableFileWatcher watcher : this.myWatchers) {
            if (!watcher.isSettingRoots()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public DirtyPaths getDirtyPaths() {
        return this.myNotificationSink.getDirtyPaths();
    }

    @NotNull
    public Collection<String> getManualWatchRoots() {
        List<Collection<String>> manualWatchRoots = this.myManualWatchRoots;
        Collection<String> result = null;
        for (Collection<String> roots : manualWatchRoots) {
            if (result == null) {
                result = ContainerUtil.newHashSet(roots);
                continue;
            }
            result.retainAll(roots);
        }
        return result != null ? result : Collections.emptyList();
    }

    public void setWatchRoots(@NotNull List<String> recursive, @NotNull List<String> flat) {
        CanonicalPathMap pathMap;
        this.myPathMap = pathMap = new CanonicalPathMap(recursive, flat);
        this.myManualWatchRoots = ContainerUtil.createLockFreeCopyOnWriteList();
        for (PluggableFileWatcher watcher : this.myWatchers) {
            watcher.setWatchRoots(pathMap.getCanonicalRecursiveWatchRoots(), pathMap.getCanonicalFlatWatchRoots());
        }
    }

    public boolean isWatched(@NotNull VirtualFile file2) {
        return this.isOperational() && !this.myPathMap.getWatchedPaths(file2.getPath(), true, true).isEmpty();
    }

    public void notifyOnFailure(final String cause, final @Nullable NotificationListener listener2) {
        LOG.warn(cause);
        if (this.myFailureShown.compareAndSet(false, true)) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    String title = ApplicationBundle.message((String)"watcher.slow.sync", (Object[])new Object[0]);
                    Notifications.Bus.notify((Notification)((NotificationGroup)NOTIFICATION_GROUP.getValue()).createNotification(title, cause, NotificationType.WARNING, listener2));
                }
            }, ModalityState.NON_MODAL);
        }
    }

    private void notifyOnAnyEvent() {
        Runnable notifier = this.myTestNotifier;
        if (notifier != null) {
            notifier.run();
        }
    }

    public void shutdown() throws InterruptedException {
        for (PluggableFileWatcher watcher : this.myWatchers) {
            watcher.shutdown();
        }
        this.myTestNotifier = null;
    }

    public void startup(@Nullable Runnable notifier) throws IOException {
        this.myTestNotifier = notifier;
        for (PluggableFileWatcher watcher : this.myWatchers) {
            watcher.startup();
        }
    }

    private class MyFileWatcherNotificationSink
    implements FileWatcherNotificationSink {
        private final Object myLock = new Object();
        private DirtyPaths myDirtyPaths = new DirtyPaths();

        private MyFileWatcherNotificationSink() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DirtyPaths getDirtyPaths() {
            DirtyPaths dirtyPaths = DirtyPaths.EMPTY;
            PluggableFileWatcher[] pluggableFileWatcherArray = this.myLock;
            synchronized (this.myLock) {
                if (!this.myDirtyPaths.isEmpty()) {
                    dirtyPaths = this.myDirtyPaths;
                    this.myDirtyPaths = new DirtyPaths();
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                for (PluggableFileWatcher watcher : FileWatcher.this.myWatchers) {
                    watcher.resetChangedPaths();
                }
                return dirtyPaths;
            }
        }

        public void notifyManualWatchRoots(@NotNull Collection<String> roots) {
            FileWatcher.this.myManualWatchRoots.add(roots.isEmpty() ? Collections.emptySet() : ContainerUtil.newHashSet(roots));
            FileWatcher.this.notifyOnAnyEvent();
        }

        public void notifyMapping(@NotNull Collection<Pair<String, String>> mapping) {
            if (!mapping.isEmpty()) {
                FileWatcher.this.myPathMap.addMapping(mapping);
            }
            FileWatcher.this.notifyOnAnyEvent();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyDirtyPath(@NotNull String path) {
            Collection<String> paths = FileWatcher.this.myPathMap.getWatchedPaths(path, true, false);
            if (!paths.isEmpty()) {
                Object object = this.myLock;
                synchronized (object) {
                    this.myDirtyPaths.dirtyPaths.addAll(paths);
                }
            }
            FileWatcher.this.notifyOnAnyEvent();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyPathCreatedOrDeleted(@NotNull String path) {
            Collection<String> paths = FileWatcher.this.myPathMap.getWatchedPaths(path, true, false);
            if (!paths.isEmpty()) {
                Object object = this.myLock;
                synchronized (object) {
                    for (String p : paths) {
                        this.myDirtyPaths.dirtyPathsRecursive.add(p);
                        String parentPath = new File(p).getParent();
                        if (parentPath == null) continue;
                        this.myDirtyPaths.dirtyPaths.add(parentPath);
                    }
                }
            }
            FileWatcher.this.notifyOnAnyEvent();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyDirtyDirectory(@NotNull String path) {
            Collection<String> paths = FileWatcher.this.myPathMap.getWatchedPaths(path, false, false);
            if (!paths.isEmpty()) {
                Object object = this.myLock;
                synchronized (object) {
                    this.myDirtyPaths.dirtyDirectories.addAll(paths);
                }
            }
            FileWatcher.this.notifyOnAnyEvent();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyDirtyPathRecursive(@NotNull String path) {
            Collection<String> paths = FileWatcher.this.myPathMap.getWatchedPaths(path, false, false);
            if (!paths.isEmpty()) {
                Object object = this.myLock;
                synchronized (object) {
                    this.myDirtyPaths.dirtyPathsRecursive.addAll(paths);
                }
            }
            FileWatcher.this.notifyOnAnyEvent();
        }

        public void notifyUserOnFailure(@NotNull String cause, @Nullable NotificationListener listener2) {
            FileWatcher.this.notifyOnFailure(cause, listener2);
        }
    }

    public static class DirtyPaths {
        public final List<String> dirtyPaths = ContainerUtil.newSmartList();
        public final List<String> dirtyPathsRecursive = ContainerUtil.newSmartList();
        public final List<String> dirtyDirectories = ContainerUtil.newSmartList();
        public static final DirtyPaths EMPTY = new DirtyPaths();

        public boolean isEmpty() {
            return this.dirtyPaths.isEmpty() && this.dirtyPathsRecursive.isEmpty() && this.dirtyDirectories.isEmpty();
        }
    }
}

