/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.jrt;

import com.intellij.ide.AppLifecycleListener;
import com.intellij.lang.LangBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.openapi.vfs.impl.jrt.JrtHandler;
import com.intellij.openapi.vfs.impl.jrt.JrtHandlerStub;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JrtFileSystem
extends ArchiveFileSystem {
    public static final String PROTOCOL = "jrt";
    public static final String SEPARATOR = "!/";
    private static final boolean SUPPORTED = SystemInfo.isJavaVersionAtLeast((String)"9") || SystemInfo.isJavaVersionAtLeast((String)"1.8") && !SystemInfo.isJavaVersionAtLeast((String)"1.9");
    private final Map<String, ArchiveHandler> myHandlers = ContainerUtil.newTroveMap((TObjectHashingStrategy)FileUtil.PATH_HASHING_STRATEGY);
    private final AtomicBoolean mySubscribed = new AtomicBoolean(false);

    public JrtFileSystem() {
        JrtFileSystem.scheduleConfiguredSdkCheck();
    }

    private static void scheduleConfiguredSdkCheck() {
        if (JrtFileSystem.isSupported()) {
            return;
        }
        final MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect();
        connection.subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener.Adapter(){

            @Override
            public void appStarting(Project project2) {
                for (Sdk sdk : ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)JavaSdk.getInstance())) {
                    String homePath = sdk.getHomePath();
                    if (homePath == null || !JrtFileSystem.isModularJdk(homePath)) continue;
                    String title = LangBundle.message("jrt.not.available.title", sdk.getName());
                    String message = LangBundle.message("jrt.not.available.message", new Object[0]);
                    Notifications.Bus.notify((Notification)new Notification("System Messages", title, message, NotificationType.WARNING));
                }
                connection.disconnect();
            }
        });
    }

    @NotNull
    public String getProtocol() {
        return PROTOCOL;
    }

    @Nullable
    protected String normalize(@NotNull String path) {
        int p = path.indexOf(SEPARATOR);
        return p > 0 ? FileUtil.normalize((String)path.substring(0, p)) + path.substring(p) : super.normalize(path);
    }

    @NotNull
    protected String extractLocalPath(@NotNull String rootPath) {
        return StringUtil.trimEnd((String)rootPath, (String)SEPARATOR);
    }

    @NotNull
    protected String composeRootPath(@NotNull String localPath) {
        return localPath + SEPARATOR;
    }

    @NotNull
    protected String extractRootPath(@NotNull String entryPath) {
        int separatorIndex = entryPath.indexOf(SEPARATOR);
        assert (separatorIndex >= 0) : "Path passed to JrtFileSystem must have a separator '!/': " + entryPath;
        return entryPath.substring(0, separatorIndex + SEPARATOR.length());
    }

    @NotNull
    protected ArchiveHandler getHandler(@NotNull VirtualFile entryFile) {
        this.checkSubscription();
        String homePath = this.extractLocalPath(this.extractRootPath(entryFile.getPath()));
        ArchiveHandler handler2 = this.myHandlers.get(homePath);
        if (handler2 == null) {
            handler2 = JrtFileSystem.isSupported() ? new JrtHandler(homePath) : new JrtHandlerStub(homePath);
            this.myHandlers.put(homePath, handler2);
            ApplicationManager.getApplication().invokeLater(() -> {
                VirtualFile modules = LocalFileSystem.getInstance().refreshAndFindFileByPath(homePath + "/lib/modules");
                if (modules != null && modules.isDirectory()) {
                    modules.getChildren();
                }
            }, ModalityState.defaultModalityState());
        }
        return handler2;
    }

    private void checkSubscription() {
        if (this.mySubscribed.getAndSet(true)) {
            return;
        }
        Application app = ApplicationManager.getApplication();
        app.getMessageBus().connect((Disposable)app).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener.Adapter(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                HashSet toRefresh = null;
                for (VFileEvent vFileEvent : events) {
                    VirtualFile root;
                    VirtualFile file2;
                    if (!(vFileEvent.getFileSystem() instanceof LocalFileSystem) || !(vFileEvent instanceof VFileContentChangeEvent) || (file2 = vFileEvent.getFile()) == null) continue;
                    String homePath = null;
                    if ("modules".equals(file2.getName())) {
                        homePath = file2.getParent().getParent().getPath();
                    } else if ("jimage".equals(file2.getExtension())) {
                        homePath = file2.getParent().getParent().getParent().getPath();
                    }
                    if (homePath == null || JrtFileSystem.this.myHandlers.remove(homePath) == null || (root = JrtFileSystem.this.findFileByPath(JrtFileSystem.this.composeRootPath(homePath))) == null) continue;
                    ((NewVirtualFile)root).markDirtyRecursively();
                    if (toRefresh == null) {
                        toRefresh = ContainerUtil.newHashSet();
                    }
                    toRefresh.add(root);
                }
                if (toRefresh != null) {
                    boolean async = !ApplicationManager.getApplication().isUnitTestMode();
                    RefreshQueue.getInstance().refresh(async, true, null, toRefresh);
                }
            }
        });
    }

    public VirtualFile findFileByPath(@NotNull String path) {
        return VfsImplUtil.findFileByPath((NewVirtualFileSystem)this, path);
    }

    public VirtualFile findFileByPathIfCached(@NotNull String path) {
        return VfsImplUtil.findFileByPathIfCached((NewVirtualFileSystem)this, path);
    }

    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        return VfsImplUtil.refreshAndFindFileByPath((NewVirtualFileSystem)this, path);
    }

    public void refresh(boolean asynchronous) {
        VfsImplUtil.refresh((NewVirtualFileSystem)this, asynchronous);
    }

    protected boolean isCorrectFileType(@NotNull VirtualFile local) {
        return JrtFileSystem.isModularJdk(FileUtil.toSystemDependentName((String)local.getPath()));
    }

    public static boolean isSupported() {
        return SUPPORTED;
    }

    public static boolean isModularJdk(@NotNull String homePath) {
        return new File(homePath, "lib/modules").exists() && new File(homePath, "jrt-fs.jar").isFile();
    }

    public static boolean isRoot(@NotNull VirtualFile file2) {
        return file2.getParent() == null && file2.getFileSystem() instanceof JrtFileSystem;
    }
}

