/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.jar;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.jar.JarHandler;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import com.intellij.util.Function;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JarFileSystemImpl
extends JarFileSystem {
    private final Set<String> myNoCopyJarPaths;
    private final File myNoCopyJarDir;

    public JarFileSystemImpl() {
        boolean noCopy = SystemProperties.getBooleanProperty((String)"idea.jars.nocopy", (!SystemInfo.isWindows ? 1 : 0) != 0);
        this.myNoCopyJarPaths = noCopy ? null : ContainerUtil.newConcurrentSet((TObjectHashingStrategy)FileUtil.PATH_HASHING_STRATEGY);
        boolean runningFromDist = new File(PathManager.getLibPath(), "openapi.jar").exists();
        this.myNoCopyJarDir = !runningFromDist ? null : new File(PathManager.getHomePath());
    }

    public void setNoCopyJarForPath(String pathInJar) {
        if (this.myNoCopyJarPaths == null || pathInJar == null) {
            return;
        }
        int index = pathInJar.indexOf("!/");
        if (index < 0) {
            return;
        }
        String path = FileUtil.toSystemIndependentName((String)pathInJar.substring(0, index));
        this.myNoCopyJarPaths.add(path);
    }

    @Nullable
    public File getMirroredFile(@NotNull VirtualFile vFile) {
        VirtualFile root = this.getRootByLocal(vFile);
        return root == null ? null : this.getHandler(root).getFileToUse();
    }

    public boolean isMakeCopyOfJar(@NotNull File originalJar) {
        if (this.myNoCopyJarPaths == null || this.myNoCopyJarPaths.contains(originalJar.getPath())) {
            return false;
        }
        return this.myNoCopyJarDir == null || !FileUtil.isAncestor((File)this.myNoCopyJarDir, (File)originalJar, (boolean)false);
    }

    @NotNull
    public String getProtocol() {
        return "jar";
    }

    @NotNull
    public String extractPresentableUrl(@NotNull String path) {
        return super.extractPresentableUrl(StringUtil.trimEnd((String)path, (String)"!/"));
    }

    protected String normalize(@NotNull String path) {
        int jarSeparatorIndex = path.indexOf("!/");
        if (jarSeparatorIndex > 0) {
            String root = path.substring(0, jarSeparatorIndex);
            return FileUtil.normalize((String)root) + path.substring(jarSeparatorIndex);
        }
        return super.normalize(path);
    }

    @NotNull
    protected String extractRootPath(@NotNull String path) {
        int jarSeparatorIndex = path.indexOf("!/");
        assert (jarSeparatorIndex >= 0) : "Path passed to JarFileSystem must have jar separator '!/': " + path;
        return path.substring(0, jarSeparatorIndex + "!/".length());
    }

    @NotNull
    protected String extractLocalPath(@NotNull String rootPath) {
        return StringUtil.trimEnd((String)rootPath, (String)"!/");
    }

    @NotNull
    protected String composeRootPath(@NotNull String localPath) {
        return localPath + "!/";
    }

    @NotNull
    protected JarHandler getHandler(@NotNull VirtualFile entryFile) {
        return VfsImplUtil.getHandler((ArchiveFileSystem)this, entryFile, new Function<String, JarHandler>(){

            public JarHandler fun(String localPath) {
                return new JarHandler(localPath);
            }
        });
    }

    public VirtualFile findFileByPath(@NotNull String path) {
        return VfsImplUtil.findFileByPath((NewVirtualFileSystem)this, path);
    }

    public VirtualFile findFileByPathIfCached(@NotNull String path) {
        return VfsImplUtil.findFileByPathIfCached((NewVirtualFileSystem)this, path);
    }

    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        return VfsImplUtil.refreshAndFindFileByPath((NewVirtualFileSystem)this, path);
    }

    public void refresh(boolean asynchronous) {
        VfsImplUtil.refresh((NewVirtualFileSystem)this, asynchronous);
    }
}

