/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.jar;

import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.io.BufferExposingByteArrayInputStream;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.impl.jar.CoreJarFileSystem;
import com.intellij.openapi.vfs.impl.jar.CoreJarHandler;
import com.intellij.util.SmartList;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoreJarVirtualFile
extends VirtualFile {
    private final CoreJarHandler myHandler;
    private final String myName;
    private final FileAttributes myEntry;
    private final VirtualFile myParent;
    private List<VirtualFile> myChildren = null;

    public CoreJarVirtualFile(@NotNull CoreJarHandler handler2, @NotNull String name, @NotNull FileAttributes entry, @Nullable CoreJarVirtualFile parent) {
        this.myHandler = handler2;
        this.myName = name;
        this.myEntry = entry;
        this.myParent = parent;
        if (parent != null) {
            if (parent.myChildren == null) {
                parent.myChildren = new SmartList();
            }
            parent.myChildren.add(this);
        }
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @NotNull
    public VirtualFileSystem getFileSystem() {
        return this.myHandler.getFileSystem();
    }

    @NotNull
    public String getPath() {
        if (this.myParent == null) {
            return FileUtil.toSystemIndependentName((String)this.myHandler.getFile().getPath()) + "!/";
        }
        String parentPath = this.myParent.getPath();
        StringBuilder answer = new StringBuilder(parentPath.length() + 1 + this.myName.length());
        answer.append(parentPath);
        if (answer.charAt(answer.length() - 1) != '/') {
            answer.append('/');
        }
        answer.append(this.myName);
        return answer.toString();
    }

    public boolean isWritable() {
        return false;
    }

    public boolean isDirectory() {
        return this.myEntry.isDirectory();
    }

    public boolean isValid() {
        return true;
    }

    public VirtualFile getParent() {
        return this.myParent;
    }

    public VirtualFile[] getChildren() {
        if (this.myChildren == null) {
            return VirtualFile.EMPTY_ARRAY;
        }
        return this.myChildren.toArray(new VirtualFile[this.myChildren.size()]);
    }

    @NotNull
    public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) throws IOException {
        throw new UnsupportedOperationException("JarFileSystem is read-only");
    }

    @NotNull
    public byte[] contentsToByteArray() throws IOException {
        Couple<String> pair = ((CoreJarFileSystem)this.getFileSystem()).splitPath(this.getPath());
        return this.myHandler.contentsToByteArray((String)pair.second);
    }

    public long getTimeStamp() {
        return this.myEntry.lastModified;
    }

    public long getLength() {
        return this.myEntry.length;
    }

    public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
    }

    public InputStream getInputStream() throws IOException {
        return new BufferExposingByteArrayInputStream(this.contentsToByteArray());
    }

    public long getModificationStamp() {
        return 0L;
    }
}

