/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.jar;

import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.openapi.vfs.impl.ZipHandler;
import com.intellij.openapi.vfs.impl.jar.CoreJarFileSystem;
import com.intellij.openapi.vfs.impl.jar.CoreJarVirtualFile;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoreJarHandler
extends ZipHandler {
    private final CoreJarFileSystem myFileSystem;
    private final VirtualFile myRoot;

    public CoreJarHandler(@NotNull CoreJarFileSystem fileSystem, @NotNull String path) {
        super(path);
        this.myFileSystem = fileSystem;
        HashMap<ArchiveHandler.EntryInfo, CoreJarVirtualFile> entries = new HashMap<ArchiveHandler.EntryInfo, CoreJarVirtualFile>();
        Map entriesMap = this.getEntriesMap();
        for (ArchiveHandler.EntryInfo info : entriesMap.values()) {
            this.getOrCreateFile(info, entries);
        }
        ArchiveHandler.EntryInfo rootInfo = this.getEntryInfo("");
        this.myRoot = rootInfo != null ? this.getOrCreateFile(rootInfo, entries) : null;
    }

    @NotNull
    private CoreJarVirtualFile getOrCreateFile(@NotNull ArchiveHandler.EntryInfo info, @NotNull Map<ArchiveHandler.EntryInfo, CoreJarVirtualFile> entries) {
        CoreJarVirtualFile file2 = entries.get(info);
        if (file2 == null) {
            FileAttributes attributes = new FileAttributes(info.isDirectory, false, false, false, info.length, info.timestamp, false);
            ArchiveHandler.EntryInfo parent = info.parent;
            file2 = new CoreJarVirtualFile(this, info.shortName.toString(), attributes, parent != null ? this.getOrCreateFile(parent, entries) : null);
            entries.put(info, file2);
        }
        return file2;
    }

    @Nullable
    public VirtualFile findFileByPath(@NotNull String pathInJar) {
        return this.myRoot != null ? this.myRoot.findFileByRelativePath(pathInJar) : null;
    }

    @NotNull
    public CoreJarFileSystem getFileSystem() {
        return this.myFileSystem;
    }
}

