/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.openapi.vfs.impl.ZipEntryMap;
import com.intellij.util.io.FileAccessorCache;
import com.intellij.util.text.ByteArrayCharSequence;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ZipHandler
extends ArchiveHandler {
    private volatile String myCanonicalPathToZip = null;
    private volatile long myFileStamp;
    private volatile long myFileLength;
    private static final FileAccessorCache<ZipHandler, ZipFile> ourZipFileFileAccessorCache = new FileAccessorCache<ZipHandler, ZipFile>(20, 10){

        protected ZipFile createAccessor(ZipHandler key) throws IOException {
            String canonicalPathToZip = key.getCanonicalPathToZip();
            FileAttributes attributes = FileSystemUtil.getAttributes((String)canonicalPathToZip);
            key.myFileStamp = attributes != null ? attributes.lastModified : -1L;
            key.myFileLength = attributes != null ? attributes.length : 0L;
            return new ZipFile(canonicalPathToZip);
        }

        protected void disposeAccessor(final ZipFile fileAccessor) {
            this.disposeCloseable(new Closeable(){

                @Override
                public void close() throws IOException {
                    fileAccessor.close();
                }
            });
        }

        public boolean isEqual(ZipHandler val1, ZipHandler val2) {
            return val1 == val2;
        }
    };

    public ZipHandler(@NotNull String path) {
        super(path);
    }

    @NotNull
    private String getCanonicalPathToZip() throws IOException {
        String value = this.myCanonicalPathToZip;
        if (value == null) {
            this.myCanonicalPathToZip = value = this.getFileToUse().getCanonicalPath();
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected Map<String, ArchiveHandler.EntryInfo> createEntriesMap() throws IOException {
        FileAccessorCache.Handle<ZipFile> zipRef = this.getZipFileHandle();
        try {
            ZipFile zip = (ZipFile)zipRef.get();
            ZipEntryMap map = new ZipEntryMap(zip.size());
            map.put("", this.createRootEntry());
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                this.getOrCreate(entries.nextElement(), (Map<String, ArchiveHandler.EntryInfo>)map, zip);
            }
            ZipEntryMap zipEntryMap = map;
            return zipEntryMap;
        }
        finally {
            zipRef.release();
        }
    }

    @NotNull
    private FileAccessorCache.Handle<ZipFile> getZipFileHandle() throws IOException {
        FileAccessorCache.Handle handle = ourZipFileFileAccessorCache.get((Object)this);
        if (this.getFile() == this.getFileToUse()) {
            FileAttributes attributes = FileSystemUtil.getAttributes((String)this.getCanonicalPathToZip());
            if (attributes == null) {
                throw new FileNotFoundException(this.getCanonicalPathToZip());
            }
            if (attributes.lastModified == this.myFileStamp && attributes.length == this.myFileLength) {
                return handle;
            }
            this.removeZipHandlerFromCache();
            handle.release();
            handle = ourZipFileFileAccessorCache.get((Object)this);
        }
        return handle;
    }

    private void removeZipHandlerFromCache() {
        ourZipFileFileAccessorCache.remove((Object)this);
    }

    @NotNull
    protected File getFileToUse() {
        return this.getFile();
    }

    public void dispose() {
        super.dispose();
        this.removeZipHandlerFromCache();
    }

    @NotNull
    private ArchiveHandler.EntryInfo getOrCreate(@NotNull ZipEntry entry, @NotNull Map<String, ArchiveHandler.EntryInfo> map, @NotNull ZipFile zip) {
        ArchiveHandler.EntryInfo info;
        boolean isDirectory = entry.isDirectory();
        String entryName = entry.getName();
        if (StringUtil.endsWithChar((CharSequence)entryName, (char)'/')) {
            entryName = entryName.substring(0, entryName.length() - 1);
            isDirectory = true;
        }
        if ((info = map.get(entryName)) != null) {
            return info;
        }
        Pair path = this.splitPath(entryName);
        ArchiveHandler.EntryInfo parentInfo = this.getOrCreate((String)path.first, map, zip);
        if (".".equals(path.second)) {
            return parentInfo;
        }
        info = ZipHandler.store(map, parentInfo, (CharSequence)path.second, isDirectory, entry.getSize(), this.myFileStamp, entryName);
        return info;
    }

    @NotNull
    private static ArchiveHandler.EntryInfo store(@NotNull Map<String, ArchiveHandler.EntryInfo> map, @Nullable ArchiveHandler.EntryInfo parentInfo, @NotNull CharSequence shortName, boolean isDirectory, long size, long time, @NotNull String entryName) {
        CharSequence sequence = shortName instanceof ByteArrayCharSequence ? shortName : ByteArrayCharSequence.convertToBytesIfAsciiString((CharSequence)shortName);
        ArchiveHandler.EntryInfo info = new ArchiveHandler.EntryInfo(sequence, isDirectory, size, time, parentInfo);
        map.put(entryName, info);
        return info;
    }

    @NotNull
    private ArchiveHandler.EntryInfo getOrCreate(@NotNull String entryName, Map<String, ArchiveHandler.EntryInfo> map, @NotNull ZipFile zip) {
        ArchiveHandler.EntryInfo info = map.get(entryName);
        if (info == null) {
            ZipEntry entry = zip.getEntry(entryName + "/");
            if (entry != null) {
                return this.getOrCreate(entry, map, zip);
            }
            Pair path = this.splitPath(entryName);
            ArchiveHandler.EntryInfo parentInfo = this.getOrCreate((String)path.first, map, zip);
            info = ZipHandler.store(map, parentInfo, (CharSequence)path.second, true, 0L, -1L, entryName);
        }
        if (!info.isDirectory) {
            Logger.getInstance(((Object)((Object)this)).getClass()).info(zip.getName() + ": " + entryName + " should be a directory");
            info = ZipHandler.store(map, info.parent, info.shortName, true, info.length, info.timestamp, entryName);
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public byte[] contentsToByteArray(@NotNull String relativePath) throws IOException {
        FileAccessorCache.Handle<ZipFile> zipRef;
        try {
            zipRef = this.getZipFileHandle();
        }
        catch (RuntimeException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw ex;
        }
        try {
            InputStream stream;
            ZipFile zip = (ZipFile)zipRef.get();
            ZipEntry entry = zip.getEntry(relativePath);
            if (entry != null && (stream = zip.getInputStream(entry)) != null) {
                byte[] byArray;
                try {
                    byArray = FileUtil.loadBytes((InputStream)stream, (int)((int)entry.getSize()));
                }
                catch (Throwable throwable) {
                    stream.close();
                    throw throwable;
                }
                stream.close();
                return byArray;
            }
        }
        finally {
            zipRef.release();
        }
        throw new FileNotFoundException(this.getFile() + "!/" + relativePath);
    }

    public static void clearFileAccessorCache() {
        ourZipFileFileAccessorCache.clear();
    }
}

