/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TraceableDisposable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.FilePointerPartNode;
import com.intellij.openapi.vfs.impl.VirtualFilePointerManagerImpl;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.PathUtil;
import org.jetbrains.annotations.NotNull;

class VirtualFilePointerImpl
extends TraceableDisposable
implements VirtualFilePointer {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.impl.VirtualFilePointerImpl");
    private final VirtualFilePointerListener myListener;
    private static final boolean TRACE_CREATION = LOG.isDebugEnabled() || ApplicationManager.getApplication().isUnitTestMode();
    volatile FilePointerPartNode myNode;

    VirtualFilePointerImpl(VirtualFilePointerListener listener2, @NotNull Disposable parentDisposable, Pair<VirtualFile, String> fileAndUrl) {
        super(TRACE_CREATION);
        this.myListener = listener2;
    }

    @NotNull
    public String getFileName() {
        if (!this.checkDisposed()) {
            return "";
        }
        Pair<VirtualFile, String> result = this.myNode.update();
        VirtualFile file2 = (VirtualFile)result.first;
        if (file2 != null) {
            return file2.getName();
        }
        String url = (String)result.second;
        int index = url.lastIndexOf(47);
        return index >= 0 ? url.substring(index + 1) : url;
    }

    public VirtualFile getFile() {
        if (!this.checkDisposed()) {
            return null;
        }
        Pair<VirtualFile, String> result = this.myNode.update();
        return (VirtualFile)result.first;
    }

    @NotNull
    public String getUrl() {
        if (this.isDisposed()) {
            return "";
        }
        Pair<VirtualFile, String> update = this.myNode.update();
        return (String)update.second;
    }

    @NotNull
    String getUrlNoUpdate() {
        return this.isDisposed() ? "" : (String)this.myNode.myFileAndUrl.second;
    }

    @NotNull
    public String getPresentableUrl() {
        if (!this.checkDisposed()) {
            return "";
        }
        return PathUtil.toPresentableUrl((String)this.getUrl());
    }

    private boolean checkDisposed() {
        if (this.isDisposed()) {
            ProgressManager.checkCanceled();
            LOG.error("Already disposed: URL='" + (Object)((Object)this) + "'");
            return false;
        }
        return true;
    }

    public boolean isValid() {
        Pair<VirtualFile, String> result = this.isDisposed() ? null : this.myNode.update();
        return result != null && result.first != null;
    }

    public String toString() {
        return this.getUrlNoUpdate();
    }

    public void dispose() {
        this.checkDisposed();
        if (this.myNode.incrementUsageCount(-1) == 0) {
            this.kill("URL when die: " + this.toString());
            VirtualFilePointerManager pointerManager = VirtualFilePointerManager.getInstance();
            if (pointerManager instanceof VirtualFilePointerManagerImpl) {
                ((VirtualFilePointerManagerImpl)pointerManager).removeNode(this.myNode, this.myListener);
            }
            this.myNode = null;
        }
    }

    public boolean isDisposed() {
        return this.myNode == null;
    }

    VirtualFilePointerListener getListener() {
        return this.myListener;
    }
}

