/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.ex.temp;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.io.BufferExposingByteArrayInputStream;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.local.LocalFileSystemBase;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import com.intellij.openapi.vfs.newvfs.impl.FakeVirtualFile;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.LocalTimeCounter;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TempFileSystem
extends LocalFileSystemBase {
    private final FSItem myRoot = new FSDir(null, "/");

    public static TempFileSystem getInstance() {
        return (TempFileSystem)((Object)ApplicationManager.getApplication().getComponent(TempFileSystem.class));
    }

    @Override
    @NotNull
    protected String extractRootPath(@NotNull String path) {
        return "/";
    }

    @Nullable
    private FSItem convert(VirtualFile file2) {
        VirtualFile parentFile = file2.getParent();
        if (parentFile == null) {
            return this.myRoot;
        }
        FSItem parentItem = this.convert(parentFile);
        if (parentItem == null || !parentItem.isDirectory()) {
            return null;
        }
        return parentItem.findChild(file2.getName());
    }

    @Override
    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull VirtualFile parent, @NotNull String dir) throws IOException {
        FSItem fsItem = this.convert(parent);
        assert (fsItem != null && fsItem.isDirectory());
        FSDir fsDir = (FSDir)fsItem;
        FSItem existingDir = fsDir.findChild(dir);
        if (existingDir == null) {
            fsDir.addChild(new FSDir(fsDir, dir));
        } else if (!existingDir.isDirectory()) {
            throw new IOException("Directory already contains a file named " + dir);
        }
        return new FakeVirtualFile(parent, dir);
    }

    @Override
    @NotNull
    public VirtualFile createChildFile(Object requestor, @NotNull VirtualFile parent, @NotNull String file2) throws IOException {
        FSItem fsItem = this.convert(parent);
        if (fsItem == null) {
            FSRecords.invalidateCaches();
            throw new IllegalStateException("cannot find parent directory: " + parent.getPath());
        }
        assert (fsItem.isDirectory()) : "parent is not a directory: " + parent.getPath();
        FSDir fsDir = (FSDir)fsItem;
        assert (fsDir.findChild(file2) == null) : "File " + file2 + " already exists in " + parent.getPath();
        fsDir.addChild(new FSFile(fsDir, file2));
        return new FakeVirtualFile(parent, file2);
    }

    @Override
    @NotNull
    public VirtualFile copyFile(Object requestor, @NotNull VirtualFile file2, @NotNull VirtualFile newParent, @NotNull String copyName) throws IOException {
        return VfsUtilCore.copyFile((Object)requestor, (VirtualFile)file2, (VirtualFile)newParent, (String)copyName);
    }

    @Override
    public void deleteFile(Object requestor, @NotNull VirtualFile file2) throws IOException {
        FSItem fsItem = this.convert(file2);
        if (fsItem == null) {
            FSRecords.invalidateCaches();
            throw new IllegalStateException("failed to delete file " + file2.getPath());
        }
        fsItem.getParent().removeChild(fsItem);
    }

    @Override
    public void moveFile(Object requestor, @NotNull VirtualFile file2, @NotNull VirtualFile newParent) throws IOException {
        FSItem fsItem = this.convert(file2);
        assert (fsItem != null) : "failed to move file " + file2.getPath();
        FSItem newParentItem = this.convert(newParent);
        assert (newParentItem != null && newParentItem.isDirectory()) : "failed to find move target " + file2.getPath();
        FSDir newDir = (FSDir)newParentItem;
        if (newDir.findChild(file2.getName()) != null) {
            throw new IOException("Directory already contains a file named " + file2.getName());
        }
        fsItem.getParent().removeChild(fsItem);
        newDir.addChild(fsItem);
        fsItem.myParent = newDir;
    }

    @Override
    public void renameFile(Object requestor, @NotNull VirtualFile file2, @NotNull String newName) throws IOException {
        FSItem fsItem = this.convert(file2);
        assert (fsItem != null);
        fsItem.setName(newName);
    }

    @Override
    @NotNull
    public String getProtocol() {
        return "temp";
    }

    @Override
    public boolean exists(@NotNull VirtualFile fileOrDirectory) {
        return this.convert(fileOrDirectory) != null;
    }

    @Override
    @NotNull
    public String[] list(@NotNull VirtualFile file2) {
        FSItem fsItem = this.convert(file2);
        assert (fsItem != null);
        return fsItem.list();
    }

    @Override
    public boolean isDirectory(@NotNull VirtualFile file2) {
        return this.convert(file2) instanceof FSDir;
    }

    @Override
    public long getTimeStamp(@NotNull VirtualFile file2) {
        FSItem fsItem = this.convert(file2);
        assert (fsItem != null) : "cannot find item for path " + file2.getPath();
        return fsItem.myTimestamp;
    }

    @Override
    public void setTimeStamp(@NotNull VirtualFile file2, long timeStamp) {
        FSItem fsItem = this.convert(file2);
        assert (fsItem != null);
        fsItem.myTimestamp = timeStamp > 0L ? timeStamp : LocalTimeCounter.currentTime();
    }

    @Override
    public boolean isWritable(@NotNull VirtualFile file2) {
        FSItem fsItem = this.convert(file2);
        assert (fsItem != null);
        return fsItem.myWritable;
    }

    @Override
    public void setWritable(@NotNull VirtualFile file2, boolean writableFlag) throws IOException {
        FSItem fsItem = this.convert(file2);
        assert (fsItem != null);
        fsItem.myWritable = writableFlag;
    }

    @Override
    @NotNull
    public byte[] contentsToByteArray(@NotNull VirtualFile file2) throws IOException {
        FSItem fsItem = this.convert(file2);
        if (fsItem == null) {
            throw new FileNotFoundException("Cannot find temp for " + file2.getPath());
        }
        assert (fsItem instanceof FSFile) : fsItem;
        return ((FSFile)fsItem).myContent;
    }

    @Override
    @NotNull
    public InputStream getInputStream(@NotNull VirtualFile file2) throws IOException {
        return new BufferExposingByteArrayInputStream(this.contentsToByteArray(file2));
    }

    @Override
    @NotNull
    public OutputStream getOutputStream(final @NotNull VirtualFile file2, Object requestor, final long modStamp, long timeStamp) throws IOException {
        return new ByteArrayOutputStream(){

            @Override
            public void close() throws IOException {
                super.close();
                FSItem fsItem = TempFileSystem.this.convert(file2);
                assert (fsItem instanceof FSFile);
                FSFile.access$302((FSFile)fsItem, this.toByteArray());
                TempFileSystem.this.setTimeStamp(file2, modStamp);
            }
        };
    }

    @Override
    public void refresh(boolean asynchronous) {
        RefreshQueue.getInstance().refresh(asynchronous, true, null, ManagingFS.getInstance().getRoots((NewVirtualFileSystem)this));
    }

    @Override
    public VirtualFile findFileByPath(@NotNull @NonNls String path) {
        return VfsImplUtil.findFileByPath((NewVirtualFileSystem)this, path);
    }

    @Override
    public VirtualFile findFileByPathIfCached(@NotNull @NonNls String path) {
        return VfsImplUtil.findFileByPathIfCached((NewVirtualFileSystem)this, path);
    }

    @Override
    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        return VfsImplUtil.refreshAndFindFileByPath((NewVirtualFileSystem)this, path);
    }

    @Override
    public long getLength(@NotNull VirtualFile file2) {
        try {
            return this.contentsToByteArray(file2).length;
        }
        catch (IOException e) {
            return 0L;
        }
    }

    @Override
    public FileAttributes getAttributes(@NotNull VirtualFile file2) {
        FSItem item = this.convert(file2);
        if (item == null) {
            return null;
        }
        long length = item instanceof FSFile ? (long)((FSFile)item).myContent.length : 0L;
        return new FileAttributes(item.isDirectory(), false, false, false, length, item.myTimestamp, item.myWritable);
    }

    @NotNull
    public Set<LocalFileSystem.WatchRequest> addRootsToWatch(@NotNull Collection<String> rootPaths, boolean watchRecursively) {
        throw new IncorrectOperationException();
    }

    public void removeWatchedRoots(@NotNull Collection<LocalFileSystem.WatchRequest> watchRequests) {
        throw new IncorrectOperationException();
    }

    @NotNull
    public Set<LocalFileSystem.WatchRequest> replaceWatchedRoots(@NotNull Collection<LocalFileSystem.WatchRequest> watchRequests, @Nullable Collection<String> recursiveRoots, @Nullable Collection<String> flatRoots) {
        throw new IncorrectOperationException();
    }

    @Override
    @Nullable
    protected String normalize(@NotNull String path) {
        return path;
    }

    private static class FSFile
    extends FSItem {
        private byte[] myContent = new byte[0];

        public FSFile(FSDir parent, String name) {
            super(parent, name);
        }

        @Override
        public boolean isDirectory() {
            return false;
        }

        static /* synthetic */ byte[] access$302(FSFile x0, byte[] x1) {
            x0.myContent = x1;
            return x1;
        }
    }

    private static class FSDir
    extends FSItem {
        private final List<FSItem> myChildren = new ArrayList<FSItem>();

        public FSDir(FSDir parent, String name) {
            super(parent, name);
        }

        @Override
        @Nullable
        public FSItem findChild(String name) {
            for (FSItem child : this.myChildren) {
                if (!name.equals(child.myName)) continue;
                return child;
            }
            return null;
        }

        @Override
        public boolean isDirectory() {
            return true;
        }

        public void addChild(FSItem item) {
            this.myChildren.add(item);
        }

        public void removeChild(FSItem fsItem) {
            if (fsItem.myName.equals("src") && this.getParent() == null) {
                throw new RuntimeException("removing src directory");
            }
            this.myChildren.remove(fsItem);
        }

        @Override
        public String[] list() {
            String[] names = ArrayUtil.newStringArray((int)this.myChildren.size());
            for (int i = 0; i < names.length; ++i) {
                names[i] = this.myChildren.get(i).myName;
            }
            return names;
        }
    }

    private static abstract class FSItem {
        private FSDir myParent;
        private String myName;
        private long myTimestamp;
        private boolean myWritable;

        protected FSItem(FSDir parent, String name) {
            this.myParent = parent;
            this.myName = name;
            this.myTimestamp = LocalTimeCounter.currentTime();
            this.myWritable = true;
        }

        public abstract boolean isDirectory();

        @Nullable
        public FSItem findChild(String name) {
            return null;
        }

        public void setName(String name) {
            this.myName = name;
        }

        public FSDir getParent() {
            return this.myParent;
        }

        public String[] list() {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + this.myName;
        }
    }
}

