/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.ex.dummy;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.ex.dummy.DummyFileIdGenerator;
import com.intellij.openapi.vfs.ex.dummy.DummyFileSystem;
import com.intellij.openapi.vfs.ex.dummy.VirtualFileDirectoryImpl;
import org.jetbrains.annotations.NotNull;

abstract class VirtualFileImpl
extends VirtualFile
implements VirtualFileWithId {
    private final DummyFileSystem myFileSystem;
    private final VirtualFileDirectoryImpl myParent;
    private String myName;
    protected boolean myIsValid = true;
    private final int myId = DummyFileIdGenerator.next();

    protected VirtualFileImpl(DummyFileSystem fileSystem, VirtualFileDirectoryImpl parent, String name) {
        this.myFileSystem = fileSystem;
        this.myParent = parent;
        this.myName = name;
    }

    public int getId() {
        return this.myId;
    }

    @NotNull
    public VirtualFileSystem getFileSystem() {
        return this.myFileSystem;
    }

    @NotNull
    public String getPath() {
        if (this.myParent == null) {
            return this.myName;
        }
        return this.myParent.getPath() + "/" + this.myName;
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    void setName(String name) {
        this.myName = name;
    }

    public boolean isWritable() {
        return true;
    }

    public boolean isValid() {
        return this.myIsValid;
    }

    public VirtualFile getParent() {
        return this.myParent;
    }

    public long getTimeStamp() {
        return -1L;
    }

    public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
    }
}

