/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.ex.dummy;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerAdapter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.dummy.DummyFileSystem;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.FactoryMap;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DummyCachingFileSystem<T extends VirtualFile>
extends DummyFileSystem {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.openapi.vfs.ex.dummy.DummyCachingFileSystem");
    private final String myProtocol;
    private final BidirectionalMap<Project, String> myProject2Id = new BidirectionalMap();
    private final FactoryMap<String, T> myCachedFiles = new ConcurrentFactoryMap<String, T>(){

        protected T create(String key) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                DummyCachingFileSystem.this.cleanup();
                DummyCachingFileSystem.this.initProjectMap();
            }
            return DummyCachingFileSystem.this.findFileByPathInner(key);
        }

        public T get(Object key) {
            VirtualFile file2 = (VirtualFile)super.get(key);
            if (file2 != null && !file2.isValid()) {
                this.remove(key);
                return (VirtualFile)super.get(key);
            }
            return file2;
        }
    };

    public DummyCachingFileSystem(String protocol) {
        this.myProtocol = protocol;
        Application application = ApplicationManager.getApplication();
        application.getMessageBus().connect((Disposable)application).subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerAdapter(){

            public void projectOpened(Project project2) {
                DummyCachingFileSystem.this.onProjectOpened(project2);
            }
        });
        this.initProjectMap();
    }

    @Override
    @NotNull
    public final String getProtocol() {
        return this.myProtocol;
    }

    @Override
    @Nullable
    public final VirtualFile createRoot(String name) {
        return null;
    }

    public final T findFileByPath(@NotNull String path) {
        return (T)((VirtualFile)this.myCachedFiles.get((Object)path));
    }

    @Override
    @NotNull
    public String extractPresentableUrl(@NotNull String path) {
        T file2 = this.findFileByPath(path);
        return file2 != null ? this.getPresentableUrl((VirtualFile)file2) : super.extractPresentableUrl(path);
    }

    protected String getPresentableUrl(@NotNull VirtualFile file2) {
        return file2.getPresentableName();
    }

    protected abstract T findFileByPathInner(@NotNull String var1);

    protected void doRenameFile(VirtualFile vFile, String newName) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Nullable
    public Project getProject(String projectId) {
        List list = this.myProject2Id.getKeysByValue((Object)projectId);
        return list == null || list.size() > 1 ? null : (Project)list.get(0);
    }

    @NotNull
    public Collection<T> getCachedFiles() {
        return this.myCachedFiles.notNullValues();
    }

    public void onProjectClosed(Project project2) {
        this.myProject2Id.remove((Object)project2);
        this.clearCache();
    }

    public void onProjectOpened(final Project project2) {
        Disposer.register((Disposable)project2, (Disposable)new Disposable(){

            public void dispose() {
                DummyCachingFileSystem.this.onProjectClosed(project2);
            }
        });
        this.clearCache();
        String projectId = project2.getLocationHash();
        this.myProject2Id.put((Object)project2, (Object)projectId);
        List projects = this.myProject2Id.getKeysByValue((Object)projectId);
        if (projects != null && projects.size() > 1) {
            LOG.error("project " + projectId + " already registered: " + projects);
        }
    }

    private void initProjectMap() {
        for (Project project2 : ProjectManager.getInstance().getOpenProjects()) {
            if (!project2.isOpen()) continue;
            this.onProjectOpened(project2);
        }
    }

    protected void clearCache() {
        this.clearInvalidFiles();
    }

    protected void clearInvalidFiles() {
        for (VirtualFile t : this.myCachedFiles.notNullValues()) {
            if (t.isValid()) continue;
            this.myCachedFiles.removeValue((Object)t);
        }
        while (this.myCachedFiles.removeValue(null)) {
        }
    }

    public void cleanup() {
        this.myCachedFiles.clear();
        this.myProject2Id.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameFile(Object requestor, @NotNull VirtualFile vFile, @NotNull String newName) throws IOException {
        String oldName = vFile.getName();
        this.beforeFileRename(vFile, requestor, oldName, newName);
        try {
            this.doRenameFile(vFile, newName);
        }
        finally {
            this.fileRenamed(vFile, requestor, oldName, newName);
        }
    }

    protected void beforeFileRename(@NotNull VirtualFile file2, Object requestor, @NotNull String oldName, @NotNull String newName) {
        this.fireBeforePropertyChange(requestor, file2, "name", oldName, newName);
        this.myCachedFiles.remove((Object)file2.getPath());
    }

    protected void fileRenamed(@NotNull VirtualFile file2, Object requestor, String oldName, String newName) {
        this.myCachedFiles.put((Object)file2.getPath(), (Object)file2);
        this.firePropertyChanged(requestor, file2, "name", oldName, newName);
    }

    protected static String escapeSlash(String name) {
        return name == null ? "" : StringUtil.replace((String)name, (String)"/", (String)"&slash;");
    }

    protected static String unescapeSlash(String name) {
        return name == null ? "" : StringUtil.replace((String)name, (String)"&slash;", (String)"/");
    }
}

