/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.encoding;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.encoding.ChangeFileEncodingAction;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingManagerImpl;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="Encoding", storages={@Storage(value="encodings.xml")})
public class EncodingProjectManagerImpl
extends EncodingProjectManager
implements PersistentStateComponent<Element> {
    @NonNls
    private static final String PROJECT_URL = "PROJECT";
    private final Project myProject;
    private final EncodingManagerImpl myIdeEncodingManager;
    private boolean myNative2AsciiForPropertiesFiles;
    private Charset myDefaultCharsetForPropertiesFiles;
    private final SimpleModificationTracker myModificationTracker = new SimpleModificationTracker();
    private String myOldUTFGuessing;
    private boolean myNative2AsciiForPropertiesFilesWasSpecified;
    private final Map<VirtualFile, Charset> myMapping = ContainerUtil.newConcurrentMap();
    private volatile Charset myProjectCharset;
    private static final ThreadLocal<Boolean> SUPPRESS_RELOAD = new ThreadLocal();

    public EncodingProjectManagerImpl(Project project2, PsiDocumentManager documentManager, EncodingManager ideEncodingManager) {
        this.myProject = project2;
        this.myIdeEncodingManager = (EncodingManagerImpl)ideEncodingManager;
        documentManager.addListener(new PsiDocumentManager.Listener(){

            public void documentCreated(@NotNull Document document, PsiFile psiFile) {
                EncodingProjectManagerImpl.this.myIdeEncodingManager.queueUpdateEncodingFromContent(document);
            }

            public void fileCreated(@NotNull PsiFile file2, @NotNull Document document) {
            }
        });
    }

    public Element getState() {
        Element element = new Element("x");
        if (!this.myMapping.isEmpty()) {
            ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(this.myMapping.keySet());
            ContainerUtil.quickSort(files, (Comparator)new Comparator<VirtualFile>(){

                @Override
                public int compare(@NotNull VirtualFile o1, @NotNull VirtualFile o2) {
                    return o1.getPath().compareTo(o2.getPath());
                }
            });
            for (VirtualFile file2 : files) {
                Charset charset = this.myMapping.get(file2);
                Element child = new Element("file");
                element.addContent(child);
                child.setAttribute("url", file2.getUrl());
                child.setAttribute("charset", charset.name());
            }
        }
        if (this.myProjectCharset != null) {
            Element child = new Element("file");
            element.addContent(child);
            child.setAttribute("url", PROJECT_URL);
            child.setAttribute("charset", this.myProjectCharset.name());
        }
        if (this.myOldUTFGuessing != null) {
            element.setAttribute("useUTFGuessing", this.myOldUTFGuessing);
        }
        if (this.myNative2AsciiForPropertiesFiles || this.myNative2AsciiForPropertiesFilesWasSpecified) {
            element.setAttribute("native2AsciiForPropertiesFiles", Boolean.toString(this.myNative2AsciiForPropertiesFiles));
        }
        if (this.myDefaultCharsetForPropertiesFiles != null) {
            element.setAttribute("defaultCharsetForPropertiesFiles", this.myDefaultCharsetForPropertiesFiles.name());
        }
        return element;
    }

    public void loadState(Element element) {
        this.myMapping.clear();
        List files = element.getChildren("file");
        if (!files.isEmpty()) {
            HashMap<VirtualFile, Charset> mapping = new HashMap<VirtualFile, Charset>();
            for (Element fileElement : files) {
                String url = fileElement.getAttributeValue("url");
                String charsetName = fileElement.getAttributeValue("charset");
                Charset charset = CharsetToolkit.forName((String)charsetName);
                if (charset == null) continue;
                if (url.equals(PROJECT_URL)) {
                    this.myProjectCharset = charset;
                    continue;
                }
                VirtualFile file2 = VirtualFileManager.getInstance().findFileByUrl(url);
                if (file2 == null) continue;
                mapping.put(file2, charset);
            }
            this.myMapping.putAll(mapping);
        }
        String native2AsciiForPropertiesFiles = element.getAttributeValue("native2AsciiForPropertiesFiles");
        this.myNative2AsciiForPropertiesFiles = Boolean.parseBoolean(native2AsciiForPropertiesFiles);
        this.myDefaultCharsetForPropertiesFiles = CharsetToolkit.forName((String)element.getAttributeValue("defaultCharsetForPropertiesFiles"));
        this.myModificationTracker.incModificationCount();
        if (!this.myProject.isDefault()) {
            this.myOldUTFGuessing = element.getAttributeValue("useUTFGuessing");
            this.myNative2AsciiForPropertiesFilesWasSpecified = native2AsciiForPropertiesFiles != null;
        }
    }

    @Nullable
    public Charset getEncoding(@Nullable VirtualFile virtualFile, boolean useParentDefaults) {
        for (VirtualFile parent = virtualFile; parent != null; parent = parent.getParent()) {
            Charset charset = this.myMapping.get(parent);
            if (charset == null && useParentDefaults) continue;
            return charset;
        }
        return this.getDefaultCharset();
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        return this.myModificationTracker;
    }

    public void setEncoding(@Nullable VirtualFile virtualFileOrDir, @Nullable Charset charset) {
        Charset oldCharset;
        if (virtualFileOrDir == null) {
            oldCharset = this.myProjectCharset;
            this.myProjectCharset = charset;
        } else {
            oldCharset = charset == null ? this.myMapping.remove(virtualFileOrDir) : this.myMapping.put(virtualFileOrDir, charset);
        }
        if (!Comparing.equal((Object)oldCharset, (Object)charset)) {
            this.myModificationTracker.incModificationCount();
            if (virtualFileOrDir != null) {
                virtualFileOrDir.setCharset(virtualFileOrDir.getBOM() == null ? charset : null);
            }
            this.reloadAllFilesUnder(virtualFileOrDir);
        }
    }

    private static void clearAndReload(@NotNull VirtualFile virtualFileOrDir) {
        virtualFileOrDir.setCharset(null);
        EncodingProjectManagerImpl.reload(virtualFileOrDir);
    }

    private static void reload(final @NotNull VirtualFile virtualFile) {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                FileDocumentManager documentManager = FileDocumentManager.getInstance();
                ((VirtualFileListener)documentManager).contentsChanged(new VirtualFileEvent(null, virtualFile, virtualFile.getName(), virtualFile.getParent()));
            }
        });
    }

    @NotNull
    public Collection<Charset> getFavorites() {
        Set<Charset> result = EncodingProjectManagerImpl.widelyKnownCharsets();
        result.addAll(this.myMapping.values());
        result.add(this.getDefaultCharset());
        return result;
    }

    @NotNull
    static Set<Charset> widelyKnownCharsets() {
        HashSet<Charset> result = new HashSet<Charset>();
        result.add(CharsetToolkit.UTF8_CHARSET);
        result.add(CharsetToolkit.getDefaultSystemCharset());
        result.add(CharsetToolkit.UTF_16_CHARSET);
        result.add(CharsetToolkit.forName((String)"ISO-8859-1"));
        result.add(CharsetToolkit.forName((String)"US-ASCII"));
        result.add(EncodingManager.getInstance().getDefaultCharset());
        result.add(EncodingManager.getInstance().getDefaultCharsetForPropertiesFiles(null));
        result.remove(null);
        return result;
    }

    @NotNull
    public Map<VirtualFile, Charset> getAllMappings() {
        return this.myMapping;
    }

    public void setMapping(final @NotNull Map<VirtualFile, Charset> mapping) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        FileDocumentManager.getInstance().saveAllDocuments();
        THashMap newMap = new THashMap(mapping.size());
        THashMap oldMap = new THashMap(this.myMapping);
        EncodingProjectManagerImpl.suppressReloadDuring(new Runnable((Map)oldMap, (Map)newMap){
            final /* synthetic */ Map val$oldMap;
            final /* synthetic */ Map val$newMap;
            {
                this.val$oldMap = map2;
                this.val$newMap = map3;
            }

            @Override
            public void run() {
                ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)EncodingProjectManagerImpl.this.myProject).getFileIndex();
                for (Map.Entry entry : mapping.entrySet()) {
                    VirtualFile virtualFile = (VirtualFile)entry.getKey();
                    Charset charset = (Charset)entry.getValue();
                    if (charset == null) {
                        throw new IllegalArgumentException("Null charset for " + virtualFile + "; mapping: " + mapping);
                    }
                    if (virtualFile == null) {
                        EncodingProjectManagerImpl.this.myProjectCharset = charset;
                        continue;
                    }
                    if (!fileIndex.isInContent(virtualFile)) continue;
                    if (!virtualFile.isDirectory() && !Comparing.equal((Object)charset, this.val$oldMap.get(virtualFile))) {
                        byte[] bytes;
                        Document document;
                        try {
                            document = FileDocumentManager.getInstance().getDocument(virtualFile);
                            if (document == null) {
                                throw new IOException();
                            }
                            bytes = virtualFile.contentsToByteArray();
                        }
                        catch (IOException e) {
                            continue;
                        }
                        boolean changed = new ChangeFileEncodingAction().chosen(document, null, virtualFile, bytes, charset);
                        if (!changed) continue;
                    }
                    this.val$newMap.put(virtualFile, charset);
                }
            }
        });
        this.myMapping.clear();
        this.myMapping.putAll((Map<VirtualFile, Charset>)newMap);
        final HashSet changed = new HashSet(oldMap.keySet());
        for (Map.Entry entry : newMap.entrySet()) {
            VirtualFile file2 = (VirtualFile)entry.getKey();
            Charset charset = (Charset)entry.getValue();
            Charset oldCharset = (Charset)oldMap.get(file2);
            if (!Comparing.equal((Object)oldCharset, (Object)charset)) continue;
            changed.remove(file2);
        }
        HashSet added = new HashSet(newMap.keySet());
        added.removeAll(oldMap.keySet());
        HashSet removed = new HashSet(oldMap.keySet());
        removed.removeAll(newMap.keySet());
        changed.addAll(added);
        changed.addAll(removed);
        changed.remove(null);
        if (!changed.isEmpty()) {
            final Processor<VirtualFile> reloadProcessor = EncodingProjectManagerImpl.createChangeCharsetProcessor();
            this.tryStartReloadWithProgress(new Runnable(){

                @Override
                public void run() {
                    THashSet processed2 = new THashSet();
                    block0: for (VirtualFile changedFile : changed) {
                        for (VirtualFile processedFile : processed2) {
                            if (!VfsUtilCore.isAncestor((VirtualFile)processedFile, (VirtualFile)changedFile, (boolean)false)) continue;
                            continue block0;
                        }
                        EncodingProjectManagerImpl.this.processSubFiles(changedFile, (Processor<VirtualFile>)reloadProcessor);
                        processed2.add(changedFile);
                    }
                }
            });
        }
        this.myModificationTracker.incModificationCount();
    }

    private static Processor<VirtualFile> createChangeCharsetProcessor() {
        return new Processor<VirtualFile>(){

            public boolean process(final VirtualFile file2) {
                if (!(file2 instanceof VirtualFileSystemEntry)) {
                    return false;
                }
                Document cachedDocument = FileDocumentManager.getInstance().getCachedDocument(file2);
                if (cachedDocument == null) {
                    return true;
                }
                ProgressManager.progress((String)"Reloading files...", (String)file2.getPresentableUrl());
                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        EncodingProjectManagerImpl.clearAndReload(file2);
                    }
                });
                return true;
            }
        };
    }

    private boolean processSubFiles(@Nullable(value="null means all in the project") VirtualFile file2, final @NotNull Processor<VirtualFile> processor2) {
        if (file2 == null) {
            for (VirtualFile virtualFile : ProjectRootManager.getInstance((Project)this.myProject).getContentRoots()) {
                if (this.processSubFiles(virtualFile, processor2)) continue;
                return false;
            }
            return true;
        }
        return VirtualFileVisitor.CONTINUE == VfsUtilCore.visitChildrenRecursively((VirtualFile)file2, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file2) {
                return processor2.process((Object)file2);
            }
        });
    }

    @NotNull
    public Charset getDefaultCharset() {
        Charset charset = this.myProjectCharset;
        return charset == null ? this.myIdeEncodingManager.getDefaultCharset() : charset;
    }

    public boolean isUseUTFGuessing(VirtualFile virtualFile) {
        return true;
    }

    static void suppressReloadDuring(@NotNull Runnable action) {
        Boolean old = SUPPRESS_RELOAD.get();
        try {
            SUPPRESS_RELOAD.set(Boolean.TRUE);
            action.run();
        }
        finally {
            SUPPRESS_RELOAD.set(old);
        }
    }

    private boolean tryStartReloadWithProgress(final @NotNull Runnable reloadAction) {
        Boolean suppress = SUPPRESS_RELOAD.get();
        if (suppress == Boolean.TRUE) {
            return false;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        return ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                EncodingProjectManagerImpl.suppressReloadDuring(reloadAction);
            }
        }, "Reload Files", false, this.myProject);
    }

    private void reloadAllFilesUnder(final @Nullable VirtualFile root) {
        this.tryStartReloadWithProgress(new Runnable(){

            @Override
            public void run() {
                EncodingProjectManagerImpl.this.processSubFiles(root, (Processor<VirtualFile>)((Processor)new Processor<VirtualFile>(){

                    public boolean process(final VirtualFile file2) {
                        if (!(file2 instanceof VirtualFileSystemEntry)) {
                            return true;
                        }
                        Document cachedDocument = FileDocumentManager.getInstance().getCachedDocument(file2);
                        if (cachedDocument != null) {
                            ProgressManager.progress((String)"Reloading file...", (String)file2.getPresentableUrl());
                            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    EncodingProjectManagerImpl.reload(file2);
                                }
                            });
                        } else if (file2.isCharsetSet() && !file2.equals(root)) {
                            file2.setCharset(null);
                        }
                        return true;
                    }
                }));
            }
        });
    }

    public boolean isNative2Ascii(@NotNull VirtualFile virtualFile) {
        return virtualFile.getFileType() == StdFileTypes.PROPERTIES && this.myNative2AsciiForPropertiesFiles;
    }

    public boolean isNative2AsciiForPropertiesFiles() {
        return this.myNative2AsciiForPropertiesFiles;
    }

    public void setNative2AsciiForPropertiesFiles(VirtualFile virtualFile, boolean native2Ascii) {
        if (this.myNative2AsciiForPropertiesFiles != native2Ascii) {
            this.myNative2AsciiForPropertiesFiles = native2Ascii;
            this.myIdeEncodingManager.firePropertyChange(null, "native2ascii", !native2Ascii, native2Ascii);
        }
    }

    @NotNull
    public String getDefaultCharsetName() {
        Charset charset = this.getEncoding(null, false);
        return charset == null ? "" : charset.name();
    }

    public void setDefaultCharsetName(@NotNull String name) {
        this.setEncoding(null, name.isEmpty() ? null : CharsetToolkit.forName((String)name));
    }

    @Nullable
    public Charset getDefaultCharsetForPropertiesFiles(@Nullable VirtualFile virtualFile) {
        return this.myDefaultCharsetForPropertiesFiles;
    }

    public void setDefaultCharsetForPropertiesFiles(@Nullable VirtualFile virtualFile, @Nullable Charset charset) {
        Charset old = this.myDefaultCharsetForPropertiesFiles;
        if (!Comparing.equal((Object)old, (Object)charset)) {
            this.myDefaultCharsetForPropertiesFiles = charset;
            this.myIdeEncodingManager.firePropertyChange(null, "propertiesFilesEncoding", old, charset);
        }
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2, @NotNull Disposable parentDisposable) {
        this.myIdeEncodingManager.addPropertyChangeListener(listener2, parentDisposable);
    }

    @Nullable
    public Charset getCachedCharsetFromContent(@NotNull Document document) {
        return this.myIdeEncodingManager.getCachedCharsetFromContent(document);
    }
}

