/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.encoding;

import com.intellij.concurrency.JobSchedulerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorFactoryAdapter;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.ChooseFileEncodingAction;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManagerImpl;
import com.intellij.util.Alarm;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.BoundedTaskExecutor;
import com.intellij.util.xmlb.annotations.Attribute;
import gnu.trove.Equality;
import gnu.trove.THashSet;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

@com.intellij.openapi.components.State(name="Encoding", storages={@Storage(value="encoding.xml")})
public class EncodingManagerImpl
extends EncodingManager
implements PersistentStateComponent<State>,
Disposable {
    private static final Equality<Reference<Document>> REFERENCE_EQUALITY = new Equality<Reference<Document>>(){

        public boolean equals(Reference<Document> o1, Reference<Document> o2) {
            Equality v1 = o1 == null ? REFERENCE_EQUALITY : o1.get();
            Equality v2 = o2 == null ? REFERENCE_EQUALITY : o2.get();
            return v1 == v2;
        }
    };
    private final PropertyChangeSupport myPropertyChangeSupport = new PropertyChangeSupport((Object)this);
    private State myState = new State();
    private final Alarm updateEncodingFromContent = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
    private static final Key<Charset> CACHED_CHARSET_FROM_CONTENT = Key.create((String)"CACHED_CHARSET_FROM_CONTENT");
    private final BoundedTaskExecutor changedDocumentExecutor = new BoundedTaskExecutor((Executor)PooledThreadExecutor.INSTANCE, JobSchedulerImpl.CORES_COUNT, (Disposable)this);
    @NonNls
    public static final String PROP_CACHED_ENCODING_CHANGED = "cachedEncoding";
    private static final Key<String> DETECTING_ENCODING_KEY = Key.create((String)"DETECTING_ENCODING_KEY");

    public EncodingManagerImpl(@NotNull EditorFactory editorFactory) {
        editorFactory.getEventMulticaster().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                EncodingManagerImpl.this.queueUpdateEncodingFromContent(e.getDocument());
            }
        }, (Disposable)this);
        editorFactory.addEditorFactoryListener((EditorFactoryListener)new EditorFactoryAdapter(){

            public void editorCreated(@NotNull EditorFactoryEvent event) {
                EncodingManagerImpl.this.queueUpdateEncodingFromContent(event.getEditor().getDocument());
            }
        }, (Disposable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDocument(@NotNull Document document) {
        if (document.getUserData(DETECTING_ENCODING_KEY) == null) {
            return;
        }
        try {
            Charset oldCached;
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
            if (virtualFile == null) {
                return;
            }
            Project project2 = EncodingManagerImpl.guessProject(virtualFile);
            if (project2 != null && project2.isDisposed()) {
                return;
            }
            Charset charset = LoadTextUtil.charsetFromContentOrNull(project2, virtualFile, document.getImmutableCharSequence());
            if (!Comparing.equal((Object)charset, (Object)(oldCached = this.getCachedCharsetFromContent(document)))) {
                this.setCachedCharsetFromContent(charset, oldCached, document);
            }
        }
        finally {
            document.putUserData(DETECTING_ENCODING_KEY, null);
        }
    }

    private void setCachedCharsetFromContent(Charset charset, Charset oldCached, @NotNull Document document) {
        document.putUserData(CACHED_CHARSET_FROM_CONTENT, (Object)charset);
        this.firePropertyChange(document, PROP_CACHED_ENCODING_CHANGED, oldCached, charset);
    }

    @Nullable(value="returns null if charset set cannot be determined from content")
    Charset computeCharsetFromContent(final @NotNull VirtualFile virtualFile) {
        final Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        if (document == null) {
            return null;
        }
        Charset cached = EncodingManager.getInstance().getCachedCharsetFromContent(document);
        if (cached != null) {
            return cached;
        }
        final Project project2 = ProjectLocator.getInstance().guessProjectForFile(virtualFile);
        return (Charset)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Charset>(){

            public Charset compute() {
                Charset charsetFromContent = LoadTextUtil.charsetFromContentOrNull(project2, virtualFile, document.getImmutableCharSequence());
                if (charsetFromContent != null) {
                    EncodingManagerImpl.this.setCachedCharsetFromContent(charsetFromContent, null, document);
                }
                return charsetFromContent;
            }
        });
    }

    public void dispose() {
        this.updateEncodingFromContent.cancelAllRequests();
        this.clearDocumentQueue();
    }

    void queueUpdateEncodingFromContent(@NotNull Document document) {
        document.putUserData(DETECTING_ENCODING_KEY, (Object)"");
        this.changedDocumentExecutor.execute((Runnable)new DocumentEncodingDetectRequest(document));
    }

    @Nullable
    public Charset getCachedCharsetFromContent(@NotNull Document document) {
        return (Charset)document.getUserData(CACHED_CHARSET_FROM_CONTENT);
    }

    public State getState() {
        return this.myState;
    }

    public void loadState(State state) {
        this.myState = state;
    }

    @NotNull
    public Collection<Charset> getFavorites() {
        Project[] projects;
        THashSet result = new THashSet();
        for (Project project2 : projects = ProjectManager.getInstance().getOpenProjects()) {
            result.addAll(EncodingProjectManager.getInstance((Project)project2).getFavorites());
        }
        result.addAll(EncodingProjectManagerImpl.widelyKnownCharsets());
        return result;
    }

    @Nullable
    public Charset getEncoding(@Nullable VirtualFile virtualFile, boolean useParentDefaults) {
        Project project2 = EncodingManagerImpl.guessProject(virtualFile);
        if (project2 == null) {
            return null;
        }
        EncodingProjectManager encodingManager = EncodingProjectManager.getInstance((Project)project2);
        if (encodingManager == null) {
            return null;
        }
        return encodingManager.getEncoding(virtualFile, useParentDefaults);
    }

    public void clearDocumentQueue() {
        this.changedDocumentExecutor.clearAndCancelAll();
    }

    @Nullable
    private static Project guessProject(VirtualFile virtualFile) {
        return ProjectLocator.getInstance().guessProjectForFile(virtualFile);
    }

    public void setEncoding(@Nullable VirtualFile virtualFileOrDir, @Nullable Charset charset) {
        Project project2 = EncodingManagerImpl.guessProject(virtualFileOrDir);
        EncodingProjectManager.getInstance((Project)project2).setEncoding(virtualFileOrDir, charset);
    }

    public boolean isUseUTFGuessing(VirtualFile virtualFile) {
        return true;
    }

    public boolean isNative2Ascii(@NotNull VirtualFile virtualFile) {
        Project project2 = EncodingManagerImpl.guessProject(virtualFile);
        return project2 != null && EncodingProjectManager.getInstance((Project)project2).isNative2Ascii(virtualFile);
    }

    public boolean isNative2AsciiForPropertiesFiles() {
        Project project2 = EncodingManagerImpl.guessProject(null);
        return project2 != null && EncodingProjectManager.getInstance((Project)project2).isNative2AsciiForPropertiesFiles();
    }

    public void setNative2AsciiForPropertiesFiles(VirtualFile virtualFile, boolean native2Ascii) {
        Project project2 = EncodingManagerImpl.guessProject(virtualFile);
        if (project2 == null) {
            return;
        }
        EncodingProjectManager.getInstance((Project)project2).setNative2AsciiForPropertiesFiles(virtualFile, native2Ascii);
    }

    @NotNull
    public Charset getDefaultCharset() {
        return this.myState.myDefaultEncoding == ChooseFileEncodingAction.NO_ENCODING ? CharsetToolkit.getDefaultSystemCharset() : this.myState.myDefaultEncoding;
    }

    @NotNull
    public String getDefaultCharsetName() {
        return this.myState.getDefaultCharsetName();
    }

    public void setDefaultCharsetName(@NotNull String name) {
        this.myState.setDefaultCharsetName(name);
    }

    @Nullable
    public Charset getDefaultCharsetForPropertiesFiles(@Nullable VirtualFile virtualFile) {
        Project project2 = EncodingManagerImpl.guessProject(virtualFile);
        if (project2 == null) {
            return null;
        }
        return EncodingProjectManager.getInstance((Project)project2).getDefaultCharsetForPropertiesFiles(virtualFile);
    }

    public void setDefaultCharsetForPropertiesFiles(@Nullable VirtualFile virtualFile, Charset charset) {
        Project project2 = EncodingManagerImpl.guessProject(virtualFile);
        if (project2 == null) {
            return;
        }
        EncodingProjectManager.getInstance((Project)project2).setDefaultCharsetForPropertiesFiles(virtualFile, charset);
    }

    public void addPropertyChangeListener(final @NotNull PropertyChangeListener listener2, @NotNull Disposable parentDisposable) {
        this.myPropertyChangeSupport.addPropertyChangeListener(listener2);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                EncodingManagerImpl.this.removePropertyChangeListener(listener2);
            }
        });
    }

    private void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        this.myPropertyChangeSupport.removePropertyChangeListener(listener2);
    }

    void firePropertyChange(@Nullable Document document, @NotNull String propertyName, Object oldValue, Object newValue) {
        EncodingManagerImpl source = document == null ? this : document;
        this.myPropertyChangeSupport.firePropertyChange(new PropertyChangeEvent((Object)source, propertyName, oldValue, newValue));
    }

    private static class DocumentEncodingDetectRequest
    implements Runnable {
        private final Reference<Document> ref;

        private DocumentEncodingDetectRequest(@NotNull Document document) {
            this.ref = new WeakReference<Document>(document);
        }

        @Override
        public void run() {
            Document document = this.ref.get();
            if (document == null) {
                return;
            }
            ((EncodingManagerImpl)EncodingManager.getInstance()).handleDocument(document);
        }
    }

    static class State {
        @NotNull
        private Charset myDefaultEncoding = CharsetToolkit.UTF8_CHARSET;

        State() {
        }

        @Attribute(value="default_encoding")
        @NotNull
        public String getDefaultCharsetName() {
            return this.myDefaultEncoding == ChooseFileEncodingAction.NO_ENCODING ? "" : this.myDefaultEncoding.name();
        }

        public void setDefaultCharsetName(@NotNull String name) {
            this.myDefaultEncoding = name.isEmpty() ? ChooseFileEncodingAction.NO_ENCODING : (Charset)ObjectUtils.notNull((Object)CharsetToolkit.forName((String)name), (Object)CharsetToolkit.getDefaultSystemCharset());
        }
    }
}

