/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.encoding;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.ChangeFileEncodingTo;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.util.Function;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChooseFileEncodingAction
extends ComboBoxAction {
    private final VirtualFile myVirtualFile;
    public static final Charset NO_ENCODING = new Charset("NO_ENCODING", null){

        @Override
        public boolean contains(Charset cs) {
            return false;
        }

        @Override
        public CharsetDecoder newDecoder() {
            return null;
        }

        @Override
        public CharsetEncoder newEncoder() {
            return null;
        }
    };

    public ChooseFileEncodingAction(VirtualFile virtualFile) {
        this.myVirtualFile = virtualFile;
    }

    public abstract void update(AnActionEvent var1);

    private void fillCharsetActions(@NotNull DefaultActionGroup group, @Nullable VirtualFile virtualFile, @NotNull List<Charset> charsets, final @NotNull Function<Charset, String> charsetFilter) {
        for (final Charset slave : charsets) {
            ChangeFileEncodingTo action = new ChangeFileEncodingTo(virtualFile, slave){
                {
                    super(file2, charset);
                    String description = (String)charsetFilter.fun((Object)slave);
                    if (description == null) {
                        this.getTemplatePresentation().setIcon(AllIcons.General.Warning);
                    } else {
                        this.getTemplatePresentation().setDescription(description);
                    }
                }

                public void update(@NotNull AnActionEvent e) {
                }

                @Override
                protected void chosen(VirtualFile file2, @NotNull Charset charset) {
                    ChooseFileEncodingAction.this.chosen(file2, charset);
                }
            };
            group.add((AnAction)action);
        }
    }

    protected abstract void chosen(@Nullable VirtualFile var1, @NotNull Charset var2);

    @NotNull
    protected DefaultActionGroup createCharsetsActionGroup(@Nullable(value="null means do not show 'clear' text") String clearItemText, Charset alreadySelected, @NotNull Function<Charset, String> charsetFilter) {
        DefaultActionGroup group = new DefaultActionGroup();
        ArrayList<Charset> favorites = new ArrayList<Charset>(EncodingManager.getInstance().getFavorites());
        Collections.sort(favorites);
        Charset current = this.myVirtualFile == null ? null : this.myVirtualFile.getCharset();
        favorites.remove(current);
        favorites.remove(alreadySelected);
        if (clearItemText != null) {
            group.add((AnAction)new ClearThisFileEncodingAction(this.myVirtualFile, clearItemText));
        }
        if (favorites.isEmpty() && clearItemText == null) {
            this.fillCharsetActions(group, this.myVirtualFile, Arrays.asList(CharsetToolkit.getAvailableCharsets()), charsetFilter);
        } else {
            this.fillCharsetActions(group, this.myVirtualFile, favorites, charsetFilter);
            DefaultActionGroup more = new DefaultActionGroup("more", true);
            group.add((AnAction)more);
            this.fillCharsetActions(more, this.myVirtualFile, Arrays.asList(CharsetToolkit.getAvailableCharsets()), charsetFilter);
        }
        return group;
    }

    private class ClearThisFileEncodingAction
    extends AnAction {
        private final VirtualFile myFile;

        private ClearThisFileEncodingAction(@NotNull VirtualFile file2, String clearItemText) {
            super(clearItemText, "Clear " + (file2 == null ? "default" : "file '" + file2.getName() + "'") + " encoding.", null);
            this.myFile = file2;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            ChooseFileEncodingAction.this.chosen(this.myFile, NO_ENCODING);
        }
    }
}

