/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffContentFactoryImpl;
import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.DiffRequestFactoryImpl;
import com.intellij.diff.actions.impl.GoToChangePopupBuilder;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.history.ByteContent;
import com.intellij.history.Label;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeGoToChangePopupAction;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.util.Consumer;
import com.intellij.vcsUtil.VcsUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowUpdatedDiffAction
extends AnAction
implements DumbAware {
    public void update(AnActionEvent e) {
        DataContext dc = e.getDataContext();
        Presentation presentation = e.getPresentation();
        presentation.setEnabled(this.isVisible(dc) && this.isEnabled(dc));
    }

    private boolean isVisible(DataContext dc) {
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dc);
        return project2 != null && VcsDataKeys.LABEL_BEFORE.getData(dc) != null && VcsDataKeys.LABEL_AFTER.getData(dc) != null;
    }

    private boolean isEnabled(DataContext dc) {
        Iterable iterable = (Iterable)VcsDataKeys.UPDATE_VIEW_FILES_ITERABLE.getData(dc);
        return iterable != null;
    }

    public void actionPerformed(AnActionEvent e) {
        DataContext dc = e.getDataContext();
        if (!this.isVisible(dc) || !this.isEnabled(dc)) {
            return;
        }
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dc);
        Iterable iterable = (Iterable)e.getRequiredData(VcsDataKeys.UPDATE_VIEW_FILES_ITERABLE);
        Label before = (Label)e.getRequiredData(VcsDataKeys.LABEL_BEFORE);
        Label after2 = (Label)e.getRequiredData(VcsDataKeys.LABEL_AFTER);
        String selectedUrl = (String)VcsDataKeys.UPDATE_VIEW_SELECTED_PATH.getData(dc);
        MyDiffRequestChain requestChain = new MyDiffRequestChain(project2, iterable, before, after2, selectedUrl);
        DiffManager.getInstance().showDiff(project2, (DiffRequestChain)requestChain, DiffDialogHints.FRAME);
    }

    private static class MyDiffRequestChain
    extends UserDataHolderBase
    implements DiffRequestChain,
    GoToChangePopupBuilder.Chain {
        @Nullable
        private final Project myProject;
        @NotNull
        private final Label myBefore;
        @NotNull
        private final Label myAfter;
        @NotNull
        private final List<MyDiffRequestProducer> myRequests = new ArrayList<MyDiffRequestProducer>();
        private int myIndex;

        public MyDiffRequestChain(@Nullable Project project2, @NotNull Iterable<Pair<VirtualFilePointer, FileStatus>> iterable, @NotNull Label before, @NotNull Label after2, @Nullable String selectedUrl) {
            this.myProject = project2;
            this.myBefore = before;
            this.myAfter = after2;
            int selected = -1;
            for (Pair<VirtualFilePointer, FileStatus> pair : iterable) {
                if (selected == -1 && ((VirtualFilePointer)pair.first).getUrl().equals(selectedUrl)) {
                    selected = this.myRequests.size();
                }
                this.myRequests.add(new MyDiffRequestProducer((VirtualFilePointer)pair.first, (FileStatus)pair.second));
            }
            if (selected != -1) {
                this.myIndex = selected;
            }
        }

        @NotNull
        public List<MyDiffRequestProducer> getRequests() {
            return this.myRequests;
        }

        public int getIndex() {
            return this.myIndex;
        }

        public void setIndex(int index) {
            this.myIndex = index;
        }

        @Override
        @NotNull
        public AnAction createGoToChangeAction(@NotNull Consumer<Integer> onSelected) {
            return new ChangeGoToChangePopupAction.Fake<MyDiffRequestChain>(this, this.myIndex, onSelected){

                @Override
                @NotNull
                protected FilePath getFilePath(int index) {
                    return ((MyDiffRequestProducer)myRequests.get(index)).getFilePath();
                }

                @Override
                @NotNull
                protected FileStatus getFileStatus(int index) {
                    return ((MyDiffRequestProducer)myRequests.get(index)).getFileStatus();
                }
            };
        }

        @NotNull
        private static byte[] loadContent(@NotNull VirtualFilePointer filePointer, @NotNull Label label) throws DiffRequestProducerException {
            String path = filePointer.getPresentableUrl();
            ByteContent byteContent = label.getByteContent(FileUtil.toSystemIndependentName((String)path));
            if (byteContent == null || byteContent.isDirectory() || byteContent.getBytes() == null) {
                throw new DiffRequestProducerException("Can't load content");
            }
            return byteContent.getBytes();
        }

        private class MyDiffRequestProducer
        implements DiffRequestProducer {
            @NotNull
            private final VirtualFilePointer myFilePointer;
            @NotNull
            private final FileStatus myFileStatus;
            @NotNull
            private final FilePath myFilePath;

            public MyDiffRequestProducer(@NotNull VirtualFilePointer filePointer, FileStatus fileStatus) {
                this.myFilePointer = filePointer;
                this.myFileStatus = fileStatus;
                this.myFilePath = VcsUtil.getFilePath((String)this.myFilePointer.getPresentableUrl(), (boolean)false);
            }

            @NotNull
            public String getName() {
                return this.myFilePointer.getUrl();
            }

            @NotNull
            public FilePath getFilePath() {
                return this.myFilePath;
            }

            @NotNull
            public FileStatus getFileStatus() {
                return this.myFileStatus;
            }

            @NotNull
            public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
                try {
                    EmptyContent content2;
                    EmptyContent content1;
                    if (FileStatus.ADDED.equals(this.myFileStatus)) {
                        content1 = DiffContentFactory.getInstance().createEmpty();
                    } else {
                        byte[] bytes1 = MyDiffRequestChain.loadContent(this.myFilePointer, MyDiffRequestChain.this.myBefore);
                        content1 = DiffContentFactoryImpl.getInstanceImpl().createFromBytes(MyDiffRequestChain.this.myProject, this.myFilePath, bytes1);
                    }
                    if (FileStatus.DELETED.equals(this.myFileStatus)) {
                        content2 = DiffContentFactory.getInstance().createEmpty();
                    } else {
                        byte[] bytes2 = MyDiffRequestChain.loadContent(this.myFilePointer, MyDiffRequestChain.this.myAfter);
                        content2 = DiffContentFactoryImpl.getInstanceImpl().createFromBytes(MyDiffRequestChain.this.myProject, this.myFilePath, bytes2);
                    }
                    String title = DiffRequestFactoryImpl.getContentTitle(this.myFilePath);
                    return new SimpleDiffRequest(title, (DiffContent)content1, (DiffContent)content2, "Before update", "After update");
                }
                catch (IOException e) {
                    throw new DiffRequestProducerException("Can't load content", (Throwable)e);
                }
            }
        }
    }
}

