/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ui;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsBalloonProblemNotifier
implements Runnable {
    public static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.toolWindowGroup((String)"Common Version Control Messages", (String)ChangesViewContentManager.TOOLWINDOW_ID);
    private final Project myProject;
    private final String myMessage;
    private final MessageType myMessageType;
    @Nullable
    private final NamedRunnable[] myNotificationListener;

    public VcsBalloonProblemNotifier(@NotNull Project project2, @NotNull String message, MessageType messageType) {
        this(project2, message, messageType, null);
    }

    public VcsBalloonProblemNotifier(@NotNull Project project2, @NotNull String message, MessageType messageType, @Nullable NamedRunnable[] notificationListener) {
        this.myProject = project2;
        this.myMessage = message;
        this.myMessageType = messageType;
        this.myNotificationListener = notificationListener;
    }

    public static void showOverChangesView(@NotNull Project project2, @NotNull String message, MessageType type, NamedRunnable ... notificationListener) {
        VcsBalloonProblemNotifier.show(project2, message, type, notificationListener);
    }

    public static void showOverVersionControlView(@NotNull Project project2, @NotNull String message, MessageType type) {
        VcsBalloonProblemNotifier.show(project2, message, type, null);
    }

    private static void show(final Project project2, final String message, final MessageType type, final @Nullable NamedRunnable[] notificationListener) {
        Application application = ApplicationManager.getApplication();
        if (application.isHeadlessEnvironment()) {
            return;
        }
        Runnable showErrorAction = new Runnable(){

            @Override
            public void run() {
                new VcsBalloonProblemNotifier(project2, message, type, notificationListener).run();
            }
        };
        if (application.isDispatchThread()) {
            showErrorAction.run();
        } else {
            application.invokeLater(showErrorAction);
        }
    }

    @Override
    public void run() {
        Notification notification;
        if (this.myNotificationListener != null && this.myNotificationListener.length > 0) {
            NotificationType type = this.myMessageType.toNotificationType();
            StringBuilder sb = new StringBuilder(this.myMessage);
            for (NamedRunnable runnable2 : this.myNotificationListener) {
                String name = runnable2.toString();
                sb.append("<br/><a href=\"").append(name).append("\">").append(name).append("</a>");
            }
            notification = NOTIFICATION_GROUP.createNotification(type.name(), sb.toString(), this.myMessageType.toNotificationType(), new NotificationListener(){

                public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                    if (HyperlinkEvent.EventType.ACTIVATED.equals(event.getEventType())) {
                        if (VcsBalloonProblemNotifier.this.myNotificationListener.length == 1) {
                            VcsBalloonProblemNotifier.this.myNotificationListener[0].run();
                        } else {
                            String description = event.getDescription();
                            if (description != null) {
                                for (NamedRunnable runnable2 : VcsBalloonProblemNotifier.this.myNotificationListener) {
                                    if (!description.equals(runnable2.toString())) continue;
                                    runnable2.run();
                                    break;
                                }
                            }
                        }
                        notification.expire();
                    }
                }
            });
        } else {
            notification = NOTIFICATION_GROUP.createNotification(this.myMessage, this.myMessageType);
        }
        notification.notify(this.myProject.isDefault() ? null : this.myProject);
    }
}

