/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.readOnlyHandler;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeEventQueue;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.vcs.readOnlyHandler.FileInfo;
import com.intellij.openapi.vcs.readOnlyHandler.HandleType;
import com.intellij.openapi.vcs.readOnlyHandler.ReadOnlyStatusDialog;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.WritingAccessProvider;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="ReadonlyStatusHandler", storages={@Storage(value="$WORKSPACE_FILE$")})
public class ReadonlyStatusHandlerImpl
extends ReadonlyStatusHandler
implements PersistentStateComponent<State> {
    private final Project myProject;
    private final WritingAccessProvider[] myAccessProviders;
    private State myState = new State();

    public ReadonlyStatusHandlerImpl(Project project2) {
        this.myProject = project2;
        this.myAccessProviders = WritingAccessProvider.getProvidersForProject((Project)this.myProject);
    }

    public State getState() {
        return this.myState;
    }

    public void loadState(State state) {
        this.myState = state;
    }

    /*
     * WARNING - void declaration
     */
    public ReadonlyStatusHandler.OperationStatus ensureFilesWritable(VirtualFile ... files) {
        if (files.length == 0) {
            return new OperationStatusImpl(VirtualFile.EMPTY_ARRAY);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        THashSet realFiles = new THashSet(files.length);
        for (VirtualFile virtualFile : files) {
            void var6_6;
            if (virtualFile instanceof VirtualFileWindow) {
                VirtualFile virtualFile2 = ((VirtualFileWindow)virtualFile).getDelegate();
            }
            if (var6_6 == null) continue;
            realFiles.add(var6_6);
        }
        files = VfsUtilCore.toVirtualFileArray((Collection)realFiles);
        for (VirtualFile virtualFile : this.myAccessProviders) {
            Collection denied = ContainerUtil.filter((Object[])files, (Condition)new Condition<VirtualFile>((WritingAccessProvider)virtualFile){
                final /* synthetic */ WritingAccessProvider val$accessProvider;
                {
                    this.val$accessProvider = writingAccessProvider;
                }

                public boolean value(VirtualFile virtualFile) {
                    return !this.val$accessProvider.isPotentiallyWritable(virtualFile);
                }
            });
            if (denied.isEmpty()) {
                denied = virtualFile.requestWriting(files);
            }
            if (denied.isEmpty()) continue;
            return new OperationStatusImpl(VfsUtilCore.toVirtualFileArray((Collection)denied));
        }
        FileInfo[] fileInfos = this.createFileInfos(files);
        if (fileInfos.length == 0) {
            return ReadonlyStatusHandlerImpl.createResultStatus(files);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return ReadonlyStatusHandlerImpl.createResultStatus(files);
        }
        int savedEventCount = IdeEventQueue.getInstance().getEventCount();
        if (this.myState.SHOW_DIALOG) {
            new ReadOnlyStatusDialog(this.myProject, fileInfos).show();
        } else {
            ReadonlyStatusHandlerImpl.processFiles(new ArrayList<FileInfo>(Arrays.asList(fileInfos)), null);
        }
        IdeEventQueue.getInstance().setEventCount(savedEventCount);
        return ReadonlyStatusHandlerImpl.createResultStatus(files);
    }

    private static ReadonlyStatusHandler.OperationStatus createResultStatus(VirtualFile[] files) {
        ArrayList<VirtualFile> readOnlyFiles = new ArrayList<VirtualFile>();
        for (VirtualFile file2 : files) {
            if (!file2.exists() || file2.isWritable()) continue;
            readOnlyFiles.add(file2);
        }
        return new OperationStatusImpl(VfsUtilCore.toVirtualFileArray(readOnlyFiles));
    }

    private FileInfo[] createFileInfos(VirtualFile[] files) {
        ArrayList<FileInfo> fileInfos = new ArrayList<FileInfo>();
        for (VirtualFile file2 : files) {
            if (file2 == null || file2.isWritable() || !file2.isInLocalFileSystem()) continue;
            fileInfos.add(new FileInfo(file2, this.myProject));
        }
        return fileInfos.toArray(new FileInfo[fileInfos.size()]);
    }

    public static void processFiles(List<FileInfo> fileInfos, @Nullable String changelist) {
        FileInfo[] copy = fileInfos.toArray(new FileInfo[fileInfos.size()]);
        MultiValuesMap handleTypeToFile = new MultiValuesMap();
        for (FileInfo fileInfo : copy) {
            handleTypeToFile.put((Object)fileInfo.getSelectedHandleType(), (Object)fileInfo.getFile());
        }
        for (HandleType handleType : handleTypeToFile.keySet()) {
            handleType.processFiles(handleTypeToFile.get((Object)handleType), changelist);
        }
        for (FileInfo fileInfo : copy) {
            if (fileInfo.getFile().exists() && !fileInfo.getFile().isWritable()) continue;
            fileInfos.remove(fileInfo);
        }
    }

    private static class OperationStatusImpl
    extends ReadonlyStatusHandler.OperationStatus {
        private final VirtualFile[] myReadonlyFiles;

        OperationStatusImpl(VirtualFile[] readonlyFiles) {
            this.myReadonlyFiles = readonlyFiles;
        }

        @NotNull
        public VirtualFile[] getReadonlyFiles() {
            return this.myReadonlyFiles;
        }

        public boolean hasReadonlyFiles() {
            return this.myReadonlyFiles.length > 0;
        }

        @NotNull
        public String getReadonlyFilesMessage() {
            if (this.hasReadonlyFiles()) {
                StringBuilder buf = new StringBuilder();
                if (this.myReadonlyFiles.length > 1) {
                    for (VirtualFile file2 : this.myReadonlyFiles) {
                        buf.append('\n');
                        buf.append(file2.getPresentableUrl());
                    }
                    return CommonBundle.message((String)"failed.to.make.the.following.files.writable.error.message", (Object[])new Object[]{buf.toString()});
                }
                return CommonBundle.message((String)"failed.to.make.file.writeable.error.message", (Object[])new Object[]{this.myReadonlyFiles[0].getPresentableUrl()});
            }
            throw new RuntimeException("No readonly files");
        }
    }

    public static class State {
        public boolean SHOW_DIALOG = true;
    }
}

