/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl.projectlevelman;

import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.VcsShowConfirmationOptionImpl;
import com.intellij.openapi.vcs.VcsShowOptionsSettingImpl;
import com.intellij.openapi.vcs.VcsShowSettingOption;
import com.intellij.util.containers.Convertor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class OptionsAndConfirmations {
    private final Map<String, VcsShowOptionsSettingImpl> myOptions = new LinkedHashMap<String, VcsShowOptionsSettingImpl>();
    private final Map<String, VcsShowConfirmationOptionImpl> myConfirmations = new LinkedHashMap<String, VcsShowConfirmationOptionImpl>();

    public void init(Convertor<String, VcsShowConfirmationOption.Value> initOptions) {
        this.createSettingFor(VcsConfiguration.StandardOption.ADD);
        this.createSettingFor(VcsConfiguration.StandardOption.REMOVE);
        this.createSettingFor(VcsConfiguration.StandardOption.CHECKOUT);
        this.createSettingFor(VcsConfiguration.StandardOption.UPDATE);
        this.createSettingFor(VcsConfiguration.StandardOption.STATUS);
        this.createSettingFor(VcsConfiguration.StandardOption.EDIT);
        this.myConfirmations.put(VcsConfiguration.StandardConfirmation.ADD.getId(), new VcsShowConfirmationOptionImpl(VcsConfiguration.StandardConfirmation.ADD.getId(), VcsBundle.message((String)"label.text.when.files.created.with.idea", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName()}), VcsBundle.message((String)"radio.after.creation.do.not.add", (Object[])new Object[0]), VcsBundle.message((String)"radio.after.creation.show.options", (Object[])new Object[0]), VcsBundle.message((String)"radio.after.creation.add.silently", (Object[])new Object[0])));
        this.myConfirmations.put(VcsConfiguration.StandardConfirmation.REMOVE.getId(), new VcsShowConfirmationOptionImpl(VcsConfiguration.StandardConfirmation.REMOVE.getId(), VcsBundle.message((String)"label.text.when.files.are.deleted.with.idea", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName()}), VcsBundle.message((String)"radio.after.deletion.do.not.remove", (Object[])new Object[0]), VcsBundle.message((String)"radio.after.deletion.show.options", (Object[])new Object[0]), VcsBundle.message((String)"radio.after.deletion.remove.silently", (Object[])new Object[0])));
        this.restoreReadConfirm(VcsConfiguration.StandardConfirmation.ADD, initOptions);
        this.restoreReadConfirm(VcsConfiguration.StandardConfirmation.REMOVE, initOptions);
    }

    private void restoreReadConfirm(VcsConfiguration.StandardConfirmation confirm, Convertor<String, VcsShowConfirmationOption.Value> initOptions) {
        VcsShowConfirmationOption.Value initValue = (VcsShowConfirmationOption.Value)initOptions.convert((Object)confirm.getId());
        if (initValue != null) {
            this.getConfirmation(confirm).setValue(initValue);
        }
    }

    @NotNull
    public VcsShowConfirmationOptionImpl getConfirmation(VcsConfiguration.StandardConfirmation option) {
        return this.myConfirmations.get(option.getId());
    }

    private void createSettingFor(VcsConfiguration.StandardOption option) {
        if (!this.myOptions.containsKey(option.getId())) {
            this.myOptions.put(option.getId(), new VcsShowOptionsSettingImpl(option));
        }
    }

    @NotNull
    public VcsShowSettingOption getOptions(VcsConfiguration.StandardOption option) {
        return this.myOptions.get(option.getId());
    }

    public List<VcsShowOptionsSettingImpl> getAllOptions() {
        return new ArrayList<VcsShowOptionsSettingImpl>(this.myOptions.values());
    }

    public List<VcsShowConfirmationOptionImpl> getAllConfirmations() {
        return new ArrayList<VcsShowConfirmationOptionImpl>(this.myConfirmations.values());
    }

    @NotNull
    public VcsShowSettingOption getOrCreateCustomOption(@NotNull String vcsActionName, @NotNull AbstractVcs vcs) {
        VcsShowOptionsSettingImpl option = this.getOrCreateOption(vcsActionName);
        option.addApplicableVcs(vcs);
        return option;
    }

    private VcsShowOptionsSettingImpl getOrCreateOption(String actionName) {
        if (!this.myOptions.containsKey(actionName)) {
            this.myOptions.put(actionName, new VcsShowOptionsSettingImpl(actionName));
        }
        return this.myOptions.get(actionName);
    }

    Map<String, VcsShowOptionsSettingImpl> getOptions() {
        return this.myOptions;
    }

    Map<String, VcsShowConfirmationOptionImpl> getConfirmations() {
        return this.myConfirmations;
    }
}

