/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.VirtualFileFilter;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.Processor;
import com.intellij.util.StringLenComparator;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsRootIterator {
    private final Map<String, MyRootFilter> myOtherVcsFolders;
    private final FileIndexFacade myExcludedFileIndex;
    private final ProjectLevelVcsManager myVcsManager;
    private final Project myProject;

    public VcsRootIterator(Project project2, AbstractVcs vcs) {
        VirtualFile[] roots;
        this.myProject = project2;
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project2);
        this.myOtherVcsFolders = new HashMap<String, MyRootFilter>();
        this.myExcludedFileIndex = (FileIndexFacade)PeriodicalTasksCloser.getInstance().safeGetService(project2, FileIndexFacade.class);
        VcsRoot[] allRoots = this.myVcsManager.getAllVcsRoots();
        for (VirtualFile root : roots = this.myVcsManager.getRootsUnderVcs(vcs)) {
            MyRootFilter rootPresentFilter = new MyRootFilter(root, vcs.getName());
            rootPresentFilter.init(allRoots);
            this.myOtherVcsFolders.put(root.getUrl(), rootPresentFilter);
        }
    }

    public boolean acceptFolderUnderVcs(VirtualFile vcsRoot, VirtualFile file2) {
        String vcsUrl = vcsRoot.getUrl();
        MyRootFilter rootFilter = this.myOtherVcsFolders.get(vcsUrl);
        if (rootFilter != null && !rootFilter.accept(file2)) {
            return false;
        }
        return !VcsRootIterator.isIgnoredByVcs(this.myVcsManager, this.myProject, file2);
    }

    private static boolean isIgnoredByVcs(final ProjectLevelVcsManager vcsManager, final Project project2, final VirtualFile file2) {
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                return project2.isDisposed() || vcsManager.isIgnored(file2);
            }
        });
    }

    public static void iterateVfUnderVcsRoot(Project project2, VirtualFile root, Processor<VirtualFile> processor2) {
        MyRootIterator rootIterator = new MyRootIterator(project2, root, null, processor2, null);
        rootIterator.iterate();
    }

    public static void iterateVcsRoot(Project project2, VirtualFile root, Processor<FilePath> processor2) {
        VcsRootIterator.iterateVcsRoot(project2, root, processor2, null);
    }

    public static void iterateVcsRoot(Project project2, VirtualFile root, Processor<FilePath> processor2, @Nullable VirtualFileFilter directoryFilter) {
        MyRootIterator rootIterator = new MyRootIterator(project2, root, processor2, null, directoryFilter);
        rootIterator.iterate();
    }

    private static class MyRootIterator {
        private final Project myProject;
        private final Processor<FilePath> myPathProcessor;
        private final Processor<VirtualFile> myFileProcessor;
        @Nullable
        private final VirtualFileFilter myDirectoryFilter;
        private final VirtualFile myRoot;
        private final MyRootFilter myRootPresentFilter;
        private final ProjectLevelVcsManager myVcsManager;

        private MyRootIterator(Project project2, VirtualFile root, @Nullable Processor<FilePath> pathProcessor, @Nullable Processor<VirtualFile> fileProcessor, @Nullable VirtualFileFilter directoryFilter) {
            this.myProject = project2;
            this.myPathProcessor = pathProcessor;
            this.myFileProcessor = fileProcessor;
            this.myDirectoryFilter = directoryFilter;
            this.myRoot = root;
            this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project2);
            AbstractVcs vcs = this.myVcsManager.getVcsFor(root);
            MyRootFilter myRootFilter = this.myRootPresentFilter = vcs == null ? null : new MyRootFilter(root, vcs.getName());
            if (this.myRootPresentFilter != null) {
                this.myRootPresentFilter.init(this.myVcsManager.getAllVcsRoots());
            }
        }

        public void iterate() {
            VfsUtilCore.visitChildrenRecursively((VirtualFile)this.myRoot, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[]{VirtualFileVisitor.NO_FOLLOW_SYMLINKS}){

                public void afterChildrenVisited(@NotNull VirtualFile file2) {
                    if (myDirectoryFilter != null) {
                        myDirectoryFilter.afterChildrenVisited(file2);
                    }
                }

                @NotNull
                public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file2) {
                    if (VcsRootIterator.isIgnoredByVcs(myVcsManager, myProject, file2)) {
                        return SKIP_CHILDREN;
                    }
                    if (myRootPresentFilter != null && !myRootPresentFilter.accept(file2)) {
                        return SKIP_CHILDREN;
                    }
                    if (myProject.isDisposed() || !this.process(file2)) {
                        return 1.skipTo((VirtualFile)myRoot);
                    }
                    if (myDirectoryFilter != null && file2.isDirectory() && !myDirectoryFilter.shouldGoIntoDirectory(file2)) {
                        return SKIP_CHILDREN;
                    }
                    return CONTINUE;
                }
            });
        }

        private boolean process(VirtualFile current) {
            if (this.myPathProcessor != null) {
                return this.myPathProcessor.process((Object)VcsUtil.getFilePath((VirtualFile)current));
            }
            if (this.myFileProcessor != null) {
                return this.myFileProcessor.process((Object)current);
            }
            return false;
        }
    }

    private static class MyRootFilter {
        private final VirtualFile myRoot;
        private final String myVcsName;
        private final List<String> myExcludedByOthers;

        private MyRootFilter(VirtualFile root, String vcsName) {
            this.myRoot = root;
            this.myVcsName = vcsName;
            this.myExcludedByOthers = new LinkedList<String>();
        }

        private void init(VcsRoot[] allRoots) {
            String ourPath = this.myRoot.getUrl();
            for (VcsRoot root : allRoots) {
                String url;
                VirtualFile path;
                AbstractVcs vcs = root.getVcs();
                if (vcs == null || Comparing.equal((String)vcs.getName(), (String)this.myVcsName) || (path = root.getPath()) == null || !(url = path.getUrl()).startsWith(ourPath)) continue;
                this.myExcludedByOthers.add(url);
            }
            Collections.sort(this.myExcludedByOthers, StringLenComparator.getDescendingInstance());
        }

        public boolean accept(VirtualFile vf) {
            String url = vf.getUrl();
            for (String excludedByOtherVcs : this.myExcludedByOthers) {
                if (url.length() > excludedByOtherVcs.length()) {
                    return true;
                }
                if (!url.startsWith(excludedByOtherVcs)) continue;
                return false;
            }
            return true;
        }
    }
}

