/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import org.jetbrains.annotations.NotNull;

public class BackgroundableActionLock {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Object[] myKeys;

    BackgroundableActionLock(@NotNull Project project2, @NotNull Object[] keys) {
        this.myProject = project2;
        this.myKeys = keys;
    }

    public boolean isLocked() {
        return BackgroundableActionLock.isLocked(this.myProject, this.myKeys);
    }

    public void lock() {
        BackgroundableActionLock.lock(this.myProject, this.myKeys);
    }

    public void unlock() {
        BackgroundableActionLock.unlock(this.myProject, this.myKeys);
    }

    @NotNull
    public static BackgroundableActionLock getLock(@NotNull Project project2, Object ... keys) {
        return new BackgroundableActionLock(project2, keys);
    }

    public static boolean isLocked(@NotNull Project project2, Object ... keys) {
        return BackgroundableActionLock.getManager(project2).isBackgroundTaskRunning(keys);
    }

    public static void lock(@NotNull Project project2, Object ... keys) {
        BackgroundableActionLock.getManager(project2).startBackgroundTask(keys);
    }

    public static void unlock(@NotNull Project project2, Object ... keys) {
        BackgroundableActionLock.getManager(project2).stopBackgroundTask(keys);
    }

    @NotNull
    private static ProjectLevelVcsManagerImpl getManager(@NotNull Project project2) {
        return (ProjectLevelVcsManagerImpl)ProjectLevelVcsManager.getInstance((Project)project2);
    }
}

