/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffManager;
import com.intellij.diff.actions.DocumentFragmentContent;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.ex.BaseLineStatusRangeAction;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowLineStatusRangeDiffAction
extends BaseLineStatusRangeAction {
    public ShowLineStatusRangeDiffAction(@NotNull LineStatusTracker lineStatusTracker, @NotNull Range range, @Nullable Editor editor) {
        super(VcsBundle.message((String)"action.name.show.difference", (Object[])new Object[0]), AllIcons.Actions.Diff, lineStatusTracker, range);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    public void actionPerformed(AnActionEvent e) {
        DiffManager.getInstance().showDiff(e.getProject(), this.createDiffData());
    }

    private DiffRequest createDiffData() {
        Range range = ShowLineStatusRangeDiffAction.expand(this.myRange, this.myLineStatusTracker.getDocument(), this.myLineStatusTracker.getVcsDocument());
        DiffContent vcsContent = this.createDiffContent(this.myLineStatusTracker.getVcsDocument(), this.myLineStatusTracker.getVcsTextRange(range), null);
        DiffContent currentContent = this.createDiffContent(this.myLineStatusTracker.getDocument(), this.myLineStatusTracker.getCurrentTextRange(range), this.myLineStatusTracker.getVirtualFile());
        return new SimpleDiffRequest(VcsBundle.message((String)"dialog.title.diff.for.range", (Object[])new Object[0]), vcsContent, currentContent, VcsBundle.message((String)"diff.content.title.up.to.date", (Object[])new Object[0]), VcsBundle.message((String)"diff.content.title.current.range", (Object[])new Object[0]));
    }

    @NotNull
    private DiffContent createDiffContent(@NotNull Document document, @NotNull TextRange textRange, @Nullable VirtualFile file2) {
        Project project2 = this.myLineStatusTracker.getProject();
        DocumentContent content = DiffContentFactory.getInstance().create(project2, document, file2);
        return new DocumentFragmentContent(project2, content, textRange);
    }

    @NotNull
    private static Range expand(@NotNull Range range, @NotNull Document document, @NotNull Document uDocument) {
        boolean canExpandBefore = range.getLine1() != 0 && range.getVcsLine1() != 0;
        boolean canExpandAfter = range.getLine2() < document.getLineCount() && range.getVcsLine2() < uDocument.getLineCount();
        int offset1 = range.getLine1() - (canExpandBefore ? 1 : 0);
        int uOffset1 = range.getVcsLine1() - (canExpandBefore ? 1 : 0);
        int offset2 = range.getLine2() + (canExpandAfter ? 1 : 0);
        int uOffset2 = range.getVcsLine2() + (canExpandAfter ? 1 : 0);
        return new Range(offset1, offset2, uOffset1, uOffset2);
    }
}

