/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.contentAnnotation;

import com.intellij.execution.filters.ExceptionInfoCache;
import com.intellij.execution.filters.ExceptionWorker;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.FilterMixin;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffColors;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.localVcs.UpToDateLineNumberProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.contentAnnotation.VcsContentAnnotation;
import com.intellij.openapi.vcs.contentAnnotation.VcsContentAnnotationImpl;
import com.intellij.openapi.vcs.contentAnnotation.VcsContentAnnotationSettings;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.UpToDateLineNumberProviderImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsContentAnnotationExceptionFilter
implements Filter,
FilterMixin {
    private final Project myProject;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.contentAnnotation.VcsContentAnnotationExceptionFilter");
    private final VcsContentAnnotationSettings mySettings;
    private final Map<VirtualFile, VcsRevisionNumber> myRevNumbersCache;
    private final ExceptionInfoCache myCache;

    public VcsContentAnnotationExceptionFilter(@NotNull GlobalSearchScope scope) {
        this.myProject = scope.getProject();
        this.mySettings = VcsContentAnnotationSettings.getInstance((Project)this.myProject);
        this.myRevNumbersCache = new HashMap<VirtualFile, VcsRevisionNumber>();
        this.myCache = new ExceptionInfoCache(scope);
    }

    public boolean shouldRunHeavy() {
        return this.mySettings.isShow();
    }

    public void applyHeavyFilter(final @NotNull Document copiedFragment, int startOffset, int startLineNumber, @NotNull Consumer<FilterMixin.AdditionalHighlight> consumer) {
        VcsContentAnnotation vcsContentAnnotation = VcsContentAnnotationImpl.getInstance((Project)this.myProject);
        LocalChangesCorrector localChangesCorrector = new LocalChangesCorrector(this.myProject);
        Trinity previousLineResult = null;
        for (int i = 0; i < copiedFragment.getLineCount(); ++i) {
            final int lineStartOffset = copiedFragment.getLineStartOffset(i);
            final int lineEndOffset = copiedFragment.getLineEndOffset(i);
            final ExceptionWorker worker = new ExceptionWorker(this.myCache);
            final String[] lineText = new String[1];
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    lineText[0] = copiedFragment.getText(new TextRange(lineStartOffset, lineEndOffset));
                    worker.execute(lineText[0], lineEndOffset);
                }
            });
            if (worker.getResult() != null) {
                VirtualFile vf = worker.getFile().getVirtualFile();
                if (vf.getFileSystem().isReadOnly()) continue;
                VcsRevisionNumber recentChangeRevision = this.myRevNumbersCache.get(vf);
                if (recentChangeRevision == null) {
                    recentChangeRevision = vcsContentAnnotation.fileRecentlyChanged(vf);
                    if (recentChangeRevision == null) {
                        this.myRevNumbersCache.put(vf, VcsRevisionNumber.NULL);
                    } else {
                        this.myRevNumbersCache.put(vf, recentChangeRevision);
                    }
                }
                if (VcsRevisionNumber.NULL.equals(recentChangeRevision)) {
                    recentChangeRevision = null;
                }
                if (localChangesCorrector.isFileAlreadyIdentifiedAsChanged(vf) || ChangeListManager.isFileChanged((Project)this.myProject, (VirtualFile)vf) || recentChangeRevision != null) {
                    List<TextRange> ranges;
                    Document document = VcsContentAnnotationExceptionFilter.getDocumentForFile(worker);
                    if (document == null) {
                        return;
                    }
                    int startFileOffset = ((TextRange)worker.getInfo().getThird()).getStartOffset();
                    int idx = lineText[0].indexOf(58, startFileOffset);
                    int endIdx = idx == -1 ? ((TextRange)worker.getInfo().getThird()).getEndOffset() : idx;
                    consumer.consume((Object)new MyAdditionalHighlight(startOffset + lineStartOffset + startFileOffset + 1, startOffset + lineStartOffset + endIdx));
                    if (worker.getPsiClass() != null && (ranges = VcsContentAnnotationExceptionFilter.findMethodRange(worker, document, (Trinity<PsiClass, PsiFile, String>)previousLineResult)) != null) {
                        boolean methodChanged = false;
                        for (TextRange range : ranges) {
                            if (localChangesCorrector.isRangeChangedLocally(vf, document, range)) {
                                methodChanged = true;
                                break;
                            }
                            TextRange correctedRange = localChangesCorrector.getCorrectedRange(vf, document, range);
                            if (!vcsContentAnnotation.intervalRecentlyChanged(vf, correctedRange, recentChangeRevision)) continue;
                            methodChanged = true;
                            break;
                        }
                        if (methodChanged) {
                            consumer.consume((Object)new MyAdditionalHighlight(startOffset + lineStartOffset + ((TextRange)worker.getInfo().getSecond()).getStartOffset(), startOffset + lineStartOffset + ((TextRange)worker.getInfo().getSecond()).getEndOffset()));
                        }
                    }
                }
            }
            previousLineResult = worker.getResult() == null ? null : new Trinity((Object)worker.getPsiClass(), (Object)worker.getFile(), (Object)worker.getMethod());
        }
    }

    @NotNull
    public String getUpdateMessage() {
        return "Checking recent changes...";
    }

    private static Document getDocumentForFile(final ExceptionWorker worker) {
        return (Document)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Document>(){

            public Document compute() {
                Document document = FileDocumentManager.getInstance().getDocument(worker.getFile().getVirtualFile());
                if (document == null) {
                    LOG.info("can not get document for file: " + worker.getFile().getVirtualFile());
                    return null;
                }
                return document;
            }
        });
    }

    private static List<TextRange> findMethodRange(final ExceptionWorker worker, final Document document, final Trinity<PsiClass, PsiFile, String> previousLineResult) {
        return (List)ApplicationManager.getApplication().runReadAction((Computable)new Computable<List<TextRange>>(){

            public List<TextRange> compute() {
                List ranges = VcsContentAnnotationExceptionFilter.getTextRangeForMethod(worker, (Trinity<PsiClass, PsiFile, String>)previousLineResult);
                if (ranges == null) {
                    return null;
                }
                ArrayList<TextRange> result = new ArrayList<TextRange>();
                for (TextRange range : ranges) {
                    result.add(new TextRange(document.getLineNumber(range.getStartOffset()), document.getLineNumber(range.getEndOffset())));
                }
                return result;
            }
        });
    }

    @Nullable
    private static List<PsiMethod> selectMethod(PsiMethod[] methods, final Trinity<PsiClass, PsiFile, String> previousLineResult) {
        if (previousLineResult == null || previousLineResult.getThird() == null) {
            return null;
        }
        SmartList result = new SmartList();
        for (PsiMethod method : methods) {
            method.accept((PsiElementVisitor)new JavaRecursiveElementVisitor((List)result, method){
                final /* synthetic */ List val$result;
                final /* synthetic */ PsiMethod val$method;
                {
                    this.val$result = list;
                    this.val$method = psiMethod;
                }

                public void visitCallExpression(PsiCallExpression callExpression) {
                    PsiMethod resolved = callExpression.resolveMethod();
                    if (resolved != null && resolved.getName().equals(previousLineResult.getThird())) {
                        this.val$result.add(this.val$method);
                    }
                }
            });
        }
        return result;
    }

    private static List<TextRange> getTextRangeForMethod(ExceptionWorker worker, Trinity<PsiClass, PsiFile, String> previousLineResult) {
        PsiMethod[] methods;
        String method = worker.getMethod();
        PsiClass psiClass = worker.getPsiClass();
        if (method.contains("<init>")) {
            methods = psiClass.getConstructors();
        } else {
            if (method.contains("$")) {
                return null;
            }
            methods = psiClass.findMethodsByName(method, false);
        }
        if (methods.length > 0) {
            if (methods.length == 1) {
                TextRange range = methods[0].getTextRange();
                return Collections.singletonList(range);
            }
            List<PsiMethod> selectedMethods = VcsContentAnnotationExceptionFilter.selectMethod(methods, previousLineResult);
            List<PsiMethod> toIterate = selectedMethods == null ? Arrays.asList(methods) : selectedMethods;
            ArrayList<TextRange> result = new ArrayList<TextRange>();
            for (PsiMethod psiMethod : toIterate) {
                result.add(psiMethod.getTextRange());
            }
            return result;
        }
        return null;
    }

    public Filter.Result applyFilter(String line, int entireLength) {
        return null;
    }

    private static class LocalChangesCorrector {
        private final Map<VirtualFile, UpToDateLineNumberProvider> myRecentlyChanged;
        private final Project myProject;

        private LocalChangesCorrector(Project project2) {
            this.myProject = project2;
            this.myRecentlyChanged = new HashMap<VirtualFile, UpToDateLineNumberProvider>();
        }

        public boolean isFileAlreadyIdentifiedAsChanged(VirtualFile vf) {
            return this.myRecentlyChanged.containsKey(vf);
        }

        public boolean isRangeChangedLocally(VirtualFile vf, Document document, final TextRange range) {
            final UpToDateLineNumberProvider provider = this.getProvider(vf, document);
            return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                public Boolean compute() {
                    return provider.isRangeChanged(range.getStartOffset(), range.getEndOffset());
                }
            });
        }

        public TextRange getCorrectedRange(VirtualFile vf, Document document, final TextRange range) {
            final UpToDateLineNumberProvider provider = this.getProvider(vf, document);
            if (provider == null) {
                return range;
            }
            return (TextRange)ApplicationManager.getApplication().runReadAction((Computable)new Computable<TextRange>(){

                public TextRange compute() {
                    return new TextRange(provider.getLineNumber(range.getStartOffset()), provider.getLineNumber(range.getEndOffset()));
                }
            });
        }

        private UpToDateLineNumberProvider getProvider(VirtualFile vf, Document document) {
            UpToDateLineNumberProvider provider = this.myRecentlyChanged.get(vf);
            if (provider == null) {
                provider = new UpToDateLineNumberProviderImpl(document, this.myProject);
                this.myRecentlyChanged.put(vf, provider);
            }
            return provider;
        }
    }

    private static class MyAdditionalHighlight
    extends FilterMixin.AdditionalHighlight {
        private MyAdditionalHighlight(int start, int end) {
            super(start, end);
        }

        @NotNull
        public TextAttributes getTextAttributes(@Nullable TextAttributes source) {
            EditorColorsScheme globalScheme = EditorColorsManager.getInstance().getGlobalScheme();
            TextAttributes changedColor = globalScheme.getAttributes(DiffColors.DIFF_MODIFIED);
            if (source == null) {
                TextAttributes attrs = globalScheme.getAttributes(DefaultLanguageHighlighterColors.CLASS_NAME).clone();
                attrs.setBackgroundColor(changedColor.getBackgroundColor());
                return attrs;
            }
            TextAttributes clone = source.clone();
            clone.setBackgroundColor(changedColor.getBackgroundColor());
            return clone;
        }
    }
}

