/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkin;

import com.intellij.ide.todo.TodoFilter;
import com.intellij.ide.todo.TodoIndexPatternProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.ex.DiffFragment;
import com.intellij.openapi.diff.impl.ComparisonPolicy;
import com.intellij.openapi.diff.impl.fragments.LineFragment;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.processing.DiffCorrection;
import com.intellij.openapi.diff.impl.processing.DiffFragmentsProcessor;
import com.intellij.openapi.diff.impl.processing.DiffPolicy;
import com.intellij.openapi.diff.impl.string.DiffString;
import com.intellij.openapi.diff.impl.util.TextDiffTypeEnum;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.checkin.StepIntersection;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.search.LightIndexPatternSearch;
import com.intellij.psi.impl.search.TodoItemsCreator;
import com.intellij.psi.search.IndexPatternOccurrence;
import com.intellij.psi.search.IndexPatternProvider;
import com.intellij.psi.search.PsiTodoSearchHelper;
import com.intellij.psi.search.TodoItem;
import com.intellij.psi.search.searches.IndexPatternSearch;
import com.intellij.util.PairConsumer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.Convertor;
import com.intellij.util.diff.FilesTooBigForDiffException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TodoCheckinHandlerWorker {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.checkin.TodoCheckinHandler");
    private final Collection<Change> changes;
    private final TodoFilter myTodoFilter;
    private final boolean myIncludePattern;
    private final PsiManager myPsiManager;
    private final PsiTodoSearchHelper mySearchHelper;
    private final List<TodoItem> myAddedOrEditedTodos;
    private final List<TodoItem> myInChangedTodos;
    private final List<Pair<FilePath, String>> mySkipped;
    private PsiFile myPsiFile;
    private List<TodoItem> myNewTodoItems;
    private final MyEditedFileProcessor myEditedFileProcessor;
    private static final String ourInvalidFile = "Invalid file (s)";
    private static final String ourCannotLoadPreviousRevision = "Can not load previous revision";
    private static final String ourCannotLoadCurrentRevision = "Can not load current revision";

    public TodoCheckinHandlerWorker(Project project2, Collection<Change> changes, TodoFilter todoFilter, boolean includePattern) {
        this.changes = changes;
        this.myTodoFilter = todoFilter;
        this.myIncludePattern = includePattern;
        this.myPsiManager = PsiManager.getInstance((Project)project2);
        this.mySearchHelper = PsiTodoSearchHelper.SERVICE.getInstance((Project)project2);
        this.myAddedOrEditedTodos = new ArrayList<TodoItem>();
        this.myInChangedTodos = new ArrayList<TodoItem>();
        this.mySkipped = new SmartList();
        this.myEditedFileProcessor = new MyEditedFileProcessor(project2, new Acceptor(){

            @Override
            public void skipped(Pair<FilePath, String> pair) {
                TodoCheckinHandlerWorker.this.mySkipped.add(pair);
            }

            @Override
            public void addedOrEdited(TodoItem todoItem) {
                TodoCheckinHandlerWorker.this.myAddedOrEditedTodos.add(todoItem);
            }

            @Override
            public void inChanged(TodoItem todoItem) {
                TodoCheckinHandlerWorker.this.myInChangedTodos.add(todoItem);
            }
        }, this.myTodoFilter);
    }

    public void execute() {
        for (Change change : this.changes) {
            VirtualFile afterFile;
            ProgressManager.checkCanceled();
            if (change.getAfterRevision() == null || (afterFile = TodoCheckinHandlerWorker.getFileWithRefresh(change.getAfterRevision().getFile())) == null || afterFile.isDirectory() || afterFile.getFileType().isBinary()) continue;
            this.myPsiFile = null;
            if (afterFile.isValid()) {
                this.myPsiFile = (PsiFile)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiFile>(){

                    public PsiFile compute() {
                        return TodoCheckinHandlerWorker.this.myPsiManager.findFile(afterFile);
                    }
                });
            }
            if (this.myPsiFile == null) {
                this.mySkipped.add((Pair<FilePath, String>)Pair.create((Object)change.getAfterRevision().getFile(), (Object)ourInvalidFile));
                continue;
            }
            this.myNewTodoItems = new ArrayList<Object>(Arrays.asList((Object[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<TodoItem[]>(){

                public TodoItem[] compute() {
                    return TodoCheckinHandlerWorker.this.mySearchHelper.findTodoItems(TodoCheckinHandlerWorker.this.myPsiFile);
                }
            })));
            TodoCheckinHandlerWorker.applyFilterAndRemoveDuplicates(this.myNewTodoItems, this.myTodoFilter);
            if (change.getBeforeRevision() == null) {
                if (this.myNewTodoItems.isEmpty()) continue;
                this.myAddedOrEditedTodos.addAll(this.myNewTodoItems);
                continue;
            }
            this.myEditedFileProcessor.process(change, this.myNewTodoItems);
        }
    }

    @Nullable
    private static VirtualFile getFileWithRefresh(@NotNull FilePath filePath) {
        VirtualFile file2 = filePath.getVirtualFile();
        if (file2 == null) {
            file2 = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(filePath.getIOFile());
        }
        return file2;
    }

    private static void applyFilterAndRemoveDuplicates(List<TodoItem> todoItems, TodoFilter filter) {
        TodoItem previous = null;
        Iterator<TodoItem> iterator = todoItems.iterator();
        while (iterator.hasNext()) {
            TodoItem next = iterator.next();
            if (filter != null && !filter.contains(next.getPattern())) {
                iterator.remove();
                continue;
            }
            if (previous != null && next.getTextRange().equals((Object)previous.getTextRange())) {
                iterator.remove();
                continue;
            }
            previous = next;
        }
    }

    public List<TodoItem> getAddedOrEditedTodos() {
        return this.myAddedOrEditedTodos;
    }

    public List<TodoItem> getInChangedTodos() {
        return this.myInChangedTodos;
    }

    public List<Pair<FilePath, String>> getSkipped() {
        return this.mySkipped;
    }

    private static String getTodoText(TodoItem oldItem, String content) {
        String fragment = content.substring(oldItem.getTextRange().getStartOffset(), oldItem.getTextRange().getEndOffset());
        return StringUtil.join((String[])fragment.split("\\s"), (String)" ");
    }

    private static ArrayList<LineFragment> getLineFragments(String fileName, String beforeContent, String afterContent) throws VcsException {
        try {
            DiffFragment[] woFormattingBlocks = DiffPolicy.LINES_WO_FORMATTING.buildFragments(DiffString.create((String)beforeContent), DiffString.create((String)afterContent));
            DiffFragment[] step1lineFragments = new DiffCorrection.TrueLineBlocks(ComparisonPolicy.IGNORE_SPACE).correctAndNormalize(woFormattingBlocks);
            return new DiffFragmentsProcessor().process(step1lineFragments);
        }
        catch (FilesTooBigForDiffException e) {
            throw new VcsException("File " + fileName + " is too big and there are too many changes to build a diff", (Throwable)e);
        }
    }

    public List<TodoItem> inOneList() {
        ArrayList<TodoItem> list = new ArrayList<TodoItem>();
        list.addAll(this.getAddedOrEditedTodos());
        list.addAll(this.getInChangedTodos());
        return list;
    }

    private static class LineFragmentConvertor
    implements Convertor<LineFragment, TextRange> {
        private static final LineFragmentConvertor ourInstance = new LineFragmentConvertor();

        private LineFragmentConvertor() {
        }

        public static LineFragmentConvertor getInstance() {
            return ourInstance;
        }

        public TextRange convert(LineFragment o) {
            TextRange textRange = o.getRange(FragmentSide.SIDE2);
            return new TextRange(textRange.getStartOffset(), textRange.getEndOffset() - 1);
        }
    }

    private static class TodoItemConvertor
    implements Convertor<TodoItem, TextRange> {
        private static final TodoItemConvertor ourInstance = new TodoItemConvertor();

        private TodoItemConvertor() {
        }

        public static TodoItemConvertor getInstance() {
            return ourInstance;
        }

        public TextRange convert(TodoItem o) {
            TextRange textRange = o.getTextRange();
            return new TextRange(textRange.getStartOffset(), textRange.getEndOffset() - 1);
        }
    }

    static interface Acceptor {
        public void skipped(Pair<FilePath, String> var1);

        public void addedOrEdited(TodoItem var1);

        public void inChanged(TodoItem var1);
    }

    private static class MyEditedFileProcessor {
        private String myBeforeContent;
        private String myAfterContent;
        private List<TodoItem> myOldItems;
        private LineFragment myCurrentLineFragment;
        private HashSet<String> myOldTodoTexts;
        private PsiFile myBeforeFile;
        private final PsiFileFactory myPsiFileFactory;
        private FilePath myAfterFile;
        private final Acceptor myAcceptor;
        private final TodoFilter myTodoFilter;

        private MyEditedFileProcessor(Project project2, Acceptor acceptor, TodoFilter todoFilter) {
            this.myAcceptor = acceptor;
            this.myTodoFilter = todoFilter;
            this.myPsiFileFactory = PsiFileFactory.getInstance((Project)project2);
        }

        public void process(Change change, List<TodoItem> newTodoItems) {
            this.myBeforeFile = null;
            this.myOldItems = null;
            this.myOldTodoTexts = null;
            this.myAfterFile = change.getAfterRevision().getFile();
            try {
                this.myBeforeContent = change.getBeforeRevision().getContent();
                this.myAfterContent = change.getAfterRevision().getContent();
                if (this.myAfterContent == null) {
                    this.myAcceptor.skipped((Pair<FilePath, String>)Pair.create((Object)this.myAfterFile, (Object)TodoCheckinHandlerWorker.ourCannotLoadCurrentRevision));
                    return;
                }
                if (this.myBeforeContent == null) {
                    this.myAcceptor.skipped((Pair<FilePath, String>)Pair.create((Object)this.myAfterFile, (Object)TodoCheckinHandlerWorker.ourCannotLoadPreviousRevision));
                    return;
                }
                ArrayList lineFragments = TodoCheckinHandlerWorker.getLineFragments(this.myAfterFile.getPath(), this.myBeforeContent, this.myAfterContent);
                Iterator iterator = lineFragments.iterator();
                while (iterator.hasNext()) {
                    ProgressManager.checkCanceled();
                    LineFragment next = (LineFragment)iterator.next();
                    TextDiffTypeEnum type = next.getType();
                    assert (!TextDiffTypeEnum.CONFLICT.equals((Object)type));
                    if (type != null && !TextDiffTypeEnum.DELETED.equals((Object)type) && !TextDiffTypeEnum.NONE.equals((Object)type)) continue;
                    iterator.remove();
                }
                StepIntersection intersection = new StepIntersection((Convertor)TodoItemConvertor.getInstance(), (Convertor)LineFragmentConvertor.getInstance(), (List)lineFragments, (Getter)new Getter<String>(){

                    public String get() {
                        return myAfterContent;
                    }
                });
                intersection.process(newTodoItems, (PairConsumer)new PairConsumer<TodoItem, LineFragment>(){

                    public void consume(TodoItem todoItem, LineFragment lineFragment) {
                        TextDiffTypeEnum type;
                        ProgressManager.checkCanceled();
                        if (myCurrentLineFragment == null || !myCurrentLineFragment.getRange(FragmentSide.SIDE2).equals((Object)lineFragment.getRange(FragmentSide.SIDE2))) {
                            myCurrentLineFragment = lineFragment;
                            myOldTodoTexts = null;
                        }
                        if (TextDiffTypeEnum.INSERT.equals((Object)(type = lineFragment.getType()))) {
                            myAcceptor.addedOrEdited(todoItem);
                        } else {
                            this.checkEditedFragment(todoItem);
                        }
                    }
                });
            }
            catch (VcsException e) {
                LOG.info((Throwable)e);
                this.myAcceptor.skipped((Pair<FilePath, String>)Pair.create((Object)this.myAfterFile, (Object)TodoCheckinHandlerWorker.ourCannotLoadPreviousRevision));
            }
        }

        private void checkEditedFragment(TodoItem newTodoItem) {
            String text;
            if (this.myBeforeFile == null) {
                this.myBeforeFile = (PsiFile)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiFile>(){

                    public PsiFile compute() {
                        return myPsiFileFactory.createFileFromText("old" + myAfterFile.getName(), myAfterFile.getFileType(), (CharSequence)myBeforeContent);
                    }
                });
            }
            if (this.myOldItems == null) {
                Collection all = LightIndexPatternSearch.SEARCH.createQuery(new IndexPatternSearch.SearchParameters(this.myBeforeFile, (IndexPatternProvider)TodoIndexPatternProvider.getInstance())).findAll();
                TodoItemsCreator todoItemsCreator = new TodoItemsCreator();
                this.myOldItems = new ArrayList<TodoItem>();
                if (all.isEmpty()) {
                    this.myAcceptor.addedOrEdited(newTodoItem);
                    return;
                }
                for (IndexPatternOccurrence occurrence : all) {
                    this.myOldItems.add(todoItemsCreator.createTodo(occurrence));
                }
                TodoCheckinHandlerWorker.applyFilterAndRemoveDuplicates(this.myOldItems, this.myTodoFilter);
            }
            if (this.myOldTodoTexts == null) {
                StepIntersection intersection = new StepIntersection((Convertor)LineFragmentConvertor.getInstance(), (Convertor)TodoItemConvertor.getInstance(), this.myOldItems, (Getter)new Getter<String>(){

                    public String get() {
                        return myBeforeContent;
                    }
                });
                this.myOldTodoTexts = new HashSet();
                intersection.process(Collections.singletonList(this.myCurrentLineFragment), (PairConsumer)new PairConsumer<LineFragment, TodoItem>(){

                    public void consume(LineFragment lineFragment, TodoItem todoItem) {
                        myOldTodoTexts.add(TodoCheckinHandlerWorker.getTodoText(todoItem, myBeforeContent));
                    }
                });
            }
            if (!this.myOldTodoTexts.contains(text = TodoCheckinHandlerWorker.getTodoText(newTodoItem, this.myAfterContent))) {
                this.myAcceptor.addedOrEdited(newTodoItem);
            } else {
                this.myAcceptor.inChanged(newTodoItem);
            }
        }
    }
}

