/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkin;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CheckinHandlerFactory;
import com.intellij.openapi.vcs.checkin.CheckinHandlerUtil;
import com.intellij.openapi.vcs.checkin.CheckinMetaHandler;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.NonFocusableCheckBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class CodeCleanupCheckinHandlerFactory
extends CheckinHandlerFactory {
    @NotNull
    public CheckinHandler createHandler(@NotNull CheckinProjectPanel panel, @NotNull CommitContext commitContext) {
        return new CleanupCodeCheckinHandler(panel);
    }

    private static class CleanupCodeCheckinHandler
    extends CheckinHandler
    implements CheckinMetaHandler {
        private final CheckinProjectPanel myPanel;
        private Project myProject;

        public CleanupCodeCheckinHandler(CheckinProjectPanel panel) {
            this.myProject = panel.getProject();
            this.myPanel = panel;
        }

        public RefreshableOnComponent getBeforeCheckinConfigurationPanel() {
            NonFocusableCheckBox cleanupCodeCb = new NonFocusableCheckBox(VcsBundle.message((String)"before.checkin.cleanup.code", (Object[])new Object[0]));
            return new RefreshableOnComponent((JCheckBox)cleanupCodeCb){
                final /* synthetic */ JCheckBox val$cleanupCodeCb;
                {
                    this.val$cleanupCodeCb = jCheckBox;
                }

                public JComponent getComponent() {
                    JPanel cbPanel = new JPanel(new BorderLayout());
                    cbPanel.add((Component)this.val$cleanupCodeCb, "West");
                    CheckinHandlerUtil.disableWhenDumb(myProject, this.val$cleanupCodeCb, "Code analysis is impossible until indices are up-to-date");
                    return cbPanel;
                }

                public void refresh() {
                }

                public void saveState() {
                    VcsConfiguration.getInstance((Project)((CleanupCodeCheckinHandler)this).myProject).CHECK_CODE_CLEANUP_BEFORE_PROJECT_COMMIT = this.val$cleanupCodeCb.isSelected();
                }

                public void restoreState() {
                    this.val$cleanupCodeCb.setSelected(VcsConfiguration.getInstance((Project)((CleanupCodeCheckinHandler)this).myProject).CHECK_CODE_CLEANUP_BEFORE_PROJECT_COMMIT);
                }
            };
        }

        public void runCheckinHandlers(@NotNull Runnable runnable2) {
            if (VcsConfiguration.getInstance((Project)this.myProject).CHECK_CODE_CLEANUP_BEFORE_PROJECT_COMMIT && !DumbService.isDumb((Project)this.myProject)) {
                List<VirtualFile> filesToProcess = CheckinHandlerUtil.filterOutGeneratedAndExcludedFiles(this.myPanel.getVirtualFiles(), this.myProject);
                GlobalInspectionContextBase.codeCleanup(this.myProject, new AnalysisScope(this.myProject, filesToProcess), runnable2);
            } else {
                runnable2.run();
            }
        }
    }
}

