/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.NewEditChangelistPanel;
import java.awt.Component;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class EditChangelistDialog
extends DialogWrapper {
    private final NewEditChangelistPanel myPanel;
    private final Project myProject;
    private final LocalChangeList myList;

    public EditChangelistDialog(Project project2, @NotNull LocalChangeList list) {
        super(project2, true);
        this.myProject = project2;
        this.myList = list;
        this.myPanel = new NewEditChangelistPanel(project2){

            @Override
            protected void nameChanged(String errorMessage) {
                EditChangelistDialog.this.setOKActionEnabled(errorMessage == null);
                EditChangelistDialog.this.setErrorText(errorMessage);
            }
        };
        this.myPanel.setChangeListName(list.getName());
        this.myPanel.setDescription(list.getComment());
        this.myPanel.init(list);
        this.myPanel.getMakeActiveCheckBox().setSelected(this.myList.isDefault());
        this.myPanel.getMakeActiveCheckBox().setEnabled(!this.myList.isDefault());
        this.setTitle(VcsBundle.message((String)"changes.dialog.editchangelist.title", (Object[])new Object[0]));
        this.init();
    }

    protected JComponent createCenterPanel() {
        return this.myPanel.getContent();
    }

    protected void doOKAction() {
        String oldName = this.myList.getName();
        String oldComment = this.myList.getComment();
        if (!Comparing.equal((String)oldName, (String)this.myPanel.getChangeListName()) && ChangeListManager.getInstance((Project)this.myProject).findChangeList(this.myPanel.getChangeListName()) != null) {
            Messages.showErrorDialog((Component)this.myPanel.getContent(), (String)VcsBundle.message((String)"changes.dialog.editchangelist.error.already.exists", (Object[])new Object[]{this.myPanel.getChangeListName()}), (String)VcsBundle.message((String)"changes.dialog.editchangelist.title", (Object[])new Object[0]));
            return;
        }
        if (!Comparing.equal((String)oldName, (String)this.myPanel.getChangeListName(), (boolean)true) || !Comparing.equal((String)oldComment, (String)this.myPanel.getDescription(), (boolean)true)) {
            ChangeListManager clManager = ChangeListManager.getInstance((Project)this.myProject);
            String newName = this.myPanel.getChangeListName();
            if (!this.myList.getName().equals(newName)) {
                clManager.editName(this.myList.getName(), newName);
            }
            String newDescription = this.myPanel.getDescription();
            if (!this.myList.getComment().equals(newDescription)) {
                clManager.editComment(this.myList.getName(), newDescription);
            }
        }
        if (!this.myList.isDefault() && this.myPanel.getMakeActiveCheckBox().isSelected()) {
            ChangeListManager.getInstance((Project)this.myProject).setDefaultChangeList(this.myList);
        }
        this.myPanel.changelistCreatedOrChanged(this.myList);
        super.doOKAction();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myPanel.getPreferredFocusedComponent();
    }

    protected String getDimensionServiceKey() {
        return "VCS.EditChangelistDialog";
    }
}

