/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListEditHandler;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.LocalChangeListImpl;
import com.intellij.openapi.vcs.changes.ui.ChangeListChooserPanel;
import com.intellij.util.NullableConsumer;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeListChooser
extends DialogWrapper {
    private final Project myProject;
    private LocalChangeList mySelectedList;
    private final ChangeListChooserPanel myPanel;

    public ChangeListChooser(@NotNull Project project2, @NotNull Collection<? extends ChangeList> changelists, @Nullable ChangeList defaultSelection, String title, @Nullable String defaultName) {
        super(project2, false);
        ChangeList changelist;
        ChangeListEditHandler handler2;
        this.myProject = project2;
        Iterator<? extends ChangeList> iterator = changelists.iterator();
        while (iterator.hasNext() && (handler2 = ((LocalChangeListImpl)(changelist = iterator.next())).getEditHandler()) == null) {
        }
        this.myPanel = new ChangeListChooserPanel(this.myProject, new NullableConsumer<String>(){

            public void consume(@Nullable String errorMessage) {
                ChangeListChooser.this.setOKActionEnabled(errorMessage == null);
                ChangeListChooser.this.setErrorText(errorMessage);
            }
        });
        this.myPanel.init();
        this.myPanel.setChangeLists(changelists);
        this.myPanel.setDefaultSelection(defaultSelection);
        this.setTitle(title);
        if (defaultName != null) {
            this.myPanel.setDefaultName(defaultName);
        }
        this.init();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myPanel.getPreferredFocusedComponent();
    }

    protected String getDimensionServiceKey() {
        return "VCS.ChangelistChooser";
    }

    protected void doOKAction() {
        this.mySelectedList = this.myPanel.getSelectedList(this.myProject);
        if (this.mySelectedList != null) {
            super.doOKAction();
        }
    }

    public LocalChangeList getSelectedList() {
        return this.mySelectedList;
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }
}

