/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.GenericPatchApplier;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class LazyPatchContentRevision
implements ContentRevision {
    private volatile String myContent;
    private final VirtualFile myVf;
    private final FilePath myNewFilePath;
    private final String myRevision;
    private final TextFilePatch myPatch;
    private volatile boolean myPatchApplyFailed;

    public LazyPatchContentRevision(VirtualFile vf, FilePath newFilePath, String revision, TextFilePatch patch) {
        this.myVf = vf;
        this.myNewFilePath = newFilePath;
        this.myRevision = revision;
        this.myPatch = patch;
    }

    public String getContent() {
        if (this.myContent == null) {
            String localContext = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                public String compute() {
                    Document doc = FileDocumentManager.getInstance().getDocument(LazyPatchContentRevision.this.myVf);
                    return doc == null ? null : doc.getText();
                }
            });
            if (localContext == null) {
                this.myPatchApplyFailed = true;
                return null;
            }
            GenericPatchApplier applier = new GenericPatchApplier(localContext, this.myPatch.getHunks());
            if (applier.execute()) {
                this.myContent = applier.getAfter();
            } else {
                this.myPatchApplyFailed = true;
            }
        }
        return this.myContent;
    }

    public boolean isPatchApplyFailed() {
        return this.myPatchApplyFailed;
    }

    @NotNull
    public FilePath getFile() {
        return this.myNewFilePath;
    }

    @NotNull
    public VcsRevisionNumber getRevisionNumber() {
        return new VcsRevisionNumber(){

            public String asString() {
                return LazyPatchContentRevision.this.myRevision;
            }

            public int compareTo(VcsRevisionNumber o) {
                return 0;
            }
        };
    }
}

