/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplyPatchMergeRequest
extends MergeRequest {
    @Nullable
    private final Project myProject;
    @NotNull
    private final Document myDocument;
    @NotNull
    private final CharSequence myOriginalContent;
    @NotNull
    private final String myLocalContent;
    @NotNull
    private final String myPatchedContent;
    @NotNull
    private final String myWindowTitle;
    @NotNull
    private final String myLocalTitle;
    @NotNull
    private final String myPatchedTitle;
    @Nullable
    private final Consumer<MergeResult> myCallback;

    public ApplyPatchMergeRequest(@Nullable Project project2, @NotNull Document document, @NotNull String localContent, @NotNull String patchedContent, @NotNull String windowTitle, @NotNull String localTitle, @NotNull String patchedTitle, @Nullable Consumer<MergeResult> callback) {
        this.myProject = project2;
        this.myDocument = document;
        this.myOriginalContent = (CharSequence)ApplicationManager.getApplication().runReadAction((Computable)new Computable<CharSequence>(){

            public CharSequence compute() {
                return ApplyPatchMergeRequest.this.myDocument.getImmutableCharSequence();
            }
        });
        this.myLocalContent = localContent;
        this.myPatchedContent = patchedContent;
        this.myWindowTitle = windowTitle;
        this.myLocalTitle = localTitle;
        this.myPatchedTitle = patchedTitle;
        this.myCallback = callback;
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public Document getDocument() {
        return this.myDocument;
    }

    @NotNull
    public String getLocalContent() {
        return this.myLocalContent;
    }

    @NotNull
    public String getPatchedContent() {
        return this.myPatchedContent;
    }

    @Nullable
    public String getTitle() {
        return this.myWindowTitle;
    }

    @NotNull
    public String getLocalTitle() {
        return this.myLocalTitle;
    }

    @NotNull
    public String getPatchedTitle() {
        return this.myPatchedTitle;
    }

    public void applyResult(@NotNull MergeResult result) {
        CharSequence applyContent;
        switch (result) {
            case CANCEL: {
                applyContent = this.myOriginalContent;
                break;
            }
            case LEFT: {
                applyContent = this.myLocalContent;
                break;
            }
            case RIGHT: {
                applyContent = this.myPatchedContent;
                break;
            }
            case RESOLVED: {
                applyContent = null;
                break;
            }
            default: {
                throw new IllegalArgumentException(result.name());
            }
        }
        if (applyContent != null) {
            new WriteCommandAction.Simple(this.myProject, new PsiFile[0]){

                protected void run() throws Throwable {
                    ApplyPatchMergeRequest.this.myDocument.setText(applyContent);
                }
            }.execute();
        }
        if (this.myCallback != null) {
            this.myCallback.consume((Object)result);
        }
    }
}

