/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.diff.DiffManager;
import com.intellij.diff.InvalidDiffRequestException;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.MergeTool;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.ApplyPatchContext;
import com.intellij.openapi.diff.impl.patch.ApplyPatchStatus;
import com.intellij.openapi.diff.impl.patch.BaseRevisionTextPatchEP;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PatchEP;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatchBase;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsApplicationSettings;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchDefaultExecutor;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchDifferentiatedDialog;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchForBaseRevisionTexts;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchMode;
import com.intellij.openapi.vcs.changes.patch.ImportToShelfExecutor;
import com.intellij.openapi.vcs.changes.patch.PatchDiffRequestFactory;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplyPatchAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.patch.ApplyPatchAction");

    public void update(AnActionEvent e) {
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        if (ApplyPatchAction.isProjectOrScopeView(e.getPlace())) {
            VirtualFile vFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
            e.getPresentation().setEnabledAndVisible(project2 != null && ApplyPatchAction.isPatchFile(vFile));
        } else {
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(project2 != null);
        }
    }

    private static boolean isPatchFile(@Nullable VirtualFile vFile) {
        return vFile != null && vFile.getFileType() == StdFileTypes.PATCH;
    }

    public void actionPerformed(AnActionEvent e) {
        final Project project2 = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        if (ChangeListManager.getInstance((Project)project2).isFreezedWithNotification("Can not apply patch now")) {
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        VirtualFile vFile = null;
        String place = e.getPlace();
        if (ApplyPatchAction.isProjectOrScopeView(place) || "MainMenu".equals(place)) {
            vFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        }
        if (ApplyPatchAction.isPatchFile(vFile)) {
            ApplyPatchAction.showApplyPatch(project2, vFile);
        } else {
            FileChooserDescriptor descriptor = ApplyPatchDifferentiatedDialog.createSelectPatchDescriptor();
            final VcsApplicationSettings settings = VcsApplicationSettings.getInstance();
            VirtualFile toSelect = settings.PATCH_STORAGE_LOCATION == null ? null : LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(settings.PATCH_STORAGE_LOCATION));
            FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)project2, (VirtualFile)toSelect, (Consumer)new Consumer<VirtualFile>(){

                public void consume(VirtualFile file2) {
                    VirtualFile parent = file2.getParent();
                    if (parent != null) {
                        settings.PATCH_STORAGE_LOCATION = FileUtil.toSystemDependentName((String)parent.getPath());
                    }
                    ApplyPatchAction.showApplyPatch(project2, file2);
                }
            });
        }
    }

    private static boolean isProjectOrScopeView(@NotNull String place) {
        return place.equals("ProjectViewPopup") || place.equals("ScopeViewPopup");
    }

    public static void showApplyPatch(@NotNull Project project2, @NotNull VirtualFile file2) {
        ApplyPatchDifferentiatedDialog dialog = new ApplyPatchDifferentiatedDialog(project2, new ApplyPatchDefaultExecutor(project2), Collections.singletonList(new ImportToShelfExecutor(project2)), ApplyPatchMode.APPLY, file2);
        dialog.show();
    }

    public static void applySkipDirs(List<FilePatch> patches, int skipDirs) {
        if (skipDirs < 1) {
            return;
        }
        for (FilePatch patch : patches) {
            patch.setBeforeName(ApplyPatchAction.skipN(patch.getBeforeName(), skipDirs));
            patch.setAfterName(ApplyPatchAction.skipN(patch.getAfterName(), skipDirs));
        }
    }

    private static String skipN(String path, int num) {
        String[] pieces = path.split("/");
        StringBuilder sb = new StringBuilder();
        for (int i = num; i < pieces.length; ++i) {
            String piece = pieces[i];
            sb.append('/').append(piece);
        }
        return sb.toString();
    }

    @NotNull
    public static ApplyPatchStatus applyOnly(@Nullable Project project2, @NotNull ApplyFilePatchBase patch, @Nullable ApplyPatchContext context, @NotNull VirtualFile file2, @Nullable CommitContext commitContext, boolean reverse, @Nullable String leftPanelTitle, @Nullable String rightPanelTitle) {
        ApplyFilePatch.Result result = ApplyPatchAction.tryApplyPatch(project2, patch, context, file2, commitContext);
        ApplyPatchStatus status = result.getStatus();
        if (ApplyPatchStatus.ALREADY_APPLIED.equals((Object)status) || ApplyPatchStatus.SUCCESS.equals((Object)status)) {
            return status;
        }
        ApplyPatchForBaseRevisionTexts mergeData = result.getMergeData();
        if (mergeData == null) {
            return status;
        }
        final Document document = FileDocumentManager.getInstance().getDocument(file2);
        if (document == null) {
            return ApplyPatchStatus.FAILURE;
        }
        String baseContent = ApplyPatchAction.toString(mergeData.getBase());
        String localContent = ApplyPatchAction.toString(mergeData.getLocal());
        String patchedContent = mergeData.getPatched();
        if (localContent == null) {
            return ApplyPatchStatus.FAILURE;
        }
        final Ref applyPatchStatusReference = new Ref();
        Consumer<MergeResult> callback = new Consumer<MergeResult>(){

            public void consume(MergeResult result) {
                FileDocumentManager.getInstance().saveDocument(document);
                applyPatchStatusReference.setIfNull((Object)(result != MergeResult.CANCEL ? ApplyPatchStatus.SUCCESS : ApplyPatchStatus.FAILURE));
            }
        };
        try {
            MergeRequest request;
            if (baseContent != null) {
                if (reverse) {
                    if (leftPanelTitle == null) {
                        leftPanelTitle = VcsBundle.message((String)"patch.apply.conflict.patched.version", (Object[])new Object[0]);
                    }
                    if (rightPanelTitle == null) {
                        rightPanelTitle = VcsBundle.message((String)"patch.apply.conflict.local.version", (Object[])new Object[0]);
                    }
                    List contents = ContainerUtil.list((Object[])new String[]{patchedContent, baseContent, localContent});
                    List titles = ContainerUtil.list((Object[])new String[]{leftPanelTitle, null, rightPanelTitle});
                    request = PatchDiffRequestFactory.createMergeRequest(project2, document, file2, contents, null, titles, callback);
                } else {
                    request = PatchDiffRequestFactory.createMergeRequest(project2, document, file2, baseContent, localContent, patchedContent, callback);
                }
            } else {
                request = PatchDiffRequestFactory.createBadMergeRequest(project2, document, file2, localContent, patchedContent, callback);
            }
            request.putUserData(DiffUserDataKeysEx.MERGE_ACTION_CAPTIONS, (Object)new Function<MergeResult, String>(){

                public String fun(MergeResult result) {
                    return result.equals((Object)MergeResult.CANCEL) ? "Abort..." : null;
                }
            });
            request.putUserData(DiffUserDataKeysEx.MERGE_CANCEL_HANDLER, (Object)new Condition<MergeTool.MergeViewer>(){

                public boolean value(MergeTool.MergeViewer viewer) {
                    int result = Messages.showYesNoCancelDialog((Component)viewer.getComponent().getRootPane(), (String)"Would you like to abort applying patch action?", (String)"Close Merge", (String)"Abort", (String)"Skip File", (String)"Cancel", (Icon)Messages.getQuestionIcon());
                    if (result == 0) {
                        applyPatchStatusReference.set((Object)ApplyPatchStatus.ABORT);
                    } else if (result == 1) {
                        applyPatchStatusReference.set((Object)ApplyPatchStatus.SKIP);
                    }
                    return result != 2;
                }
            });
            DiffManager.getInstance().showMerge(project2, request);
            return (ApplyPatchStatus)((Object)applyPatchStatusReference.get());
        }
        catch (InvalidDiffRequestException e) {
            LOG.warn((Throwable)e);
            return ApplyPatchStatus.FAILURE;
        }
    }

    @NotNull
    private static ApplyFilePatch.Result tryApplyPatch(final @Nullable Project project2, final @NotNull ApplyFilePatchBase patch, final @Nullable ApplyPatchContext context, final @NotNull VirtualFile file2, final @Nullable CommitContext commitContext) {
        final Object patchBase = patch.getPatch();
        return (ApplyFilePatch.Result)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<ApplyFilePatch.Result>(){

            public ApplyFilePatch.Result compute() {
                try {
                    return patch.apply(file2, context, project2, VcsUtil.getFilePath((VirtualFile)file2), new Getter<CharSequence>(){

                        public CharSequence get() {
                            BaseRevisionTextPatchEP baseRevisionTextPatchEP = (BaseRevisionTextPatchEP)Extensions.findExtension((ExtensionPointName)PatchEP.EP_NAME, (AreaInstance)project2, BaseRevisionTextPatchEP.class);
                            String path = (String)ObjectUtils.chooseNotNull((Object)patchBase.getBeforeName(), (Object)patchBase.getAfterName());
                            return baseRevisionTextPatchEP.provideContent(path, commitContext);
                        }
                    }, commitContext);
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                    return ApplyFilePatch.Result.createThrow(e);
                }
            }
        });
    }

    @Nullable
    private static String toString(@Nullable CharSequence charSequence) {
        return charSequence != null ? StringUtil.convertLineSeparators((String)charSequence.toString()) : null;
    }
}

