/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.issueLinks;

import com.intellij.ui.ClickListener;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.Consumer;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LinkMouseListenerBase<T>
extends ClickListener
implements MouseMotionListener {
    public static void installSingleTagOn(@NotNull SimpleColoredComponent component) {
        new LinkMouseListenerBase<Object>(){

            @Override
            @Nullable
            protected Object getTagAt(@NotNull MouseEvent e) {
                return ((SimpleColoredComponent)e.getSource()).getFragmentTagAt(e.getX());
            }

            @Override
            protected void handleTagClick(@Nullable Object tag, @NotNull MouseEvent event) {
                if (tag != null) {
                    if (tag instanceof Consumer) {
                        ((Consumer)tag).consume((Object)event);
                    } else {
                        ((Runnable)tag).run();
                    }
                }
            }
        }.installOn((Component)component);
    }

    @Nullable
    protected abstract T getTagAt(@NotNull MouseEvent var1);

    public boolean onClick(@NotNull MouseEvent e, int clickCount) {
        if (e.getButton() == 1) {
            this.handleTagClick(this.getTagAt(e), e);
        }
        return false;
    }

    protected void handleTagClick(@Nullable T tag, @NotNull MouseEvent event) {
        if (tag instanceof Runnable) {
            ((Runnable)tag).run();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Component component = (Component)e.getSource();
        T tag = this.getTagAt(e);
        if (tag != null) {
            component.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            component.setCursor(Cursor.getDefaultCursor());
        }
    }

    public void installOn(@NotNull Component component) {
        super.installOn(component);
        component.addMouseMotionListener(this);
    }
}

