/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.dbCommitted;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.BackgroundTaskQueue;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CachingCommittedChangesProvider;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsType;
import com.intellij.openapi.vcs.changes.committed.CachesHolder;
import com.intellij.openapi.vcs.changes.committed.RepositoryLocationCache;
import com.intellij.openapi.vcs.changes.dbCommitted.KnownRepositoryLocations;
import com.intellij.openapi.vcs.changes.dbCommitted.PathState;
import com.intellij.openapi.vcs.changes.dbCommitted.RevisionId;
import com.intellij.openapi.vcs.changes.dbCommitted.VcsSqliteLayer;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.util.PairProcessor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class HistoryCacheManager {
    private final Project myProject;
    private final BackgroundTaskQueue myQueue;
    private RepositoryLocationCache myRepositoryLocationCache;
    private CachesHolder myCachesHolder;
    private final KnownRepositoryLocations myKnownRepositoryLocations;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.dbCommitted.HistoryCacheManager");
    private VcsSqliteLayer myDbUtil;

    public HistoryCacheManager(Project project2) {
        this.myProject = project2;
        this.myQueue = new BackgroundTaskQueue(this.myProject, "VCS project history cache update");
        this.myKnownRepositoryLocations = new KnownRepositoryLocations();
        this.myRepositoryLocationCache = new RepositoryLocationCache(this.myProject);
        this.myCachesHolder = new CachesHolder(this.myProject, this.myRepositoryLocationCache);
        this.myDbUtil = new VcsSqliteLayer(this.myProject, this.myKnownRepositoryLocations);
    }

    public void initIfNeeded() {
        this.myQueue.run(new CreateInitDatabase());
    }

    public static List<AbstractVcs> getGoodActiveVcses(Project project2) {
        AbstractVcs[] abstractVcses = ProjectLevelVcsManager.getInstance((Project)project2).getAllActiveVcss();
        SmartList result = new SmartList();
        for (AbstractVcs vcs : abstractVcses) {
            if (!(vcs.getCommittedChangesProvider() instanceof CachingCommittedChangesProvider) || !VcsType.centralized.equals((Object)vcs.getType())) continue;
            result.add(vcs);
        }
        return result;
    }

    public void appendChanges(AbstractVcs vcs, String root, List<CommittedChangeList> lists) {
        this.myQueue.run(new AppendChanges(vcs, root, lists));
    }

    public List<CommittedChangeList> readListsByDates(AbstractVcs vcs, RepositoryLocation location, long lastTs, long oldTs, String subfolder) throws VcsException {
        return this.myDbUtil.readLists(vcs, location, RevisionId.createTime(lastTs), RevisionId.createTime(oldTs), subfolder);
    }

    public List<CommittedChangeList> readLists(AbstractVcs vcs, RepositoryLocation location, long lastRev, long oldRev) throws VcsException {
        return this.myDbUtil.readLists(vcs, location, lastRev, oldRev);
    }

    public long getLastRevision(AbstractVcs vcs, RepositoryLocation location) {
        return this.myDbUtil.getLastRevision(vcs, this.location2string(location)).getNumber();
    }

    private String location2string(RepositoryLocation location) {
        return FileUtil.toSystemIndependentName((String)location.toPresentableString());
    }

    public long getFirstRevision(AbstractVcs vcs, RepositoryLocation location) {
        return this.myDbUtil.getFirstRevision(vcs, this.location2string(location)).getNumber();
    }

    public PathState getPathState(AbstractVcs vcs, RepositoryLocation location, String path) throws VcsException {
        return this.myDbUtil.getPathState(vcs, location, path);
    }

    private class CreateInitDatabase
    extends Task.Backgroundable {
        private VcsException myException;

        public CreateInitDatabase() {
            super(HistoryCacheManager.this.myProject, "Update VCS and roots data", false);
        }

        public void run(@NotNull ProgressIndicator indicator) {
            try {
                indicator.setText2("Updating VCS and roots");
                final MultiMap map = new MultiMap();
                HistoryCacheManager.this.myCachesHolder.iterateAllRepositoryLocations(new PairProcessor<RepositoryLocation, AbstractVcs>(){

                    public boolean process(RepositoryLocation location, AbstractVcs vcs) {
                        map.putValue((Object)vcs.getName(), (Object)HistoryCacheManager.this.location2string(location));
                        return true;
                    }
                });
                HistoryCacheManager.this.myDbUtil.checkVcsRootsAreTracked((MultiMap<String, String>)map);
            }
            catch (VcsException e) {
                LOG.info((Throwable)e);
                this.myException = e;
            }
        }

        public void onSuccess() {
            if (this.myException != null) {
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    throw new RuntimeException(this.myException);
                }
                VcsBalloonProblemNotifier.showOverChangesView(this.myProject, this.myException.getMessage(), MessageType.ERROR, new NamedRunnable[0]);
            }
        }
    }

    private class AppendChanges
    extends Task.Backgroundable {
        private final List<CommittedChangeList> myLists;
        private final String myRoot;
        private final AbstractVcs myVcs;
        private VcsException myException;

        private AppendChanges(AbstractVcs vcs, String root, List<CommittedChangeList> lists) {
            super(HistoryCacheManager.this.myProject, "Append data to history caches", false);
            this.myLists = lists;
            this.myVcs = vcs;
            this.myRoot = FileUtil.toSystemIndependentName((String)root);
        }

        public void run(@NotNull ProgressIndicator indicator) {
            try {
                HistoryCacheManager.this.myDbUtil.appendLists(this.myVcs, this.myRoot, this.myLists);
            }
            catch (VcsException e) {
                this.myException = e;
            }
        }

        public void onSuccess() {
            if (this.myException != null) {
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    throw new RuntimeException(this.myException);
                }
                VcsBalloonProblemNotifier.showOverChangesView(this.myProject, this.myException.getMessage(), MessageType.ERROR, new NamedRunnable[0]);
            }
        }
    }
}

