/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.conflicts;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusFactory;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictTracker;
import com.intellij.openapi.vcs.impl.FileStatusProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.util.ThreeState;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangelistConflictFileStatusProvider
implements FileStatusProvider {
    private static final FileStatus MODIFIED_OUTSIDE = FileStatusFactory.getInstance().createFileStatus("modifiedOutside", "Modified in not active changelist", FileStatus.COLOR_MODIFIED.brighter());
    private static final FileStatus ADDED_OUTSIDE = FileStatusFactory.getInstance().createFileStatus("addedOutside", "Added in not active changelist", FileStatus.COLOR_ADDED.brighter());
    private static final FileStatus CHANGELIST_CONFLICT = FileStatusFactory.getInstance().createFileStatus("changelistConflict", "Changelist conflict", (Color)JBColor.RED);
    private final ChangelistConflictTracker myConflictTracker;
    private final ChangeListManager myChangeListManager;

    public ChangelistConflictFileStatusProvider(ChangeListManagerImpl changeListManager) {
        this.myChangeListManager = changeListManager;
        this.myConflictTracker = changeListManager.getConflictTracker();
    }

    @Override
    @Nullable
    public FileStatus getFileStatus(@NotNull VirtualFile virtualFile) {
        FileStatus status;
        ChangelistConflictTracker.Options options = this.myConflictTracker.getOptions();
        if (!options.TRACKING_ENABLED) {
            return null;
        }
        boolean conflict = this.myConflictTracker.hasConflict(virtualFile);
        if (conflict && options.HIGHLIGHT_CONFLICTS) {
            return CHANGELIST_CONFLICT;
        }
        if (options.HIGHLIGHT_NON_ACTIVE_CHANGELIST && ((status = this.myChangeListManager.getStatus(virtualFile)) == FileStatus.MODIFIED || status == FileStatus.ADDED) && !this.myConflictTracker.isFromActiveChangelist(virtualFile)) {
            return status == FileStatus.MODIFIED ? MODIFIED_OUTSIDE : ADDED_OUTSIDE;
        }
        return null;
    }

    @Override
    public void refreshFileStatusFromDocument(@NotNull VirtualFile virtualFile, @NotNull Document doc) {
    }

    @Override
    @NotNull
    public ThreeState getNotChangedDirectoryParentingStatus(@NotNull VirtualFile virtualFile) {
        throw new UnsupportedOperationException("Shouldn't be called");
    }
}

