/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class RepositoryLocationCache {
    private final Project myProject;
    private final Map<Couple<String>, RepositoryLocation> myMap;

    public RepositoryLocationCache(Project project2) {
        this.myProject = project2;
        this.myMap = Collections.synchronizedMap(new HashMap());
        MessageBusConnection connection = this.myProject.getMessageBus().connect();
        VcsListener listener2 = new VcsListener(){

            public void directoryMappingChanged() {
                RepositoryLocationCache.this.reset();
            }
        };
        connection.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, (Object)listener2);
        connection.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED_IN_PLUGIN, (Object)listener2);
    }

    public RepositoryLocation getLocation(AbstractVcs vcs, FilePath filePath, boolean silent) {
        Couple key = Couple.of((Object)vcs.getName(), (Object)filePath.getPath());
        RepositoryLocation location = this.myMap.get(key);
        if (location != null) {
            return location;
        }
        location = this.getUnderProgress(vcs, filePath, silent);
        this.myMap.put((Couple<String>)key, location);
        return location;
    }

    private RepositoryLocation getUnderProgress(AbstractVcs vcs, FilePath filePath, boolean silent) {
        MyLoader loader = new MyLoader(vcs, filePath);
        if (!silent && ApplicationManager.getApplication().isDispatchThread()) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously((Runnable)loader, "Discovering location of " + filePath.getPresentableUrl(), true, this.myProject);
        } else {
            loader.run();
        }
        return loader.getLocation();
    }

    public void reset() {
        this.myMap.clear();
    }

    private class MyLoader
    implements Runnable {
        private final AbstractVcs myVcs;
        private final FilePath myFilePath;
        private RepositoryLocation myLocation;

        private MyLoader(@NotNull AbstractVcs vcs, FilePath filePath) {
            this.myVcs = vcs;
            this.myFilePath = filePath;
        }

        @Override
        public void run() {
            CommittedChangesProvider committedChangesProvider = this.myVcs.getCommittedChangesProvider();
            if (committedChangesProvider != null) {
                this.myLocation = committedChangesProvider.getLocationFor(this.myFilePath);
            }
        }

        public RepositoryLocation getLocation() {
            return this.myLocation;
        }
    }
}

