/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.vcs.changes.committed.ChangeListFilteringStrategy;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesFilterKey;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;

public class CompositeChangeListFilteringStrategy
implements ChangeListFilteringStrategy {
    private final TreeMap<CommittedChangesFilterKey, ChangeListFilteringStrategy> myDelegates = new TreeMap();
    private boolean myInSetBase = false;

    public JComponent getFilterUI() {
        return null;
    }

    public CommittedChangesFilterKey getKey() {
        throw new UnsupportedOperationException();
    }

    public void setFilterBase(List<CommittedChangeList> changeLists) {
        this.setFilterBaseImpl(changeLists, true);
    }

    private List<CommittedChangeList> setFilterBaseImpl(List<CommittedChangeList> changeLists, boolean setFirst) {
        if (this.myInSetBase) {
            return changeLists;
        }
        this.myInSetBase = true;
        List<Object> list = new ArrayList<CommittedChangeList>(changeLists);
        boolean callSetFilterBase = setFirst;
        for (ChangeListFilteringStrategy delegate : this.myDelegates.values()) {
            if (callSetFilterBase) {
                delegate.setFilterBase(list);
            }
            callSetFilterBase = true;
            list = delegate.filterChangeLists(list);
        }
        this.myInSetBase = false;
        return list;
    }

    public void addChangeListener(ChangeListener listener2) {
        for (ChangeListFilteringStrategy delegate : this.myDelegates.values()) {
            delegate.addChangeListener(listener2);
        }
    }

    public void removeChangeListener(ChangeListener listener2) {
        for (ChangeListFilteringStrategy delegate : this.myDelegates.values()) {
            delegate.removeChangeListener(listener2);
        }
    }

    public void resetFilterBase() {
        for (ChangeListFilteringStrategy delegate : this.myDelegates.values()) {
            delegate.resetFilterBase();
        }
    }

    public void appendFilterBase(List<CommittedChangeList> changeLists) {
        List<Object> list = new ArrayList<CommittedChangeList>(changeLists);
        for (ChangeListFilteringStrategy delegate : this.myDelegates.values()) {
            delegate.appendFilterBase(list);
            list = delegate.filterChangeLists(list);
        }
    }

    @NotNull
    public List<CommittedChangeList> filterChangeLists(List<CommittedChangeList> changeLists) {
        return this.setFilterBaseImpl(changeLists, false);
    }

    public void addStrategy(CommittedChangesFilterKey key, ChangeListFilteringStrategy strategy) {
        this.myDelegates.put(key, strategy);
    }

    public ChangeListFilteringStrategy removeStrategy(CommittedChangesFilterKey key) {
        return this.myDelegates.remove(key);
    }
}

